/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMetalDecoration1
extends BlockIEBase.IELadderBlock<BlockTypes_MetalDecoration1> {
    public BlockMetalDecoration1() {
        super("metal_decoration1", Material.IRON, PropertyEnum.create((String)"type", BlockTypes_MetalDecoration1.class), ItemBlockIEBase.class, BlockFence.NORTH, BlockFence.SOUTH, BlockFence.WEST, BlockFence.EAST);
        this.setHardness(3.0f);
        this.setResistance(15.0f);
        this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
        this.setAllNotNormalBlock();
        this.lightOpacity = 0;
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == 0 && !itemBlock) {
            return "steel_fence";
        }
        if (meta == 4 && !itemBlock) {
            return "aluminum_fence";
        }
        return null;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        int meta = this.getMetaFromState(world.getBlockState(pos));
        if (meta == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            IBlockState connector = world.getBlockState(pos.offset(facing));
            return connector.getBlock() instanceof BlockMetalDecoration1 && this.getMetaFromState(connector) == meta;
        }
        return super.canBeConnectedTo(world, pos, facing);
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            return side != EnumFacing.UP && side != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
        }
        return BlockFaceShape.SOLID;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            return side == EnumFacing.UP;
        }
        if (((BlockTypes_MetalDecoration1)((Object)state.getValue((IProperty)this.property))).isScaffold()) {
            return true;
        }
        return super.isSideSolid(state, world, pos, side);
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state2;
        int meta = this.getMetaFromState(state);
        if (((BlockTypes_MetalDecoration1)((Object)state.getValue((IProperty)this.property))).isScaffold() && this.equals((state2 = world.getBlockState(pos.offset(side))).getBlock())) {
            return this.getMetaFromState(state2) != meta;
        }
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getMetaFromState(state = super.getActualState(state, world, pos)) == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || this.getMetaFromState(state) == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            for (EnumFacing f : EnumFacing.HORIZONTALS) {
                state = state.withProperty((IProperty)(f == EnumFacing.NORTH ? BlockFence.NORTH : (f == EnumFacing.SOUTH ? BlockFence.SOUTH : (f == EnumFacing.WEST ? BlockFence.WEST : BlockFence.EAST))), (Comparable)Boolean.valueOf(Utils.canFenceConnectTo(world, pos, f, this.blockMaterial)));
            }
        }
        return state;
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        int meta = this.getMetaFromState(state = state.getActualState((IBlockAccess)worldIn, pos));
        if (meta == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.PILLAR_AABB);
            if (((Boolean)state.getValue((IProperty)BlockFence.NORTH)).booleanValue()) {
                BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.NORTH_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.EAST)).booleanValue()) {
                BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.EAST_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.SOUTH)).booleanValue()) {
                BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.SOUTH_AABB);
            }
            if (((Boolean)state.getValue((IProperty)BlockFence.WEST)).booleanValue()) {
                BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockFence.WEST_AABB);
            }
        } else {
            BlockMetalDecoration1.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        if (meta == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta() || meta == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()) {
            return new AxisAlignedBB(Utils.canFenceConnectTo(world, pos, EnumFacing.WEST, this.blockMaterial) ? 0.0 : 0.375, 0.0, Utils.canFenceConnectTo(world, pos, EnumFacing.NORTH, this.blockMaterial) ? 0.0 : 0.375, Utils.canFenceConnectTo(world, pos, EnumFacing.EAST, this.blockMaterial) ? 1.0 : 0.625, 1.0, Utils.canFenceConnectTo(world, pos, EnumFacing.SOUTH, this.blockMaterial) ? 1.0 : 0.625);
        }
        return super.getBoundingBox(state, world, pos);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return ((BlockTypes_MetalDecoration1)((Object)world.getBlockState(pos).getValue((IProperty)this.property))).getMeta() % 4 != 0;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

