/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorProbe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRedstoneBreaker;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayHV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayLV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRelayMV;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTransformerHV;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockConnector
extends BlockIETileProvider<BlockTypes_Connector> {
    public BlockConnector() {
        super("connector", Material.IRON, PropertyEnum.create((String)"type", BlockTypes_Connector.class), ItemBlockIEBase.class, new Object[]{IEProperties.FACING_ALL, IEProperties.BOOLEANS[0], IEProperties.BOOLEANS[1], IEProperties.MULTIBLOCKSLAVE, IOBJModelCallback.PROPERTY});
        this.setHardness(3.0f);
        this.setResistance(15.0f);
        this.lightOpacity = 0;
        this.setMetaBlockLayer(BlockTypes_Connector.RELAY_HV.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
        this.setMetaBlockLayer(BlockTypes_Connector.CONNECTOR_PROBE.getMeta(), BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT, BlockRenderLayer.TRANSLUCENT);
        this.setAllNotNormalBlock();
        this.setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER.getMeta(), EnumPushReaction.BLOCK);
        this.setMetaMobilityFlag(BlockTypes_Connector.TRANSFORMER_HV.getMeta(), EnumPushReaction.BLOCK);
        this.setMetaMobilityFlag(BlockTypes_Connector.ENERGY_METER.getMeta(), EnumPushReaction.BLOCK);
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            return "transformer";
        }
        if (meta == BlockTypes_Connector.TRANSFORMER_HV.getMeta()) {
            return "transformer_hv";
        }
        if (meta == BlockTypes_Connector.BREAKERSWITCH.getMeta()) {
            return "breaker_switch";
        }
        if (meta == BlockTypes_Connector.REDSTONE_BREAKER.getMeta()) {
            return "redstone_breaker";
        }
        if (meta == BlockTypes_Connector.ENERGY_METER.getMeta()) {
            return "energy_meter";
        }
        return null;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        BlockStateContainer base = super.createBlockState();
        IUnlistedProperty[] unlisted = base instanceof ExtendedBlockState ? ((ExtendedBlockState)base).getUnlistedProperties().toArray(new IUnlistedProperty[0]) : new IUnlistedProperty[]{};
        unlisted = Arrays.copyOf(unlisted, unlisted.length + 1);
        unlisted[unlisted.length - 1] = IEProperties.CONNECTIONS;
        return new ExtendedBlockState((Block)this, base.getProperties().toArray(new IProperty[0]), unlisted);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.getTileEntity(pos);
            if (!(te instanceof TileEntityImmersiveConnectable)) {
                return state;
            }
            state = ext.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
        }
        return state;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState s = world.getBlockState(pos);
        return s.getValue((IProperty)this.property) == BlockTypes_Connector.ENERGY_METER;
    }

    @Override
    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        BlockPos pos2;
        if (stack.getItemDamage() == BlockTypes_Connector.TRANSFORMER.getMeta() || stack.getItemDamage() == BlockTypes_Connector.TRANSFORMER_HV.getMeta()) {
            for (int hh = 1; hh <= 2; ++hh) {
                BlockPos pos22 = pos.up(hh);
                if (!world.isOutsideBuildHeight(pos22) && world.getBlockState(pos22).getBlock().isReplaceable((IBlockAccess)world, pos22)) continue;
                return false;
            }
        } else if (stack.getItemDamage() == BlockTypes_Connector.ENERGY_METER.getMeta() && (world.isOutsideBuildHeight(pos2 = pos.up()) || !world.getBlockState(pos2).getBlock().isReplaceable((IBlockAccess)world, pos2))) {
            return false;
        }
        return true;
    }

    @Override
    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityImmersiveConnectable connector;
        super.neighborChanged(state, world, pos, blockIn, fromPos);
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityConnectorLV) {
            connector = (TileEntityConnectorLV)te;
            if (world.isAirBlock(pos.offset(((TileEntityConnectorLV)connector).facing))) {
                this.dropBlockAsItem(connector.getWorld(), pos, world.getBlockState(pos), 0);
                connector.getWorld().setBlockToAir(pos);
                return;
            }
        }
        if (te instanceof TileEntityConnectorRedstone) {
            connector = (TileEntityConnectorRedstone)te;
            if (world.isAirBlock(pos.offset(((TileEntityConnectorRedstone)connector).facing))) {
                this.dropBlockAsItem(connector.getWorld(), pos, world.getBlockState(pos), 0);
                connector.getWorld().setBlockToAir(pos);
                return;
            }
            if (((TileEntityConnectorRedstone)connector).isRSInput()) {
                ((TileEntityConnectorRedstone)connector).rsDirty = true;
            }
        }
    }

    @Override
    public TileEntity createBasicTE(World world, BlockTypes_Connector type) {
        switch (type) {
            case CONNECTOR_LV: {
                return new TileEntityConnectorLV();
            }
            case RELAY_LV: {
                return new TileEntityRelayLV();
            }
            case CONNECTOR_MV: {
                return new TileEntityConnectorMV();
            }
            case RELAY_MV: {
                return new TileEntityRelayMV();
            }
            case CONNECTOR_HV: {
                return new TileEntityConnectorHV();
            }
            case RELAY_HV: {
                return new TileEntityRelayHV();
            }
            case CONNECTOR_STRUCTURAL: {
                return new TileEntityConnectorStructural();
            }
            case TRANSFORMER: {
                return new TileEntityTransformer();
            }
            case TRANSFORMER_HV: {
                return new TileEntityTransformerHV();
            }
            case BREAKERSWITCH: {
                return new TileEntityBreakerSwitch();
            }
            case REDSTONE_BREAKER: {
                return new TileEntityRedstoneBreaker();
            }
            case ENERGY_METER: {
                return new TileEntityEnergyMeter();
            }
            case CONNECTOR_REDSTONE: {
                return new TileEntityConnectorRedstone();
            }
            case CONNECTOR_PROBE: {
                return new TileEntityConnectorProbe();
            }
        }
        return null;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState ret = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (meta == BlockTypes_Connector.TRANSFORMER.getMeta()) {
            TileEntity tile;
            BlockPos pos2 = pos.offset(facing, -1);
            IBlockState placedAgainst = world.getBlockState(pos2);
            Block block = placedAgainst.getBlock();
            if (block instanceof IPostBlock && ((IPostBlock)block).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.withProperty((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
            if ((tile = world.getTileEntity(pos2)) instanceof IPostBlock && ((IPostBlock)tile).canConnectTransformer((IBlockAccess)world, pos2)) {
                ret = ret.withProperty((IProperty)IEProperties.BOOLEANS[1], (Comparable)Boolean.valueOf(true));
            }
        }
        return ret;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

