/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileEntityStripCurtain
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IDualState,
IEBlockInterfaces.IColouredTile,
IEBlockInterfaces.ITileDrop {
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean ceilingAttached = false;
    public int colour = 0xFFFFFF;
    private int redstoneSignal = 0;
    private boolean strongSignal = false;
    AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 0.0625), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.1875, 1.0), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.8125, 0.46875, 1.0, 1.0, 0.53125), new AxisAlignedBB(0.46875, 0.8125, 0.0, 0.53125, 1.0, 1.0)};

    public void update() {
        if (!this.world.isRemote && this.world.getTotalWorldTime() % 4L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 3)) {
            List entities = null;
            AxisAlignedBB aabb = this.bounds[this.ceilingAttached ? (this.facing.getAxis() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
            aabb = new AxisAlignedBB(aabb.minX, aabb.minY - 0.8125, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ).offset(this.getPos());
            entities = this.world.getEntitiesWithinAABB(Entity.class, aabb);
            if (!this.ceilingAttached && !entities.isEmpty() && this.redstoneSignal == 0) {
                this.redstoneSignal = 15;
                this.markDirty();
                this.world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), false);
                this.world.notifyNeighborsOfStateChange(this.getPos().offset(this.facing), this.getBlockType(), false);
            }
            if (entities.isEmpty() && this.redstoneSignal != 0) {
                this.redstoneSignal = 0;
                this.world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), false);
                this.world.notifyNeighborsOfStateChange(this.getPos().offset(this.facing), this.getBlockType(), false);
            }
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (this.ceilingAttached && !entity.isDead && this.redstoneSignal == 0) {
            AxisAlignedBB aabb = this.bounds[this.ceilingAttached ? (this.facing.getAxis() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
            aabb = new AxisAlignedBB(aabb.minX, aabb.minY - 0.8125, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ).offset(this.getPos());
            if (entity.getEntityBoundingBox().intersects(aabb)) {
                this.redstoneSignal = 15;
                this.markDirty();
                world.notifyNeighborsOfStateChange(this.getPos(), this.getBlockType(), false);
                world.notifyNeighborsOfStateChange(this.getPos().offset(EnumFacing.UP), this.getBlockType(), false);
            }
        }
    }

    @Override
    public int getStrongRSOutput(IBlockState state, EnumFacing side) {
        if (!this.strongSignal) {
            return 0;
        }
        return this.getWeakRSOutput(state, this.facing);
    }

    @Override
    public int getWeakRSOutput(IBlockState state, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return 0;
        }
        return this.redstoneSignal;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, EnumFacing side) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
        this.ceilingAttached = nbt.getBoolean("ceilingAttached");
        this.colour = nbt.getInteger("colour");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (this.facing != null) {
            nbt.setInteger("facing", this.facing.ordinal());
        }
        nbt.setBoolean("ceilingAttached", this.ceilingAttached);
        nbt.setInteger("colour", this.colour);
    }

    @Override
    public float[] getBlockBounds() {
        AxisAlignedBB aabb = this.bounds[this.ceilingAttached ? (this.facing.getAxis() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
        return new float[]{(float)aabb.minX, (float)aabb.minY, (float)aabb.minZ, (float)aabb.maxX, (float)aabb.maxY, (float)aabb.maxZ};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        Object[] objectArray = new AxisAlignedBB[1];
        objectArray[0] = this.bounds[this.ceilingAttached ? (this.facing.getAxis() == EnumFacing.Axis.Z ? 4 : 5) : (this.facing.ordinal() - 2) % 4];
        return Lists.newArrayList((Object[])objectArray);
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        if (side == EnumFacing.DOWN) {
            this.ceilingAttached = true;
        }
    }

    @Override
    public boolean getIsSecondState() {
        return this.ceilingAttached;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public int getRenderColour(int tintIndex) {
        if (tintIndex == 1) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
        if (this.colour != 0xFFFFFF) {
            ItemNBTHelper.setInt(stack, "colour", this.colour);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            this.colour = ItemNBTHelper.getInt(stack, "colour");
        }
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.strongSignal = !this.strongSignal;
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl.strongSignal." + this.strongSignal, new Object[0])});
        return true;
    }
}

