/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockTypes_ClothDevice;
import blusunrize.immersiveengineering.common.blocks.cloth.ItemBlockClothDevice;
import blusunrize.immersiveengineering.common.blocks.cloth.TileEntityBalloon;
import blusunrize.immersiveengineering.common.blocks.cloth.TileEntityStripCurtain;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockClothDevice
extends BlockIETileProvider<BlockTypes_ClothDevice> {
    public BlockClothDevice() {
        super("cloth_device", Material.CLOTH, PropertyEnum.create((String)"type", BlockTypes_ClothDevice.class), ItemBlockClothDevice.class, new Object[]{IEProperties.FACING_ALL, IEProperties.BOOLEANS[0], IOBJModelCallback.PROPERTY, CapabilityShader.BLOCKSTATE_PROPERTY, IEProperties.CONNECTIONS});
        this.setHardness(0.8f);
        this.setHasColours();
        this.setMetaLightOpacity(1, 0);
        this.setMetaLightOpacity(2, 0);
        this.setMetaBlockLayer(1, BlockRenderLayer.SOLID, BlockRenderLayer.TRANSLUCENT);
        this.setNotNormalBlock(BlockTypes_ClothDevice.BALLOON.getMeta());
        this.setNotNormalBlock(BlockTypes_ClothDevice.STRIPCURTAIN.getMeta());
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        return 0xFFFFFF;
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            String hexCol = Integer.toHexString(ItemNBTHelper.getInt(stack, "colour"));
            tooltip.add(I18n.translateToLocalFormatted((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
        }
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        if (meta == 2) {
            return "stripcurtain";
        }
        return null;
    }

    public void onFallenUpon(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.fall(fallDistance, 0.0f);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.getTileEntity(pos);
            if (te instanceof TileEntityImmersiveConnectable) {
                ext = ext.withProperty((IUnlistedProperty)IEProperties.CONNECTIONS, ((TileEntityImmersiveConnectable)te).genConnBlockstate());
            }
            state = ext;
        }
        return state;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createBasicTE(World world, BlockTypes_ClothDevice type) {
        switch (type) {
            case CUSHION: {
                return null;
            }
            case BALLOON: {
                return new TileEntityBalloon();
            }
            case STRIPCURTAIN: {
                return new TileEntityStripCurtain();
            }
        }
        return null;
    }
}

