/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileEntityMultiblockPart<T extends TileEntityMultiblockPart<T>>
extends TileEntityIEBase
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IGeneralMultiblock {
    public boolean formed = false;
    public int pos = -1;
    public int[] offset = new int[]{0, 0, 0};
    public boolean mirrored = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public long onlyLocalDissassembly = -1L;
    protected final int[] structureDimensions;

    protected TileEntityMultiblockPart(int[] structureDimensions) {
        this.structureDimensions = structureDimensions;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.formed = nbt.getBoolean("formed");
        this.pos = nbt.getInteger("pos");
        this.offset = nbt.getIntArray("offset");
        this.mirrored = nbt.getBoolean("mirrored");
        this.facing = EnumFacing.getFront((int)nbt.getInteger("facing"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setBoolean("formed", this.formed);
        nbt.setInteger("pos", this.pos);
        nbt.setIntArray("offset", this.offset);
        nbt.setBoolean("mirrored", this.mirrored);
        nbt.setInteger("facing", this.facing.ordinal());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.getAccessibleFluidTanks(facing).length > 0) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.getAccessibleFluidTanks(facing).length > 0) {
            return (T)new MultiblockFluidWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    protected abstract IFluidTank[] getAccessibleFluidTanks(EnumFacing var1);

    protected abstract boolean canFillTankFrom(int var1, EnumFacing var2, FluidStack var3);

    protected abstract boolean canDrainTankFrom(int var1, EnumFacing var2);

    public void invalidate() {
        super.invalidate();
    }

    public static boolean _Immovable() {
        return true;
    }

    @Nullable
    public T master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return (T)this;
        }
        BlockPos masterPos = this.getPos().add(-this.offset[0], -this.offset[1], -this.offset[2]);
        TileEntity te = Utils.getExistingTileEntity(this.world, masterPos);
        return (T)(this.getClass().isInstance(te) ? (TileEntityMultiblockPart)te : null);
    }

    public void updateMasterBlock(IBlockState state, boolean blockUpdate) {
        T master = this.master();
        if (master != null) {
            master.markDirty();
            if (blockUpdate) {
                ((TileEntityIEBase)((Object)master)).markContainingBlockForUpdate(state);
            }
        }
    }

    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    @Override
    public boolean isLogicDummy() {
        return this.isDummy();
    }

    public abstract ItemStack getOriginalBlock();

    public void disassemble() {
        if (this.formed && !this.world.isRemote) {
            BlockPos startPos = this.getOrigin();
            BlockPos masterPos = this.getPos().add(-this.offset[0], -this.offset[1], -this.offset[2]);
            long time = this.world.getTotalWorldTime();
            for (int yy = 0; yy < this.structureDimensions[0]; ++yy) {
                for (int ll = 0; ll < this.structureDimensions[1]; ++ll) {
                    for (int ww = 0; ww < this.structureDimensions[2]; ++ww) {
                        IBlockState state;
                        int w = this.mirrored ? -ww : ww;
                        BlockPos pos = startPos.offset(this.facing, ll).offset(this.facing.rotateY(), w).add(0, yy, 0);
                        ItemStack s = ItemStack.EMPTY;
                        TileEntity te = this.world.getTileEntity(pos);
                        if (te instanceof TileEntityMultiblockPart) {
                            TileEntityMultiblockPart part = (TileEntityMultiblockPart)te;
                            BlockPos diff = pos.subtract((Vec3i)masterPos);
                            if (part.offset[0] != diff.getX() || part.offset[1] != diff.getY() || part.offset[2] != diff.getZ()) continue;
                            if (time != part.onlyLocalDissassembly) {
                                s = part.getOriginalBlock();
                                part.formed = false;
                            }
                        }
                        if (pos.equals((Object)this.getPos())) {
                            s = this.getOriginalBlock();
                        }
                        if ((state = Utils.getStateFromItemStack(s)) == null) continue;
                        if (pos.equals((Object)this.getPos())) {
                            this.world.spawnEntity((Entity)new EntityItem(this.world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, s));
                            continue;
                        }
                        this.replaceStructureBlock(pos, state, s, yy, ll, ww);
                    }
                }
            }
        }
    }

    public BlockPos getOrigin() {
        return this.getBlockPosForPos(0);
    }

    public BlockPos getBlockPosForPos(int targetPos) {
        int blocksPerLevel = this.structureDimensions[1] * this.structureDimensions[2];
        int distH = targetPos / blocksPerLevel - this.pos / blocksPerLevel;
        int distL = targetPos % blocksPerLevel / this.structureDimensions[2] - this.pos % blocksPerLevel / this.structureDimensions[2];
        int distW = targetPos % this.structureDimensions[2] - this.pos % this.structureDimensions[2];
        int w = this.mirrored ? -distW : distW;
        return this.getPos().offset(this.facing, distL).offset(this.facing.rotateY(), w).add(0, distH, 0);
    }

    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        if (state.getBlock() == this.getBlockType()) {
            this.world.setBlockToAir(pos);
        }
        this.world.setBlockState(pos, state);
        TileEntity tile = this.world.getTileEntity(pos);
        if (tile instanceof IEBlockInterfaces.ITileDrop) {
            ((IEBlockInterfaces.ITileDrop)tile).readOnPlacement(null, stack);
        }
    }

    public static class MultiblockFluidWrapper
    implements IFluidHandler {
        final TileEntityMultiblockPart multiblock;
        final EnumFacing side;

        public MultiblockFluidWrapper(TileEntityMultiblockPart multiblock, EnumFacing side) {
            this.multiblock = multiblock;
            this.side = side;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!this.multiblock.formed) {
                return new IFluidTankProperties[0];
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            IFluidTankProperties[] array = new IFluidTankProperties[tanks.length];
            for (int i = 0; i < tanks.length; ++i) {
                array[i] = new FluidTankProperties(tanks[i].getFluid(), tanks[i].getCapacity());
            }
            return array;
        }

        public int fill(FluidStack resource, boolean doFill) {
            IFluidTank tank;
            int i;
            if (!this.multiblock.formed || resource == null) {
                return 0;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            int fill = -1;
            for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && tank.getFluid() != null && tank.getFluid().isFluidEqual(resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
            }
            if (fill == -1) {
                for (i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canFillTankFrom(i, this.side, resource) && (fill = tank.fill(resource, doFill)) > 0); ++i) {
                }
            }
            if (fill > 0) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return fill < 0 ? 0 : fill;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || resource == null) {
                return null;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = null;
            for (int i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canDrainTankFrom(i, this.side) && (drain = tank instanceof IFluidHandler ? ((IFluidHandler)tank).drain(resource, doDrain) : tank.drain(resource.amount, doDrain)) != null); ++i) {
            }
            if (drain != null) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            IFluidTank tank;
            if (!this.multiblock.formed || maxDrain == 0) {
                return null;
            }
            IFluidTank[] tanks = this.multiblock.getAccessibleFluidTanks(this.side);
            FluidStack drain = null;
            for (int i = 0; !(i >= tanks.length || (tank = tanks[i]) != null && this.multiblock.canDrainTankFrom(i, this.side) && (drain = tank.drain(maxDrain, doDrain)) != null); ++i) {
            }
            if (drain != null) {
                this.multiblock.updateMasterBlock(null, true);
            }
            return drain;
        }
    }
}

