/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class TileEntityIEBase
extends TileEntity {
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.readCustomNBT(nbt, false);
    }

    public abstract void readCustomNBT(NBTTagCompound var1, boolean var2);

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.writeCustomNBT(nbt, false);
        return nbt;
    }

    public abstract void writeCustomNBT(NBTTagCompound var1, boolean var2);

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound, true);
        return new SPacketUpdateTileEntity(this.pos, 3, nbttagcompound);
    }

    public NBTTagCompound getUpdateTag() {
        NBTTagCompound nbt = super.writeToNBT(new NBTTagCompound());
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.getNbtCompound(), true);
    }

    public void rotate(Rotation rot) {
        if (rot != Rotation.NONE && this instanceof IEBlockInterfaces.IDirectionalTile && ((IEBlockInterfaces.IDirectionalTile)((Object)this)).canRotate(EnumFacing.UP)) {
            EnumFacing f = ((IEBlockInterfaces.IDirectionalTile)((Object)this)).getFacing();
            switch (rot) {
                case CLOCKWISE_90: {
                    f = f.rotateY();
                    break;
                }
                case CLOCKWISE_180: {
                    f = f.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    f = f.rotateYCCW();
                }
            }
            ((IEBlockInterfaces.IDirectionalTile)((Object)this)).setFacing(f);
            this.markDirty();
            if (this.pos != null) {
                this.markBlockForUpdate(this.pos, null);
            }
        }
    }

    public void mirror(Mirror mirrorIn) {
        if (mirrorIn == Mirror.FRONT_BACK && this instanceof IEBlockInterfaces.IDirectionalTile) {
            ((IEBlockInterfaces.IDirectionalTile)((Object)this)).setFacing(((IEBlockInterfaces.IDirectionalTile)((Object)this)).getFacing());
            this.markDirty();
            if (this.pos != null) {
                this.markBlockForUpdate(this.pos, null);
            }
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
    }

    public void onEntityCollision(World world, Entity entity) {
    }

    public boolean receiveClientEvent(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            IBlockState state = this.world.getBlockState(this.pos);
            if (state instanceof IExtendedBlockState) {
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
            }
            this.world.notifyBlockUpdate(this.pos, state, state, 3);
            return true;
        }
        return super.receiveClientEvent(id, type);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (world.isBlockLoaded(pos)) {
            newState = world.getBlockState(pos);
        }
        if (oldState.getBlock() != newState.getBlock() || !(oldState.getBlock() instanceof BlockIEBase) || !(newState.getBlock() instanceof BlockIEBase)) {
            return true;
        }
        PropertyEnum type = ((BlockIEBase)oldState.getBlock()).getMetaProperty();
        return oldState.getValue(type) != newState.getValue(type);
    }

    public void markContainingBlockForUpdate(@Nullable IBlockState newState) {
        this.markBlockForUpdate(this.getPos(), newState);
    }

    public void markBlockForUpdate(BlockPos pos, @Nullable IBlockState newState) {
        IBlockState state = this.world.getBlockState(this.getPos());
        if (newState == null) {
            newState = state;
        }
        this.world.notifyBlockUpdate(pos, state, newState, 3);
        this.world.notifyNeighborsOfStateChange(pos, newState.getBlock(), true);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector) {
            return ((EnergyHelper.IIEInternalFluxConnector)((Object)this)).getCapabilityWrapper(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector) {
            return (T)((EnergyHelper.IIEInternalFluxConnector)((Object)this)).getCapabilityWrapper(facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

