/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockIESlabs
extends ItemBlockIEBase {
    public ItemBlockIESlabs(Block b) {
        super(b);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.addInformation(stack, world, tooltip, tooltipFlag);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        IBlockState iblockstate = world.getBlockState(pos);
        Block localBlock = iblockstate.getBlock();
        BlockPos posThere = pos;
        BlockPos posOffset = pos.offset(side);
        if (localBlock == Blocks.SNOW_LAYER && localBlock.isReplaceable((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
        } else if (!localBlock.isReplaceable((IBlockAccess)world, pos)) {
            pos = pos.offset(side);
        }
        TileEntityIEBase stackSlab = null;
        if (side.getAxis().isVertical() && this.block.equals(world.getBlockState(posThere).getBlock()) && world.getBlockState(posThere).getBlock().getMetaFromState(world.getBlockState(posThere)) == stack.getItemDamage()) {
            TileEntity te = world.getTileEntity(posThere);
            if (te instanceof TileEntityIESlab && ((TileEntityIESlab)te).slabType + side.ordinal() == 1) {
                stackSlab = (TileEntityIESlab)te;
            }
        } else if (this.block.equals(world.getBlockState(posOffset).getBlock()) && world.getBlockState(posOffset).getBlock().getMetaFromState(world.getBlockState(posOffset)) == stack.getItemDamage()) {
            int type;
            TileEntity te = world.getTileEntity(posOffset);
            if (te instanceof TileEntityIESlab && ((type = ((TileEntityIESlab)te).slabType) == 0 && (side == EnumFacing.DOWN || (double)hitY >= 0.5) || type == 1 && (side == EnumFacing.UP || (double)hitY <= 0.5))) {
                stackSlab = (TileEntityIESlab)te;
            }
        } else {
            return super.onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        if (stackSlab != null) {
            ((TileEntityIESlab)stackSlab).slabType = 2;
            stackSlab.markContainingBlockForUpdate(null);
            world.playSound((double)stackSlab.getPos().getX() + 0.5, (double)stackSlab.getPos().getY() + 0.5, (double)stackSlab.getPos().getZ() + 0.5, this.block.getSoundType().getPlaceSound(), SoundCategory.BLOCKS, (this.block.getSoundType().getVolume() + 1.0f) / 2.0f, this.block.getSoundType().getPitch() * 0.8f, false);
            stack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUse(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity tileEntity;
        boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (ret && (tileEntity = world.getTileEntity(pos)) instanceof TileEntityIESlab) {
            ((TileEntityIESlab)tileEntity).slabType = side == EnumFacing.DOWN || side != EnumFacing.UP && (double)hitY >= 0.5 ? 1 : 0;
        }
        return ret;
    }
}

