/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockIEBase
extends ItemBlock {
    private int[] burnTime;

    public ItemBlockIEBase(Block b) {
        super(b);
        if (((BlockIEBase)b).enumValues.length > 1) {
            this.setHasSubtypes(true);
        }
        this.burnTime = new int[((BlockIEBase)b).enumValues != null ? ((BlockIEBase)b).enumValues.length : 1];
    }

    public int getMetadata(int damageValue) {
        return damageValue;
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        if (this.isInCreativeTab(tab)) {
            this.block.getSubBlocks(tab, itemList);
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return ((BlockIEBase)this.block).getUnlocalizedName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        FluidStack fs;
        if (((BlockIEBase)this.block).hasFlavour(stack)) {
            String subName = ((BlockIEBase)this.block).getStateFromMeta(stack.getItemDamage()).getValue(((BlockIEBase)this.block).property).toString().toLowerCase(Locale.US);
            String flavourKey = "desc.immersiveengineering.flavour." + ((BlockIEBase)this.block).name + "." + subName;
            tooltip.add(TextFormatting.GRAY.toString() + I18n.format((String)flavourKey, (Object[])new Object[0]));
        }
        super.addInformation(stack, world, tooltip, tooltipFlag);
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            tooltip.add(I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{ItemNBTHelper.getInt(stack, "energyStorage")}));
        }
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            tooltip.add(fs.getLocalizedName() + ": " + fs.amount + "mB");
        }
    }

    public ItemBlockIEBase setBurnTime(int meta, int burnTime) {
        if (meta >= 0 && meta < this.burnTime.length) {
            this.burnTime[meta] = burnTime;
        }
        return this;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.burnTime[Math.max(0, Math.min(itemStack.getMetadata(), this.burnTime.length - 1))];
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!((BlockIEBase)this.block).canIEBlockBePlaced(world, pos, newState, side, hitX, hitY, hitZ, player, stack)) {
            return false;
        }
        boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (ret) {
            ((BlockIEBase)this.block).onIEBlockPlacedBy(world, pos, newState, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
        }
        return ret;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        IBlockState iblockstate = world.getBlockState(pos);
        Block block = iblockstate.getBlock();
        if (!block.isReplaceable((IBlockAccess)world, pos)) {
            pos = pos.offset(side);
        }
        if (stack.getCount() > 0 && player.canPlayerEdit(pos, side, stack) && this.canBlockBePlaced(world, pos, side, stack)) {
            int i = this.getMetadata(stack.getMetadata());
            IBlockState iblockstate1 = this.block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, i, (EntityLivingBase)player);
            if (this.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), world, pos, (Entity)player);
                world.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (!player.capabilities.isCreativeMode) {
                    stack.shrink(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = worldIn.getBlockState(pos).getBlock();
        if (block == Blocks.SNOW_LAYER && block.isReplaceable((IBlockAccess)worldIn, pos)) {
            side = EnumFacing.UP;
        } else if (!block.isReplaceable((IBlockAccess)worldIn, pos)) {
            pos = pos.offset(side);
        }
        return this.canBlockBePlaced(worldIn, pos, side, stack);
    }

    private boolean canBlockBePlaced(World w, BlockPos pos, EnumFacing side, ItemStack stack) {
        BlockIEBase blockIn = (BlockIEBase)this.block;
        Block block = w.getBlockState(pos).getBlock();
        AxisAlignedBB axisalignedbb = blockIn.getCollisionBoundingBox(blockIn.getStateFromMeta(stack.getItemDamage()), (IBlockAccess)w, pos);
        if (axisalignedbb != null && !w.checkNoEntityCollision(axisalignedbb.offset(pos), null)) {
            return false;
        }
        return block.isReplaceable((IBlockAccess)w, pos) && blockIn.canPlaceBlockOnSide(w, pos, side);
    }

    public static class ItemBlockIENoInventory
    extends ItemBlockIEBase {
        public ItemBlockIENoInventory(Block b) {
            super(b);
        }

        @Nullable
        public NBTTagCompound getNBTShareTag(ItemStack stack) {
            NBTTagCompound ret = super.getNBTShareTag(stack);
            if (ret != null) {
                ret = ret.copy();
                ret.removeTag("inventory");
            }
            return ret;
        }

        public boolean getShareTag() {
            return super.getShareTag();
        }
    }
}

