/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IEBlockInterfaces {

    public static interface IPropertyPassthrough {
    }

    public static interface INeighbourChangeTile {
        public void onNeighborBlockChange(BlockPos var1);
    }

    public static interface IProcessTile {
        public int[] getCurrentProcessesStep();

        public int[] getCurrentProcessesMax();
    }

    public static interface IGuiTile {
        default public boolean canOpenGui(EntityPlayer player) {
            return this.canOpenGui();
        }

        public boolean canOpenGui();

        public int getGuiID();

        @Nullable
        public TileEntity getGuiMaster();

        default public void onGuiOpened(EntityPlayer player, boolean clientside) {
        }
    }

    public static interface IDynamicTexture {
        @SideOnly(value=Side.CLIENT)
        public HashMap<String, String> getTextureReplacements();
    }

    public static interface IAdvancedHasObjProperty {
        public OBJModel.OBJState getOBJState();
    }

    public static interface IHasObjProperty {
        public ArrayList<String> compileDisplayList();
    }

    public static interface IGeneralMultiblock {
        public boolean isLogicDummy();
    }

    public static interface IHasDummyBlocks
    extends IGeneralMultiblock {
        public void placeDummies(BlockPos var1, IBlockState var2, EnumFacing var3, float var4, float var5, float var6);

        public void breakDummies(BlockPos var1, IBlockState var2);

        public boolean isDummy();

        @Override
        default public boolean isLogicDummy() {
            return this.isDummy();
        }
    }

    public static interface IAdvancedCollisionBounds
    extends IBlockBounds {
        public List<AxisAlignedBB> getAdvancedColisionBounds();
    }

    public static interface IAdvancedSelectionBounds
    extends IBlockBounds {
        public List<AxisAlignedBB> getAdvancedSelectionBounds();

        public boolean isOverrideBox(AxisAlignedBB var1, EntityPlayer var2, RayTraceResult var3, ArrayList<AxisAlignedBB> var4);
    }

    public static interface IFaceShape {
        public BlockFaceShape getFaceShape(EnumFacing var1);
    }

    public static interface IBlockBounds {
        public float[] getBlockBounds();
    }

    public static interface IMirrorAble
    extends IUsesBooleanProperty {
        public boolean getIsMirrored();
    }

    public static interface IDualState
    extends IUsesBooleanProperty {
        public boolean getIsSecondState();
    }

    public static interface IActiveState
    extends IUsesBooleanProperty {
        public boolean getIsActive();
    }

    public static interface IHammerInteraction {
        public boolean hammerUseSide(EnumFacing var1, EntityPlayer var2, float var3, float var4, float var5);
    }

    public static interface IPlayerInteraction {
        public boolean interact(EnumFacing var1, EntityPlayer var2, EnumHand var3, ItemStack var4, float var5, float var6, float var7);
    }

    public static interface IEntityProof {
        public boolean canEntityDestroy(Entity var1);
    }

    public static interface IAdditionalDrops {
        public Collection<ItemStack> getExtraDrops(EntityPlayer var1, IBlockState var2);
    }

    public static interface ITileDrop {
        public ItemStack getTileDrop(@Nullable EntityPlayer var1, IBlockState var2);

        public void readOnPlacement(@Nullable EntityLivingBase var1, ItemStack var2);

        default public boolean preventInventoryDrop() {
            return false;
        }
    }

    public static interface IConfigurableSides {
        public IEEnums.SideConfig getSideConfig(int var1);

        public boolean toggleSide(int var1, EntityPlayer var2);
    }

    public static interface IAdvancedDirectionalTile
    extends IDirectionalTile {
        public void onDirectionalPlacement(EnumFacing var1, float var2, float var3, float var4, EntityLivingBase var5);
    }

    public static interface IDirectionalTile {
        public EnumFacing getFacing();

        public void setFacing(EnumFacing var1);

        public int getFacingLimitation();

        default public EnumFacing getFacingForPlacement(EntityLivingBase placer, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
            EnumFacing f = EnumFacing.DOWN;
            int limit = this.getFacingLimitation();
            if (limit == 0) {
                f = side;
            } else if (limit == 1) {
                f = EnumFacing.getDirectionFromEntityLiving((BlockPos)pos, (EntityLivingBase)placer);
            } else if (limit == 2) {
                f = EnumFacing.fromAngle((double)placer.rotationYaw);
            } else if (limit == 3) {
                f = side != EnumFacing.DOWN && (side == EnumFacing.UP || (double)hitY <= 0.5) ? EnumFacing.UP : EnumFacing.DOWN;
            } else if (limit == 4) {
                f = EnumFacing.fromAngle((double)placer.rotationYaw);
                if (f == EnumFacing.SOUTH || f == EnumFacing.WEST) {
                    f = f.getOpposite();
                }
            } else if (limit == 5) {
                if (side.getAxis() != EnumFacing.Axis.Y) {
                    f = side.getOpposite();
                } else {
                    float xFromMid = hitX - 0.5f;
                    float zFromMid = hitZ - 0.5f;
                    float max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
                    f = max == Math.abs(xFromMid) ? (xFromMid < 0.0f ? EnumFacing.WEST : EnumFacing.EAST) : (zFromMid < 0.0f ? EnumFacing.NORTH : EnumFacing.SOUTH);
                }
            } else if (limit == 6) {
                f = side.getAxis() != EnumFacing.Axis.Y ? side.getOpposite() : EnumFacing.getDirectionFromEntityLiving((BlockPos)pos, (EntityLivingBase)placer);
            }
            return this.mirrorFacingOnPlacement(placer) ? f.getOpposite() : f;
        }

        public boolean mirrorFacingOnPlacement(EntityLivingBase var1);

        public boolean canHammerRotate(EnumFacing var1, float var2, float var3, float var4, EntityLivingBase var5);

        public boolean canRotate(EnumFacing var1);

        default public void afterRotation(EnumFacing oldDir, EnumFacing newDir) {
        }
    }

    public static interface IColouredTile {
        public int getRenderColour(int var1);
    }

    public static interface IColouredBlock {
        public boolean hasCustomBlockColours();

        public int getRenderColour(IBlockState var1, @Nullable IBlockAccess var2, @Nullable BlockPos var3, int var4);
    }

    public static interface ILightValue {
        public int getLightValue();
    }

    public static interface IRedstoneOutput {
        default public int getWeakRSOutput(IBlockState state, EnumFacing side) {
            return this.getStrongRSOutput(state, side);
        }

        public int getStrongRSOutput(IBlockState var1, EnumFacing var2);

        public boolean canConnectRedstone(IBlockState var1, EnumFacing var2);
    }

    public static interface IComparatorOverride {
        public int getComparatorInputOverride();
    }

    public static interface ISpawnInterdiction {
        public double getInterdictionRangeSquared();
    }

    public static interface ISoundTile {
        public boolean shoudlPlaySound(String var1);
    }

    public static interface IBlockOverlayText {
        public String[] getOverlayText(EntityPlayer var1, RayTraceResult var2, boolean var3);

        public boolean useNixieFont(EntityPlayer var1, RayTraceResult var2);
    }

    public static interface IUsesBooleanProperty {
        public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IUsesBooleanProperty> var1);
    }

    public static interface IAttachedIntegerProperies {
        public String[] getIntPropertyNames();

        public PropertyInteger getIntProperty(String var1);

        public int getIntPropertyValue(String var1);

        default public void setValue(String name, int value) {
        }
    }

    public static interface IIEMetaBlock {
        public String getIEBlockName();

        public IProperty getMetaProperty();

        public Enum[] getMetaEnums();

        public IBlockState getInventoryState(int var1);

        public boolean useCustomStateMapper();

        public String getCustomStateMapping(int var1, boolean var2);

        @SideOnly(value=Side.CLIENT)
        public StateMapperBase getCustomMapper();

        public boolean appendPropertiesToState();
    }
}

