/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIESlabs;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockIESlab<E extends Enum<E>>
extends BlockIETileProvider<E> {
    public static final PropertyInteger prop_SlabType = PropertyInteger.create((String)"slabtype", (int)0, (int)2);

    public BlockIESlab(String name, Material material, PropertyEnum<E> property) {
        super(name, material, property, ItemBlockIESlabs.class, prop_SlabType);
        this.setAllNotNormalBlock();
        this.useNeighborBrightness = true;
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.getActualState(state, world, pos);
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileEntityIESlab) {
            return state.withProperty((IProperty)prop_SlabType, (Comparable)Integer.valueOf(((TileEntityIESlab)tile).slabType));
        }
        return state;
    }

    @Override
    public TileEntity createBasicTE(World worldIn, E meta) {
        return new TileEntityIESlab();
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Override
    public void harvestBlock(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        if (tile instanceof TileEntityIESlab && !player.capabilities.isCreativeMode) {
            BlockIESlab.spawnAsEntity((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, ((TileEntityIESlab)tile).slabType == 2 ? 2 : 1, this.getMetaFromState(state)));
            return;
        }
        super.harvestBlock(world, player, pos, state, tile, stack);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                return side == EnumFacing.DOWN;
            }
            if (type == 1) {
                return side == EnumFacing.UP;
            }
        }
        return true;
    }

    @Override
    public BlockFaceShape getBlockFaceShape(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 2) {
                return BlockFaceShape.SOLID;
            }
            if (type == 0 && side == EnumFacing.DOWN || type == 1 && side == EnumFacing.UP) {
                return BlockFaceShape.SOLID;
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.SOLID;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            }
            if (type == 1) {
                return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
            }
            return FULL_BLOCK_AABB;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }
}

