/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.BlockIESlab;
import blusunrize.immersiveengineering.common.blocks.TileEntityIESlab;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockIEScaffoldSlab<E extends Enum<E>>
extends BlockIESlab<E> {
    public BlockIEScaffoldSlab(String name, Material material, PropertyEnum property) {
        super(name, material, property);
        this.setBlockLayer(BlockRenderLayer.CUTOUT_MIPPED);
    }

    @Override
    public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                BlockIEScaffoldSlab.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375));
            } else if (type == 1) {
                BlockIEScaffoldSlab.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.5, 0.0625, 0.9375, 1.0, 0.9375));
            } else {
                BlockIEScaffoldSlab.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
            }
        } else {
            BlockIEScaffoldSlab.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375));
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab) {
            int type = ((TileEntityIESlab)te).slabType;
            if (type == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            }
            if (type == 1) {
                return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
            }
            return FULL_BLOCK_AABB;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    @Override
    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).isOnLadder() && this.isLadder(state, (IBlockAccess)worldIn, pos, (EntityLivingBase)entityIn)) {
            float f5 = 0.15f;
            if (entityIn.motionX < (double)(-f5)) {
                entityIn.motionX = -f5;
            }
            if (entityIn.motionX > (double)f5) {
                entityIn.motionX = f5;
            }
            if (entityIn.motionZ < (double)(-f5)) {
                entityIn.motionZ = -f5;
            }
            if (entityIn.motionZ > (double)f5) {
                entityIn.motionZ = f5;
            }
            entityIn.fallDistance = 0.0f;
            if (entityIn.motionY < -0.15) {
                entityIn.motionY = -0.15;
            }
            if (entityIn.motionY < 0.0 && entityIn instanceof EntityPlayer && entityIn.isSneaking()) {
                entityIn.motionY = 0.0;
                return;
            }
            if (entityIn.isCollidedHorizontally) {
                entityIn.motionY = 0.2;
            }
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityIESlab && ((TileEntityIESlab)te).slabType == 0) {
            return entity.posY - (double)pos.getY() < 0.5;
        }
        return true;
    }

    @Override
    public boolean allowHammerHarvest(IBlockState state) {
        return true;
    }
}

