/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockIEMultiblock<E extends Enum<E>>
extends BlockIETileProvider<E> {
    public BlockIEMultiblock(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
        super(name, material, mainProperty, itemBlock, BlockIEMultiblock.combineProperties(additionalProperties, new Object[]{IEProperties.FACING_HORIZONTAL, IEProperties.MULTIBLOCKSLAVE}));
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.getActualState(state, world, pos);
        return state;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityMultiblockPart && world.getGameRules().getBoolean("doTileDrops")) {
            IIEInventory master;
            TileEntityMultiblockPart tile = (TileEntityMultiblockPart)tileEntity;
            if (!tile.formed && tile.pos == -1 && !tile.getOriginalBlock().isEmpty()) {
                world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, tile.getOriginalBlock().copy()));
            }
            if (tile.formed && tile instanceof IIEInventory && (master = (IIEInventory)tile.master()) != null && (!(master instanceof IEBlockInterfaces.ITileDrop) || !((IEBlockInterfaces.ITileDrop)((Object)master)).preventInventoryDrop()) && master.getDroppedItems() != null) {
                for (ItemStack s : master.getDroppedItems()) {
                    if (s.isEmpty()) continue;
                    world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, s.copy()));
                }
            }
        }
        if (tileEntity instanceof TileEntityMultiblockPart) {
            ((TileEntityMultiblockPart)tileEntity).disassemble();
        }
        super.breakBlock(world, pos, state);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = this.getOriginalBlock(world, pos);
        if (!stack.isEmpty()) {
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public ItemStack getOriginalBlock(World world, BlockPos pos) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityMultiblockPart) {
            return ((TileEntityMultiblockPart)te).getOriginalBlock();
        }
        return ItemStack.EMPTY;
    }
}

