/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEFluid;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDevices;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;

public class BlockIEFluidConcrete
extends BlockIEFluid {
    public BlockIEFluidConcrete(String name, Fluid fluid, Material material) {
        super(name, fluid, material);
        this.setQuantaPerBlock(16);
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LEVEL, IEProperties.INT_16}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        int adjacentSourceBlocks;
        if (!this.isSourceBlock((IBlockAccess)world, pos) && ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false) && (adjacentSourceBlocks = (this.isSourceBlock((IBlockAccess)world, pos.north()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.south()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.east()) ? 1 : 0) + (this.isSourceBlock((IBlockAccess)world, pos.west()) ? 1 : 0)) >= 2 && (world.getBlockState(pos.up(this.densityDir)).getMaterial().isSolid() || this.isSourceBlock((IBlockAccess)world, pos.up(this.densityDir)))) {
            world.setBlockState(pos, state.withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        }
        int level = (Integer)state.getValue((IProperty)LEVEL);
        int timer = (Integer)state.getValue((IProperty)IEProperties.INT_16);
        int quantaRemaining = this.quantaPerBlock - level;
        int expQuanta = -101;
        if (timer >= Math.min(14, quantaRemaining)) {
            IBlockState solidState = level >= 14 ? IEContent.blockStoneDevice.getStateFromMeta(BlockTypes_StoneDevices.CONCRETE_SHEET.getMeta()) : (level >= 10 ? IEContent.blockStoneDevice.getStateFromMeta(BlockTypes_StoneDevices.CONCRETE_QUARTER.getMeta()) : (level >= 6 ? IEContent.blockStoneDecorationSlabs.getStateFromMeta(BlockTypes_StoneDecoration.CONCRETE.getMeta()) : (level >= 2 ? IEContent.blockStoneDevice.getStateFromMeta(BlockTypes_StoneDevices.CONCRETE_THREEQUARTER.getMeta()) : IEContent.blockStoneDecoration.getStateFromMeta(BlockTypes_StoneDecoration.CONCRETE.getMeta()))));
            world.setBlockState(pos, solidState);
            for (EntityLivingBase living : world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(pos, pos.add(1, 1, 1)))) {
                living.addPotionEffect(new PotionEffect(IEPotions.concreteFeet, Integer.MAX_VALUE));
            }
            return;
        }
        state = state.withProperty((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1)));
        world.setBlockState(pos, state);
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.getBlockState(pos.add(0, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(-1, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(1, -this.densityDir, 0)).getBlock() == this || world.getBlockState(pos.add(0, -this.densityDir, -1)).getBlock() == this || world.getBlockState(pos.add(0, -this.densityDir, 1)).getBlock() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.add(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.add(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.add(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.add(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            int total = level;
            int blocks = 1;
            for (EnumFacing f : EnumFacing.HORIZONTALS) {
                IBlockState otherState = world.getBlockState(pos.offset(f));
                if (otherState.getBlock() != this) continue;
                ++blocks;
                total += ((Integer)otherState.getValue((IProperty)LEVEL)).intValue();
            }
            int newEvenQuanta = (int)Math.ceil((float)total / (float)blocks);
            for (EnumFacing f : EnumFacing.HORIZONTALS) {
                IBlockState otherState = world.getBlockState(pos.offset(f));
                if (otherState.getBlock() != this) continue;
                world.setBlockState(pos.offset(f), otherState.withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(newEvenQuanta)));
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.setBlockToAir(pos);
                } else {
                    world.setBlockState(pos, state.withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.scheduleUpdate(pos, (Block)this, this.tickRate);
                    world.notifyNeighborsOfStateChange(pos, (Block)this, true);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.setBlockState(pos, this.getDefaultState(), 2);
        }
        if (this.canDisplace((IBlockAccess)world, pos.up(this.densityDir))) {
            this.flowIntoBlockRet(world, pos.up(this.densityDir), 1, timer);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            world.setBlockState(pos, state.withProperty((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1))));
            world.scheduleUpdate(pos, (Block)this, this.tickRate);
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
            if (world.getBlockState(pos.down(this.densityDir)).getBlock() == this) {
                flowMeta = 1;
            }
            boolean[] flowTo = this.getOptimalFlowDirections(world, pos);
            boolean hasFlown = false;
            if (flowTo[0]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.add(-1, 0, 0), flowMeta, timer);
            }
            if (flowTo[1]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.add(1, 0, 0), flowMeta, timer);
            }
            if (flowTo[2]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.add(0, 0, -1), flowMeta, timer);
            }
            if (flowTo[3]) {
                hasFlown |= this.flowIntoBlockRet(world, pos.add(0, 0, 1), flowMeta, timer);
            }
            if (!hasFlown) {
                world.setBlockState(pos, state.withProperty((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(Math.min(15, timer + 1))));
                world.scheduleUpdate(pos, (Block)this, this.tickRate);
            }
        }
    }

    protected boolean flowIntoBlockRet(World world, BlockPos pos, int meta, int harden) {
        if (meta < 0) {
            return false;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.setBlockState(pos, this.getBlockState().getBaseState().withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(meta)).withProperty((IProperty)IEProperties.INT_16, (Comparable)Integer.valueOf(harden)), 3);
            return true;
        }
        return false;
    }
}

