/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIEBase<E extends Enum<E>>
extends Block
implements IEBlockInterfaces.IIEMetaBlock {
    protected static IProperty[] tempProperties;
    protected static IUnlistedProperty[] tempUnlistedProperties;
    public final String name;
    public final PropertyEnum<E> property;
    public final IProperty[] additionalProperties;
    public final IUnlistedProperty[] additionalUnlistedProperties;
    public final E[] enumValues;
    boolean[] isMetaHidden;
    boolean[] hasFlavour;
    protected Set<BlockRenderLayer> renderLayers = Sets.newHashSet((Object[])new BlockRenderLayer[]{BlockRenderLayer.SOLID});
    protected Set<BlockRenderLayer>[] metaRenderLayers;
    protected Map<Integer, Integer> metaLightOpacities = new HashMap<Integer, Integer>();
    protected Map<Integer, Float> metaHardness = new HashMap<Integer, Float>();
    protected Map<Integer, Integer> metaResistances = new HashMap<Integer, Integer>();
    protected EnumPushReaction[] metaMobilityFlags;
    protected boolean[] canHammerHarvest;
    protected boolean[] metaNotNormalBlock;
    private boolean opaqueCube = false;
    protected static IBlockState cachedTileRequestState;

    public BlockIEBase(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
        super(BlockIEBase.setTempProperties(material, mainProperty, additionalProperties));
        this.name = name;
        this.property = mainProperty;
        this.enumValues = (Enum[])mainProperty.getValueClass().getEnumConstants();
        this.isMetaHidden = new boolean[this.enumValues.length];
        this.hasFlavour = new boolean[this.enumValues.length];
        this.metaRenderLayers = new Set[this.enumValues.length];
        this.canHammerHarvest = new boolean[this.enumValues.length];
        this.metaMobilityFlags = new EnumPushReaction[this.enumValues.length];
        ArrayList<IProperty> propList = new ArrayList<IProperty>();
        ArrayList<Object> unlistedPropList = new ArrayList<Object>();
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                for (IProperty iProperty : (IProperty[])o) {
                    propList.add(iProperty);
                }
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            for (IProperty iProperty : (IUnlistedProperty[])o) {
                unlistedPropList.add(iProperty);
            }
        }
        this.additionalProperties = propList.toArray(new IProperty[propList.size()]);
        this.additionalUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
        this.setDefaultState(this.getInitDefaultState());
        String registryName = this.createRegistryName();
        this.setUnlocalizedName(registryName.replace(':', '.'));
        this.setCreativeTab(ImmersiveEngineering.creativeTab);
        this.adjustSound();
        IEContent.registeredIEBlocks.add(this);
        try {
            IEContent.registeredIEItems.add((Item)itemBlock.getConstructor(Block.class).newInstance(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lightOpacity = 255;
    }

    @Override
    public String getIEBlockName() {
        return this.name;
    }

    @Override
    public Enum[] getMetaEnums() {
        return this.enumValues;
    }

    @Override
    public IBlockState getInventoryState(int meta) {
        IBlockState state = this.blockState.getBaseState().withProperty(this.property, this.enumValues[meta]);
        return state;
    }

    public PropertyEnum<E> getMetaProperty() {
        return this.property;
    }

    @Override
    public boolean useCustomStateMapper() {
        return false;
    }

    @Override
    public String getCustomStateMapping(int meta, boolean itemBlock) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public StateMapperBase getCustomMapper() {
        return null;
    }

    @Override
    public boolean appendPropertiesToState() {
        return true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        String subName = ((Enum)((Object)this.getStateFromMeta(stack.getItemDamage()).getValue(this.property))).toString().toLowerCase(Locale.US);
        return super.getUnlocalizedName() + "." + subName;
    }

    protected static Material setTempProperties(Material material, PropertyEnum<?> property, Object ... additionalProperties) {
        ArrayList<Object> propList = new ArrayList<Object>();
        ArrayList<Object> unlistedPropList = new ArrayList<Object>();
        propList.add(property);
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                for (IProperty iProperty : (IProperty[])o) {
                    propList.add(iProperty);
                }
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            for (IProperty iProperty : (IUnlistedProperty[])o) {
                unlistedPropList.add(iProperty);
            }
        }
        tempProperties = propList.toArray(new IProperty[propList.size()]);
        tempUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
        return material;
    }

    protected static Object[] combineProperties(Object[] currentProperties, Object ... addedProperties) {
        int i;
        Object[] array = new Object[currentProperties.length + addedProperties.length];
        for (i = 0; i < currentProperties.length; ++i) {
            array[i] = currentProperties[i];
        }
        for (i = 0; i < addedProperties.length; ++i) {
            array[currentProperties.length + i] = addedProperties[i];
        }
        return array;
    }

    public BlockIEBase setMetaHidden(int ... meta) {
        for (int i : meta) {
            if (i < 0 || i >= this.isMetaHidden.length) continue;
            this.isMetaHidden[i] = true;
        }
        return this;
    }

    public BlockIEBase setMetaUnhidden(int ... meta) {
        for (int i : meta) {
            if (i < 0 || i >= this.isMetaHidden.length) continue;
            this.isMetaHidden[i] = false;
        }
        return this;
    }

    public boolean isMetaHidden(int meta) {
        return this.isMetaHidden[Math.max(0, Math.min(meta, this.isMetaHidden.length - 1))];
    }

    public BlockIEBase setHasFlavour(int ... meta) {
        if (meta == null || meta.length < 1) {
            for (int i = 0; i < this.hasFlavour.length; ++i) {
                this.hasFlavour[i] = true;
            }
        } else {
            for (int i : meta) {
                if (i < 0 || i >= this.hasFlavour.length) continue;
                this.hasFlavour[i] = false;
            }
        }
        return this;
    }

    public boolean hasFlavour(ItemStack stack) {
        return this.hasFlavour[Math.max(0, Math.min(stack.getItemDamage(), this.hasFlavour.length - 1))];
    }

    public BlockIEBase<E> setBlockLayer(BlockRenderLayer ... layer) {
        this.renderLayers = Sets.newHashSet((Object[])layer);
        return this;
    }

    public BlockIEBase<E> setMetaBlockLayer(int meta, BlockRenderLayer ... layer) {
        this.metaRenderLayers[Math.max((int)0, (int)Math.min((int)meta, (int)(this.metaRenderLayers.length - 1)))] = Sets.newHashSet((Object[])layer);
        return this;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        int meta;
        if (cachedTileRequestState != null && (meta = this.getMetaFromState(cachedTileRequestState)) >= 0 && meta < this.metaRenderLayers.length && this.metaRenderLayers[meta] != null) {
            return this.metaRenderLayers[meta].contains(layer);
        }
        return this.renderLayers.contains(layer);
    }

    public BlockIEBase<E> setMetaLightOpacity(int meta, int opacity) {
        this.metaLightOpacities.put(meta, opacity);
        return this;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess w, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        if (this.metaLightOpacities.containsKey(meta)) {
            return this.metaLightOpacities.get(meta);
        }
        return super.getLightOpacity(state, w, pos);
    }

    public BlockIEBase<E> setMetaHardness(int meta, float hardness) {
        this.metaHardness.put(meta, Float.valueOf(hardness));
        return this;
    }

    public float getBlockHardness(IBlockState state, World world, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        if (this.metaHardness.containsKey(meta)) {
            return this.metaHardness.get(meta).floatValue();
        }
        return super.getBlockHardness(state, world, pos);
    }

    public BlockIEBase<E> setMetaExplosionResistance(int meta, int resistance) {
        this.metaResistances.put(meta, resistance);
        return this;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        int meta = this.getMetaFromState(world.getBlockState(pos));
        if (this.metaResistances.containsKey(meta)) {
            return this.metaResistances.get(meta).intValue();
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public BlockIEBase<E> setMetaMobilityFlag(int meta, EnumPushReaction flag) {
        this.metaMobilityFlags[meta] = flag;
        return this;
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        int meta = this.getMetaFromState(state);
        if (this.metaMobilityFlags[meta] == null) {
            return EnumPushReaction.NORMAL;
        }
        return this.metaMobilityFlags[meta];
    }

    public BlockIEBase<E> setNotNormalBlock(int meta) {
        if (this.metaNotNormalBlock == null) {
            this.metaNotNormalBlock = new boolean[this.enumValues.length];
        }
        this.metaNotNormalBlock[meta] = true;
        return this;
    }

    public BlockIEBase<E> setAllNotNormalBlock() {
        if (this.metaNotNormalBlock == null) {
            this.metaNotNormalBlock = new boolean[this.enumValues.length];
        }
        for (int i = 0; i < this.metaNotNormalBlock.length; ++i) {
            this.metaNotNormalBlock[i] = true;
        }
        return this;
    }

    protected boolean normalBlockCheck(IBlockState state) {
        if (this.metaNotNormalBlock == null) {
            return true;
        }
        int meta = this.getMetaFromState(state);
        return meta < 0 || meta >= this.metaNotNormalBlock.length || !this.metaNotNormalBlock[meta];
    }

    public boolean isFullBlock(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean isFullCube(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean causesSuffocation(IBlockState state) {
        if (this.metaNotNormalBlock == null) {
            return true;
        }
        int majority = 0;
        for (boolean b : this.metaNotNormalBlock) {
            if (!b) continue;
            ++majority;
        }
        return majority < this.metaNotNormalBlock.length / 2;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.normalBlockCheck(state);
    }

    public boolean hasTileEntity(IBlockState state) {
        cachedTileRequestState = state;
        return super.hasTileEntity(state);
    }

    protected BlockStateContainer createNotTempBlockState() {
        IProperty[] array = new IProperty[1 + this.additionalProperties.length];
        array[0] = this.property;
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            array[1 + i] = this.additionalProperties[i];
        }
        if (this.additionalUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, array, this.additionalUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, array);
    }

    protected IBlockState getInitDefaultState() {
        IBlockState state = this.blockState.getBaseState().withProperty(this.property, this.enumValues[0]);
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            if (this.additionalProperties[i] == null || this.additionalProperties[i].getAllowedValues().isEmpty()) continue;
            state = this.applyProperty(state, this.additionalProperties[i], this.additionalProperties[i].getAllowedValues().iterator().next());
        }
        return state;
    }

    protected <V extends Comparable<V>> IBlockState applyProperty(IBlockState in, IProperty<V> prop, Object val) {
        return in.withProperty(prop, (Comparable)val);
    }

    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean canIEBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    protected BlockStateContainer createBlockState() {
        if (this.property != null) {
            return this.createNotTempBlockState();
        }
        if (tempUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, tempProperties, tempUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, tempProperties);
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
    }

    public int getMetaFromState(IBlockState state) {
        if (state == null || !this.equals(state.getBlock())) {
            return 0;
        }
        return ((IBlockEnum)((Object)((Enum)((Object)state.getValue(this.property))))).getMeta();
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            if (this.additionalProperties[i] == null || this.additionalProperties[i].getAllowedValues().isEmpty()) continue;
            state = this.applyProperty(state, this.additionalProperties[i], this.additionalProperties[i].getAllowedValues().toArray()[0]);
        }
        return state;
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState().withProperty(this.property, this.fromMeta(meta));
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            if (this.additionalProperties[i] == null || this.additionalProperties[i].getAllowedValues().isEmpty()) continue;
            state = this.applyProperty(state, this.additionalProperties[i], this.additionalProperties[i].getAllowedValues().toArray()[0]);
        }
        return state;
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.enumValues.length) {
            meta = 0;
        }
        return this.enumValues[meta];
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (E type : this.enumValues) {
            if (!((IBlockEnum)type).listForCreative() || this.isMetaHidden[((IBlockEnum)type).getMeta()]) continue;
            list.add((Object)new ItemStack((Block)this, 1, ((IBlockEnum)type).getMeta()));
        }
    }

    void adjustSound() {
        if (this.blockMaterial == Material.ANVIL) {
            this.blockSoundType = SoundType.ANVIL;
        } else if (this.blockMaterial == Material.CARPET || this.blockMaterial == Material.CLOTH) {
            this.blockSoundType = SoundType.CLOTH;
        } else if (this.blockMaterial == Material.GLASS || this.blockMaterial == Material.ICE) {
            this.blockSoundType = SoundType.GLASS;
        } else if (this.blockMaterial == Material.GRASS || this.blockMaterial == Material.TNT || this.blockMaterial == Material.PLANTS || this.blockMaterial == Material.VINE) {
            this.blockSoundType = SoundType.PLANT;
        } else if (this.blockMaterial == Material.GROUND) {
            this.blockSoundType = SoundType.GROUND;
        } else if (this.blockMaterial == Material.IRON) {
            this.blockSoundType = SoundType.METAL;
        } else if (this.blockMaterial == Material.SAND) {
            this.blockSoundType = SoundType.SAND;
        } else if (this.blockMaterial == Material.SNOW) {
            this.blockSoundType = SoundType.SNOW;
        } else if (this.blockMaterial == Material.ROCK) {
            this.blockSoundType = SoundType.STONE;
        } else if (this.blockMaterial == Material.WOOD || this.blockMaterial == Material.CACTUS) {
            this.blockSoundType = SoundType.WOOD;
        }
    }

    public boolean eventReceived(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.isRemote && eventID == 255) {
            worldIn.notifyBlockUpdate(pos, state, state, 3);
            return true;
        }
        return super.eventReceived(state, worldIn, pos, eventID, eventParam);
    }

    public BlockIEBase<E> setMetaHammerHarvest(int meta) {
        this.canHammerHarvest[meta] = true;
        return this;
    }

    public BlockIEBase<E> setHammerHarvest() {
        for (int i = 0; i < this.metaNotNormalBlock.length; ++i) {
            this.canHammerHarvest[i] = true;
        }
        return this;
    }

    public boolean allowHammerHarvest(IBlockState blockState) {
        int meta = this.getMetaFromState(blockState);
        if (meta >= 0 && meta < this.canHammerHarvest.length) {
            return this.canHammerHarvest[meta];
        }
        return false;
    }

    public boolean allowWirecutterHarvest(IBlockState blockState) {
        return false;
    }

    public boolean isOpaqueCube() {
        return this.opaqueCube;
    }

    public BlockIEBase<E> setOpaque(boolean isOpaque) {
        this.opaqueCube = isOpaque;
        this.fullBlock = isOpaque;
        return this;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        if (this.allowHammerHarvest(state) && type.equals("IE_HAMMER")) {
            return true;
        }
        if (this.allowWirecutterHarvest(state) && type.equals("IE_WIRECUTTER")) {
            return true;
        }
        return super.isToolEffective(type, state);
    }

    public String createRegistryName() {
        return "immersiveengineering:" + this.name;
    }

    public static abstract class IELadderBlock<E extends Enum<E>>
    extends BlockIEBase<E> {
        public IELadderBlock(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockIEBase> itemBlock, Object ... additionalProperties) {
            super(name, material, mainProperty, itemBlock, additionalProperties);
        }

        public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            super.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
            if (entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).isOnLadder() && this.isLadder(state, (IBlockAccess)worldIn, pos, (EntityLivingBase)entityIn)) {
                float f5 = 0.15f;
                if (entityIn.motionX < (double)(-f5)) {
                    entityIn.motionX = -f5;
                }
                if (entityIn.motionX > (double)f5) {
                    entityIn.motionX = f5;
                }
                if (entityIn.motionZ < (double)(-f5)) {
                    entityIn.motionZ = -f5;
                }
                if (entityIn.motionZ > (double)f5) {
                    entityIn.motionZ = f5;
                }
                entityIn.fallDistance = 0.0f;
                if (entityIn.motionY < -0.15) {
                    entityIn.motionY = -0.15;
                }
                if (entityIn.motionY < 0.0 && entityIn instanceof EntityPlayer && entityIn.isSneaking()) {
                    entityIn.motionY = 0.0;
                    return;
                }
                if (entityIn.isCollidedHorizontally) {
                    entityIn.motionY = 0.2;
                }
            }
        }
    }

    public static interface IBlockEnum
    extends IStringSerializable {
        public int getMeta();

        public boolean listForCreative();
    }
}

