/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_FakeLight;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFakeLight
extends BlockIETileProvider<BlockTypes_FakeLight> {
    public BlockFakeLight() {
        super("fake_light", Material.AIR, PropertyEnum.create((String)"type", BlockTypes_FakeLight.class), ItemBlockIEBase.class, new Object[0]);
        this.setAllNotNormalBlock();
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos) {
        return null;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean canCollideCheck(IBlockState state, boolean b) {
        return false;
    }

    public boolean isCollidable() {
        return false;
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, World par1World, BlockPos pos, Vec3d par5Vec3, Vec3d par6Vec3) {
        return null;
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public TileEntity createBasicTE(World worldIn, BlockTypes_FakeLight meta) {
        return new TileEntityFakeLight();
    }

    public static class TileEntityFakeLight
    extends TileEntityIEBase
    implements ITickable,
    IEBlockInterfaces.ISpawnInterdiction,
    IEBlockInterfaces.ILightValue {
        public int[] floodlightCoords = new int[]{-1, -1, -1};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileEntityFakeLight() {
            if (Config.IEConfig.Machines.floodlight_spawnPrevent) {
                ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
                synchronized (arrayList) {
                    if (!EventHandler.interdictionTiles.contains(this)) {
                        EventHandler.interdictionTiles.add(this);
                    }
                }
            }
        }

        public void update() {
            if (this.world.getTotalWorldTime() % 256L == (long)((this.getPos().getX() ^ this.getPos().getZ()) & 0xFF)) {
                if (this.floodlightCoords == null || this.floodlightCoords.length < 3) {
                    this.world.setBlockToAir(this.getPos());
                    return;
                }
                BlockPos floodlightPos = new BlockPos(this.floodlightCoords[0], this.floodlightCoords[1], this.floodlightCoords[2]);
                TileEntity tile = Utils.getExistingTileEntity(this.world, floodlightPos);
                if (!(tile instanceof TileEntityFloodlight) || !((TileEntityFloodlight)tile).active) {
                    this.world.setBlockToAir(this.getPos());
                    return;
                }
            }
        }

        @Override
        public int getLightValue() {
            return 15;
        }

        @Override
        public double getInterdictionRangeSquared() {
            return 1024.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.remove(this);
                }
            }
            super.invalidate();
        }

        @Override
        public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
            this.floodlightCoords = nbt.getIntArray("floodlightCoords");
        }

        @Override
        public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
            nbt.setIntArray("floodlightCoords", this.floodlightCoords);
        }
    }
}

