/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockTypes_ClothDevice;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressUnpackingRecipe;
import blusunrize.immersiveengineering.common.crafting.RecipeBannerAdvanced;
import blusunrize.immersiveengineering.common.crafting.RecipeEarmuffs;
import blusunrize.immersiveengineering.common.crafting.RecipeFlareBullets;
import blusunrize.immersiveengineering.common.crafting.RecipeJerrycan;
import blusunrize.immersiveengineering.common.crafting.RecipePotionBullets;
import blusunrize.immersiveengineering.common.crafting.RecipePowerpack;
import blusunrize.immersiveengineering.common.crafting.RecipeRGBColouration;
import blusunrize.immersiveengineering.common.crafting.RecipeRevolver;
import blusunrize.immersiveengineering.common.crafting.RecipeShaderBags;
import blusunrize.immersiveengineering.common.crafting.RecipeSpeeloader;
import blusunrize.immersiveengineering.common.items.ItemGraphiteElectrode;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

public class IERecipes {
    public static HashMap<String, ItemStack> oreOutputModifier = new HashMap();
    public static HashMap<String, Object[]> oreOutputSecondaries = new HashMap();
    public static ArrayList<String> hammerCrushingList = new ArrayList();
    public static HashMap<String, ItemStack> arcOutputModifier = new HashMap();
    public static HashSet<String> arcBlacklist = new HashSet();

    public static void initCraftingRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new RecipeBannerAdvanced().setRegistryName("immersiveengineering", "banners"));
        registry.register(new RecipeRevolver().setRegistryName("immersiveengineering", "revolver_Loop"));
        registry.register(new RecipeRevolver().setRegistryName("immersiveengineering", "revolver_Loop"));
        registry.register(new RecipeSpeeloader().setRegistryName("immersiveengineering", "speedloader_load"));
        registry.register(new RecipeJerrycan().setRegistryName("immersiveengineering", "jerrycan"));
        registry.register(new RecipeShaderBags().setRegistryName("immersiveengineering", "shader_bags"));
        registry.register(new RecipeEarmuffs().setRegistryName("immersiveengineering", "earmuffs"));
        registry.register(new RecipePowerpack().setRegistryName("immersiveengineering", "powerpack"));
        ItemStack stripCurtain = new ItemStack((Block)IEContent.blockClothDevice, 1, BlockTypes_ClothDevice.STRIPCURTAIN.getMeta());
        registry.register(new RecipeRGBColouration(s -> OreDictionary.itemMatches((ItemStack)stripCurtain, (ItemStack)s, (boolean)true), s -> ItemNBTHelper.hasKey(s, "colour") ? ItemNBTHelper.getInt(s, "colour") : 0xFFFFFF, (s, i) -> ItemNBTHelper.setInt(s, "colour", i)).setRegistryName("immersiveengineering", "stripcurtain_colour"));
    }

    public static void addShapelessOredictRecipe(String registryName, ItemStack output, Object ... recipe) {
        ShapelessOreRecipe sor = new ShapelessOreRecipe(null, output, recipe);
        if (registryName == null) {
            registryName = "immersiveengineering:";
            if (output.getItem() instanceof ItemIEBase) {
                registryName = registryName + ((ItemIEBase)output.getItem()).itemName + "_" + ((ItemIEBase)output.getItem()).getSubNames()[output.getMetadata()] + "*" + output.getCount();
            } else {
                int idx = output.getUnlocalizedName().lastIndexOf(":");
                registryName = registryName + output.getUnlocalizedName().substring(idx < 0 ? 0 : idx) + "_" + output.getMetadata() + "*" + output.getCount();
            }
        } else if (!registryName.startsWith("immersiveengineering")) {
            registryName = "immersiveengineering:" + registryName;
        }
        ForgeRegistries.RECIPES.register(sor.setRegistryName(registryName));
    }

    public static void initBlueprintRecipes() {
        BlueprintCraftingRecipe.addRecipe("components", new ItemStack((Item)IEContent.itemMaterial, 1, 8), "plateIron", "plateIron", "ingotCopper");
        BlueprintCraftingRecipe.addRecipe("components", new ItemStack((Item)IEContent.itemMaterial, 1, 9), "plateSteel", "plateSteel", "ingotCopper");
        BlueprintCraftingRecipe.addRecipe("components", new ItemStack((Item)IEContent.itemMaterial, 3, 26), "blockGlass", "wireCopper", "wireCopper", "dustRedstone");
        BlueprintCraftingRecipe.addRecipe("components", new ItemStack((Item)IEContent.itemMaterial, 1, 27), new ItemStack((Block)IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.INSULATING_GLASS.getMeta()), "plateCopper", "electronTube", "electronTube");
        for (int i = 0; i < IEContent.itemMold.getSubNames().length; ++i) {
            if (IEContent.itemMold.isMetaHidden(i)) continue;
            BlueprintCraftingRecipe.addRecipe("molds", new ItemStack((Item)IEContent.itemMold, 1, i), "plateSteel", "plateSteel", "plateSteel", "plateSteel", "plateSteel", new ItemStack((Item)IEContent.itemTool, 1, 1));
        }
        ItemStack bullet = BulletHandler.getBulletStack("casull");
        BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, "nuggetLead", "nuggetLead");
        bullet = BulletHandler.getBulletStack("armorPiercing");
        BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, "nuggetSteel", "nuggetSteel", "nuggetConstantan", "nuggetConstantan");
        if (ApiUtils.isExistingOreName("nuggetTungsten")) {
            BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, "nuggetTungsten", "nuggetTungsten");
        }
        bullet = BulletHandler.getBulletStack("silver");
        BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, "nuggetLead", "nuggetLead", "nuggetSilver");
        bullet = BulletHandler.getBulletStack("buckshot");
        BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, "dustIron");
        bullet = BulletHandler.getBulletStack("HE");
        BlueprintCraftingRecipe.addRecipe("bullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, Blocks.TNT);
        bullet = BulletHandler.getBulletStack("dragonsbreath");
        BlueprintCraftingRecipe.addRecipe("specialBullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, "dustAluminum", "dustAluminum");
        bullet = BulletHandler.getBulletStack("potion");
        BlueprintCraftingRecipe.addRecipe("specialBullet", bullet, new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.GUNPOWDER, Items.GLASS_BOTTLE);
        ForgeRegistries.RECIPES.register(new RecipePotionBullets().setRegistryName("immersiveengineering", "bullet_potion"));
        bullet = BulletHandler.getBulletStack("flare");
        ItemNBTHelper.setInt(bullet, "flareColour", 13381126);
        BlueprintCraftingRecipe.addRecipe("specialBullet", bullet.copy(), new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, "dustAluminum", "dyeRed");
        ItemNBTHelper.setInt(bullet, "flareColour", 2925323);
        BlueprintCraftingRecipe.addRecipe("specialBullet", bullet.copy(), new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, "dustAluminum", "dyeGreen");
        ItemNBTHelper.setInt(bullet, "flareColour", 0xFFFF82);
        BlueprintCraftingRecipe.addRecipe("specialBullet", bullet.copy(), new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, "dustAluminum", "dyeYellow");
        ForgeRegistries.RECIPES.register(new RecipeFlareBullets().setRegistryName("immersiveengineering", "potion_flare"));
        if (!BulletHandler.homingCartridges.isEmpty()) {
            bullet = BulletHandler.getBulletStack("wolfpack");
            ArrayList<ItemStack> homingCartridges = new ArrayList<ItemStack>();
            for (String s : BulletHandler.homingCartridges) {
                homingCartridges.add(BulletHandler.getBulletStack(s));
            }
            BlueprintCraftingRecipe.addRecipe("specialBullet", bullet.copy(), new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.GUNPOWDER, homingCartridges, homingCartridges, homingCartridges, homingCartridges);
        }
        BlueprintCraftingRecipe.addVillagerTrade("bullet", new ItemStack(Items.EMERALD, 1, 2));
        BlueprintCraftingRecipe.addVillagerTrade("specialBullet", new ItemStack(Items.EMERALD, 1, 7));
        BlueprintCraftingRecipe.addRecipe("electrode", new ItemStack((Item)IEContent.itemGraphiteElectrode), "ingotHOPGraphite", "ingotHOPGraphite", "ingotHOPGraphite", "ingotHOPGraphite");
        BlueprintCraftingRecipe.addVillagerTrade("electrode", new ItemStack(Items.EMERALD, 1, 18));
    }

    public static void initFurnaceRecipes() {
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 0), new ItemStack((Item)IEContent.itemMetal, 1, 0), 0.3f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 1), new ItemStack((Item)IEContent.itemMetal, 1, 1), 0.3f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 2), new ItemStack((Item)IEContent.itemMetal, 1, 2), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 3), new ItemStack((Item)IEContent.itemMetal, 1, 3), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 4), new ItemStack((Item)IEContent.itemMetal, 1, 4), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Block)IEContent.blockOre, 1, 5), new ItemStack((Item)IEContent.itemMetal, 1, 5), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 9), new ItemStack((Item)IEContent.itemMetal, 1, 0), 0.3f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 10), new ItemStack((Item)IEContent.itemMetal, 1, 1), 0.3f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 11), new ItemStack((Item)IEContent.itemMetal, 1, 2), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 12), new ItemStack((Item)IEContent.itemMetal, 1, 3), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 13), new ItemStack((Item)IEContent.itemMetal, 1, 4), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 14), new ItemStack((Item)IEContent.itemMetal, 1, 5), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 15), new ItemStack((Item)IEContent.itemMetal, 1, 6), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 16), new ItemStack((Item)IEContent.itemMetal, 1, 7), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 17), new ItemStack((Item)IEContent.itemMetal, 1, 8), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 18), new ItemStack(Items.IRON_INGOT), 0.7f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 19), new ItemStack(Items.GOLD_INGOT), 1.0f);
        FurnaceRecipes.instance().addSmeltingRecipe(new ItemStack((Item)IEContent.itemMaterial, 1, 18), new ItemStack((Item)IEContent.itemMaterial, 1, 19), 0.5f);
    }

    public static void initBlastFurnaceRecipes() {
        BlastFurnaceRecipe.addRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 8), "ingotIron", 1200, new ItemStack((Item)IEContent.itemMaterial, 1, 7));
        BlastFurnaceRecipe.addRecipe(new ItemStack((Block)IEContent.blockStorage, 1, 8), "blockIron", 10800, new ItemStack((Item)IEContent.itemMaterial, 9, 7));
        BlastFurnaceRecipe.addBlastFuel("fuelCoke", 1200);
        BlastFurnaceRecipe.addBlastFuel("blockFuelCoke", 12000);
        BlastFurnaceRecipe.addBlastFuel("charcoal", 300);
        BlastFurnaceRecipe.addBlastFuel("blockCharcoal", 3000);
    }

    public static void initMetalPressRecipes() {
        MetalPressRecipe.addRecipe(new ItemStack((Item)IEContent.itemBullet, 2, 0), (Object)"ingotCopper", new ItemStack((Item)IEContent.itemMold, 1, 3), 2400);
        ItemStack shoddyElectrode = new ItemStack((Item)IEContent.itemGraphiteElectrode);
        shoddyElectrode.setItemDamage(ItemGraphiteElectrode.electrodeMaxDamage / 2);
        MetalPressRecipe.addRecipe(shoddyElectrode, (Object)"ingotHOPGraphite", new ItemStack((Item)IEContent.itemMold, 1, 2), 4800).setInputSize(4);
        ComparableItemStack mold = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 5));
        MetalPressRecipe.recipeList.put((Object)mold, (Object)new MetalPressPackingRecipe(mold, 3200, 2));
        mold = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 6));
        MetalPressRecipe.recipeList.put((Object)mold, (Object)new MetalPressPackingRecipe(mold, 3200, 3));
        mold = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 7));
        MetalPressRecipe.recipeList.put((Object)mold, (Object)new MetalPressUnpackingRecipe(mold, 3200));
    }

    public static void initCrusherRecipes() {
        oreOutputSecondaries.put("Iron", new Object[]{"dustNickel", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Gold", new Object[]{"crystalCinnabar", Float.valueOf(0.05f)});
        oreOutputSecondaries.put("Copper", new Object[]{"dustGold", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Lead", new Object[]{"dustSilver", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Silver", new Object[]{"dustLead", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Nickel", new Object[]{"dustPlatinum", Float.valueOf(0.1f)});
        oreOutputModifier.put("Lapis", new ItemStack(Items.DYE, 9, 4));
        oreOutputSecondaries.put("Lapis", new Object[]{"dustSulfur", Float.valueOf(0.15f)});
        oreOutputModifier.put("Diamond", new ItemStack(Items.DIAMOND, 2));
        oreOutputModifier.put("Redstone", new ItemStack(Items.REDSTONE, 6));
        oreOutputSecondaries.put("Redstone", new Object[]{"crystalCinnabar", Float.valueOf(0.25f)});
        oreOutputModifier.put("Emerald", new ItemStack(Items.EMERALD, 2));
        oreOutputModifier.put("Quartz", new ItemStack(Items.QUARTZ, 3));
        oreOutputSecondaries.put("Quartz", new Object[]{"dustSulfur", Float.valueOf(0.15f)});
        oreOutputModifier.put("Coal", new ItemStack(Items.COAL, 4));
        oreOutputSecondaries.put("Platinum", new Object[]{"dustNickel", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Tungsten", new Object[]{"dustManganese", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Uranium", new Object[]{"dustLead", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Yellorium", new Object[]{"dustLead", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("Plutonium", new Object[]{"dustUranium", Float.valueOf(0.1f)});
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation("IC2", "itemOreIridium"));
        oreOutputSecondaries.put("Osmium", new Object[]{item, Float.valueOf(0.01f)});
        oreOutputSecondaries.put("Iridium", new Object[]{"dustPlatium", Float.valueOf(0.1f)});
        oreOutputSecondaries.put("FzDarkIron", new Object[]{"dustIron", Float.valueOf(0.1f)});
        item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation("Railcraft", "firestone.raw"));
        if (item != null) {
            oreOutputModifier.put("Firestone", new ItemStack(item));
        }
        oreOutputSecondaries.put("Nikolite", new Object[]{Items.DIAMOND, Float.valueOf(0.025f)});
        IERecipes.addCrusherRecipe(new ItemStack(Blocks.GRAVEL), "cobblestone", 1600, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Block)Blocks.SAND), Blocks.GRAVEL, 1600, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Block)Blocks.SAND), "itemSlag", 1600, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Block)Blocks.SAND), "blockGlass", 3200, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Block)Blocks.SAND, 2), "sandstone", 1600, new ItemStack((Item)IEContent.itemMaterial, 1, 24), Float.valueOf(0.5f));
        IERecipes.addCrusherRecipe(new ItemStack(Items.QUARTZ, 4), "blockQuartz", 3200, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack(Items.GLOWSTONE_DUST, 4), "glowstone", 3200, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack(Items.BLAZE_POWDER, 4), "rodBlaze", 3200, new ItemStack((Item)IEContent.itemMaterial, 1, 25), Float.valueOf(0.5f));
        IERecipes.addCrusherRecipe(new ItemStack(Items.DYE, 6, 15), Items.BONE, 3200, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Item)IEContent.itemMaterial, 1, 17), "fuelCoke", 2400, new Object[0]);
        IERecipes.addCrusherRecipe(new ItemStack((Item)IEContent.itemMaterial, 9, 17), "blockFuelCoke", 4800, new Object[0]);
        IERecipes.addItemToOreDictCrusherRecipe("dustCoal", 1, new ItemStack(Items.COAL), 2400);
        IERecipes.addItemToOreDictCrusherRecipe("dustObsidian", 4, Blocks.OBSIDIAN, 6000);
        for (int i = 0; i < 16; ++i) {
            CrusherRecipe r = CrusherRecipe.addRecipe(new ItemStack(Items.STRING, 4), new ItemStack(Blocks.WOOL, 1, i), 3200);
            if (i == 0) continue;
            r.addToSecondaryOutput(new ItemStack(Items.DYE, 1, 15 - i), Float.valueOf(0.05f));
        }
    }

    public static void postInitOreDictRecipes() {
        boolean allowHammerCrushing = !Config.IEConfig.Tools.disableHammerCrushing;
        ComparableItemStack compMoldPlate = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 0));
        ComparableItemStack compMoldGear = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 1));
        ComparableItemStack compMoldRod = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 2));
        ComparableItemStack compMoldWire = ApiUtils.createComparableItemStack(new ItemStack((Item)IEContent.itemMold, 1, 4));
        for (String name : OreDictionary.getOreNames()) {
            String ore;
            if (!ApiUtils.isExistingOreName(name)) continue;
            if (name.startsWith("ore")) {
                ore = name.substring("ore".length());
                ItemStack out = oreOutputModifier.get(ore);
                if (out == null || out.isEmpty()) {
                    if (ApiUtils.isExistingOreName("gem" + ore)) {
                        out = Utils.copyStackWithAmount(IEApi.getPreferredOreStack("gem" + ore), 2);
                    } else if (ApiUtils.isExistingOreName("dust" + ore)) {
                        ItemStack preferredDust = IEApi.getPreferredOreStack("dust" + ore);
                        out = Utils.copyStackWithAmount(preferredDust, 2);
                        if (allowHammerCrushing) {
                            IERecipes.addShapelessOredictRecipe("hammercrushing_" + ore, preferredDust, name, new ItemStack((Item)IEContent.itemTool));
                            hammerCrushingList.add(ore);
                        }
                    }
                }
                if (out != null && !out.isEmpty()) {
                    Object[] secondaries = oreOutputSecondaries.get(ore);
                    Object s = secondaries != null && secondaries.length > 1 ? secondaries[0] : null;
                    Float f = Float.valueOf(secondaries != null && secondaries.length > 1 && secondaries[1] instanceof Float ? ((Float)secondaries[1]).floatValue() : 0.0f);
                    IERecipes.addOreProcessingRecipe(out, ore, 6000, true, s, f.floatValue());
                }
                if (((out = arcOutputModifier.get(ore)) == null || out.isEmpty()) && ApiUtils.isExistingOreName("ingot" + ore)) {
                    out = Utils.copyStackWithAmount(IEApi.getPreferredOreStack("ingot" + ore), 2);
                }
                if (out == null || out.isEmpty() || arcBlacklist.contains(ore)) continue;
                IERecipes.addArcOreSmelting(out, ore);
                continue;
            }
            if (name.startsWith("gem")) {
                ore = name.substring("gem".length());
                if (!ApiUtils.isExistingOreName("dust" + ore)) continue;
                IERecipes.addCrusherRecipe(IEApi.getPreferredOreStack("dust" + ore), "gem" + ore, 6000, null, 0);
                continue;
            }
            if (name.startsWith("dust")) {
                ore = name.substring("dust".length());
                ItemStack out = arcOutputModifier.get(ore);
                if (out == null || out.isEmpty()) {
                    if (ApiUtils.isExistingOreName("ingot" + ore)) {
                        out = IEApi.getPreferredOreStack("ingot" + ore);
                    }
                } else {
                    out = Utils.copyStackWithAmount(out, out.getCount() / 2);
                }
                if (out != null && !out.isEmpty() && !arcBlacklist.contains(ore)) {
                    IERecipes.addArcRecipe(out, "dust" + ore, 100, 512, ItemStack.EMPTY, new Object[0]);
                }
                if (!ApiUtils.isExistingOreName("ingot" + ore)) continue;
                IERecipes.addCrusherRecipe(IEApi.getPreferredOreStack("dust" + ore), "ingot" + ore, 3600, null, 0);
                continue;
            }
            if (name.startsWith("plate")) {
                ore = name.substring("plate".length());
                if (!ApiUtils.isExistingOreName("ingot" + ore)) continue;
                MetalPressRecipe.addRecipe(IEApi.getPreferredOreStack(name), (Object)("ingot" + ore), compMoldPlate, 2400);
                continue;
            }
            if (name.startsWith("gear")) {
                IEContent.itemMold.setMetaUnhidden(1);
                ore = name.substring("gear".length());
                if (!ApiUtils.isExistingOreName("ingot" + ore)) continue;
                MetalPressRecipe.addRecipe(IEApi.getPreferredOreStack(name), (Object)("ingot" + ore), compMoldGear, 2400).setInputSize(4);
                continue;
            }
            if (name.startsWith("stick") || name.startsWith("rod")) {
                boolean priorityStick;
                ore = name.startsWith("stick") ? name.substring("stick".length()) : name.substring("rod".length());
                boolean bl = priorityStick = !name.startsWith("rod") || !ApiUtils.isExistingOreName("stick" + ore);
                if (!priorityStick || !ApiUtils.isExistingOreName("ingot" + ore)) continue;
                MetalPressRecipe.addRecipe(Utils.copyStackWithAmount(IEApi.getPreferredOreStack(name), 2), (Object)("ingot" + ore), compMoldRod, 2400);
                continue;
            }
            if (!name.startsWith("wire")) continue;
            ore = name.substring("wire".length());
            if (!ApiUtils.isExistingOreName("ingot" + ore)) continue;
            MetalPressRecipe.addRecipe(Utils.copyStackWithAmount(IEApi.getPreferredOreStack(name), 2), (Object)("ingot" + ore), compMoldWire, 2400);
        }
        Config.manual_bool.put("crushingOreRecipe", !hammerCrushingList.isEmpty());
    }

    public static CrusherRecipe addCrusherRecipe(ItemStack output, Object input, int energy, Object ... secondary) {
        CrusherRecipe r = CrusherRecipe.addRecipe(output, input, energy);
        if (secondary != null && secondary.length > 0) {
            r.addToSecondaryOutput(secondary);
        }
        return r;
    }

    public static void addOreProcessingRecipe(ItemStack output, String ore, int energy, boolean ingot, Object secondary, float secChance) {
        if (ingot && ApiUtils.isExistingOreName("ingot" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(output, output.getCount() / 2), "ingot" + ore, (int)((float)energy * 0.6f), new Object[0]);
        }
        if (ApiUtils.isExistingOreName("ore" + ore)) {
            IERecipes.addCrusherRecipe(output, "ore" + ore, energy, secondary, Float.valueOf(secChance));
        }
        if (ApiUtils.isExistingOreName("oreNetherrack" + ore)) {
            IERecipes.addCrusherRecipe(output, "oreNetherrack" + ore, energy, secondary, Float.valueOf(secChance), new ItemStack(Blocks.NETHERRACK), Float.valueOf(0.15f));
        }
        if (ApiUtils.isExistingOreName("oreEndstone" + ore)) {
            IERecipes.addCrusherRecipe(output, "oreEndstone" + ore, energy, secondary, Float.valueOf(secChance), "dustEndstone", Float.valueOf(0.5f));
        }
        if (ApiUtils.isExistingOreName("oreBlackgranite" + ore)) {
            IERecipes.addCrusherRecipe(output, "oreBlackgranite" + ore, energy, secondary, Float.valueOf(secChance), "dustGraniteBlack", Float.valueOf(0.5f));
        }
        if (ApiUtils.isExistingOreName("oreRedgranite" + ore)) {
            IERecipes.addCrusherRecipe(output, "oreRedgranite" + ore, energy, secondary, Float.valueOf(secChance), "dustGraniteBlack", Float.valueOf(0.5f));
        }
    }

    public static void addOreDictCrusherRecipe(String ore, Object secondary, float chance) {
        if (!ApiUtils.isExistingOreName("dust" + ore)) {
            return;
        }
        ItemStack dust = IEApi.getPreferredOreStack("dust" + ore);
        if (dust.isEmpty()) {
            return;
        }
        if (ApiUtils.isExistingOreName("ore" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 2), "ore" + ore, 6000, secondary, Float.valueOf(chance));
        }
        if (ApiUtils.isExistingOreName("ingot" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 1), "ingot" + ore, 3600, new Object[0]);
        }
        if (ApiUtils.isExistingOreName("oreNetherrack" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 2), "oreNetherrack" + ore, 6000, secondary, Float.valueOf(chance), new ItemStack(Blocks.NETHERRACK), Float.valueOf(0.15f));
        }
        if (ApiUtils.isExistingOreName("oreEndstone" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 2), "oreEndstone" + ore, 6000, secondary, Float.valueOf(chance), "dustEndstone", Float.valueOf(0.5f));
        }
        if (ApiUtils.isExistingOreName("oreBlackgranite" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 2), "oreBlackgranite" + ore, 6000, secondary, Float.valueOf(chance), "dustGraniteBlack", Float.valueOf(0.5f));
        }
        if (ApiUtils.isExistingOreName("oreRedgranite" + ore)) {
            IERecipes.addCrusherRecipe(Utils.copyStackWithAmount(dust, 2), "oreRedgranite" + ore, 6000, secondary, Float.valueOf(chance), "dustGraniteRed", Float.valueOf(0.5f));
        }
    }

    public static CrusherRecipe addItemToOreDictCrusherRecipe(String oreName, int outSize, Object input, int energy) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return null;
        }
        ItemStack out = IEApi.getPreferredOreStack(oreName);
        if (out.isEmpty()) {
            return null;
        }
        return CrusherRecipe.addRecipe(Utils.copyStackWithAmount(out, outSize), input, energy);
    }

    public static void initAlloySmeltingRecipes() {
        IERecipes.addAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 6), "Copper", 1, "Nickel", 1, 200);
        IERecipes.addAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 7), "Gold", 1, "Silver", 1, 200);
        IERecipes.addOreDictAlloyingRecipe("ingotInvar", 3, "Iron", 2, "Nickel", 1, 200);
        IERecipes.addOreDictAlloyingRecipe("ingotBronze", 4, "Copper", 3, "Tin", 1, 200);
        IERecipes.addOreDictAlloyingRecipe("ingotBrass", 4, "Copper", 3, "Zinc", 1, 200);
        IERecipes.addOreDictAlloyingRecipe("ingotBlueAlloy", 1, "Silver", 1, "Nikolite", 4, 200);
        IERecipes.addOreDictAlloyingRecipe("ingotRedAlloy", 1, "Copper", 1, "Redstone", 4, 200);
    }

    public static void addOreDictAlloyingRecipe(String outName, int outSize, String input0, int size0, String input1, int size1, int time) {
        if (!ApiUtils.isExistingOreName(outName)) {
            return;
        }
        ItemStack out = IEApi.getPreferredOreStack(outName);
        if (out.isEmpty()) {
            return;
        }
        IERecipes.addAlloyingRecipe(Utils.copyStackWithAmount(out, outSize), input0, size0, input1, size1, time);
    }

    public static void addAlloyingRecipe(ItemStack output, String input0, int size0, String input1, int size1, int time) {
        boolean ingot0 = ApiUtils.isExistingOreName("ingot" + input0);
        boolean ingot1 = ApiUtils.isExistingOreName("ingot" + input1);
        boolean dust0 = ApiUtils.isExistingOreName("dust" + input0);
        boolean dust1 = ApiUtils.isExistingOreName("dust" + input1);
        if (ingot0 && ingot1) {
            AlloyRecipe.addRecipe(output, new IngredientStack("ingot" + input0, size0), new IngredientStack("ingot" + input1, size1), time);
        }
        if (dust0 && dust1) {
            AlloyRecipe.addRecipe(output, new IngredientStack("dust" + input0, size0), new IngredientStack("dust" + input1, size1), time);
        }
        if (ingot0 && dust1) {
            AlloyRecipe.addRecipe(output, new IngredientStack("ingot" + input0, size0), new IngredientStack("dust" + input1, size1), time);
        }
        if (dust0 && ingot1) {
            AlloyRecipe.addRecipe(output, new IngredientStack("dust" + input0, size0), new IngredientStack("ingot" + input1, size1), time);
        }
    }

    public static void initArcSmeltingRecipes() {
        ArcFurnaceRecipe.addRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 8), "ingotIron", new ItemStack((Item)IEContent.itemMaterial, 1, 7), 400, 512, "dustCoke");
        ArcFurnaceRecipe.addRecipe(new ItemStack((Item)IEContent.itemMetal, 1, 8), "dustIron", new ItemStack((Item)IEContent.itemMaterial, 1, 7), 400, 512, "dustCoke");
        arcOutputModifier.put("Iron", new ItemStack(Items.IRON_INGOT, 2));
        arcOutputModifier.put("Gold", new ItemStack(Items.GOLD_INGOT, 2));
        arcOutputModifier.put("Copper", new ItemStack((Item)IEContent.itemMetal, 2, 0));
        arcOutputModifier.put("Aluminum", new ItemStack((Item)IEContent.itemMetal, 2, 1));
        arcOutputModifier.put("Aluminium", new ItemStack((Item)IEContent.itemMetal, 2, 1));
        arcOutputModifier.put("Lead", new ItemStack((Item)IEContent.itemMetal, 2, 2));
        arcOutputModifier.put("Silver", new ItemStack((Item)IEContent.itemMetal, 2, 3));
        arcOutputModifier.put("Nickel", new ItemStack((Item)IEContent.itemMetal, 2, 4));
        IERecipes.addOreDictArcAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 6), "Copper", 100, 512, "dustNickel");
        IERecipes.addOreDictArcAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 6), "Nickel", 100, 512, "dustCopper");
        IERecipes.addOreDictArcAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 7), "Gold", 100, 512, "dustSilver");
        IERecipes.addOreDictArcAlloyingRecipe(new ItemStack((Item)IEContent.itemMetal, 2, 7), "Silver", 100, 512, "dustGold");
        IERecipes.addOreDictArcAlloyingRecipe("ingotInvar", 3, "Nickel", 200, 512, "dustIron", "dustIron");
        IERecipes.addOreDictArcAlloyingRecipe("ingotBronze", 4, "Tin", 200, 512, "dustCopper", "dustCopper", "dustCopper");
        IERecipes.addOreDictArcAlloyingRecipe("ingotBrass", 4, "Zinc", 200, 512, "dustCopper", "dustCopper", "dustCopper");
        IERecipes.addOreDictArcAlloyingRecipe("ingotBlueAlloy", 1, "Silver", 100, 512, "dustNikolite", "dustNikolite", "dustNikolite", "dustNikolite");
        IERecipes.addOreDictArcAlloyingRecipe("ingotRedAlloy", 1, "Copper", 100, 512, "dustRedstone", "dustRedstone", "dustRedstone", "dustRedstone");
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Item)IEContent.itemWireCoil, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Item)IEContent.itemDrillhead, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Block)IEContent.blockMetalDecoration1, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Block)IEContent.blockMetalDecoration2, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Block)IEContent.blockMetalDevice0, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling(new ItemStack((Block)IEContent.blockMetalDevice1, 1, Short.MAX_VALUE));
    }

    public static ArcFurnaceRecipe addArcRecipe(ItemStack output, Object input, int time, int energyPerTick, @Nonnull ItemStack slag, Object ... additives) {
        return ArcFurnaceRecipe.addRecipe(output, input, slag, time, energyPerTick, additives);
    }

    public static void addArcOreSmelting(ItemStack output, String ore) {
        if (ApiUtils.isExistingOreName("ore" + ore)) {
            IERecipes.addArcRecipe(output, "ore" + ore, 200, 512, new ItemStack((Item)IEContent.itemMaterial, 1, 7), new Object[0]).setSpecialRecipeType("Ores");
        }
        if (ApiUtils.isExistingOreName("oreNetherrack" + ore)) {
            IERecipes.addArcRecipe(output, "oreNetherrack" + ore, 200, 512, new ItemStack((Item)IEContent.itemMaterial, 1, 7), new Object[0]).setSpecialRecipeType("Ores");
        }
        if (ApiUtils.isExistingOreName("oreEndstone" + ore)) {
            IERecipes.addArcRecipe(output, "oreEndstone" + ore, 200, 512, new ItemStack((Item)IEContent.itemMaterial, 1, 7), new Object[0]).setSpecialRecipeType("Ores");
        }
        if (ApiUtils.isExistingOreName("oreBlackgranite" + ore)) {
            IERecipes.addArcRecipe(output, "oreBlackgranite" + ore, 200, 512, new ItemStack((Item)IEContent.itemMaterial, 1, 7), new Object[0]).setSpecialRecipeType("Ores");
        }
        if (ApiUtils.isExistingOreName("oreRedgranite" + ore)) {
            IERecipes.addArcRecipe(output, "oreRedgranite" + ore, 200, 512, new ItemStack((Item)IEContent.itemMaterial, 1, 7), new Object[0]).setSpecialRecipeType("Ores");
        }
    }

    public static void addOreDictArcAlloyingRecipe(String outName, int outSize, String inputName, int time, int energyPerTick, Object ... additives) {
        if (!ApiUtils.isExistingOreName(outName)) {
            return;
        }
        ItemStack out = IEApi.getPreferredOreStack(outName);
        if (out.isEmpty()) {
            return;
        }
        IERecipes.addOreDictArcAlloyingRecipe(Utils.copyStackWithAmount(out, outSize), inputName, time, energyPerTick, additives);
    }

    public static void addOreDictArcAlloyingRecipe(ItemStack out, String inputName, int time, int energyPerTick, Object ... additives) {
        if (ApiUtils.isExistingOreName("ingot" + inputName)) {
            ArcFurnaceRecipe.addRecipe(out, "ingot" + inputName, ItemStack.EMPTY, time, energyPerTick, additives).setSpecialRecipeType("Alloying");
        }
        if (ApiUtils.isExistingOreName("dust" + inputName)) {
            ArcFurnaceRecipe.addRecipe(out, "dust" + inputName, ItemStack.EMPTY, time, energyPerTick, additives).setSpecialRecipeType("Alloying");
        }
    }
}

