/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.NameRemapper;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.BlockIEMultiblock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingThreadHandler;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemIEShield;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static ArrayList<IEBlockInterfaces.ISpawnInterdiction> interdictionTiles = new ArrayList();
    public static boolean validateConnsNextTick = false;
    public static HashSet<IEExplosion> currentExplosions = new HashSet();
    public static final Queue<Pair<Integer, BlockPos>> requestedBlockUpdates = new LinkedList<Pair<Integer, BlockPos>>();
    public static final Set<TileEntity> REMOVE_FROM_TICKING = new HashSet<TileEntity>();
    public static List<ResourceLocation> lootInjections = Arrays.asList(new ResourceLocation("immersiveengineering", "chests/stronghold_library"), new ResourceLocation("immersiveengineering", "chests/village_blacksmith"));
    static Field f_lootEntries;
    public static HashMap<UUID, TileEntityCrusher> crusherMap;
    public static HashSet<Class<? extends EntityLiving>> listOfBoringBosses;

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        IESaveData.setDirty(0);
    }

    @SubscribeEvent
    public void onCapabilitiesAttach(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityMinecart) {
            EntityMinecart entityMinecart = (EntityMinecart)event.getObject();
            event.addCapability(new ResourceLocation("immersiveengineering:shader"), (ICapabilityProvider)new CapabilityShader.ShaderWrapper_Direct("immersiveengineering:minecart"));
        }
    }

    @SubscribeEvent
    public void onMinecartInteraction(MinecartInteractEvent event) {
        CapabilityShader.ShaderWrapper handler;
        if (!event.getPlayer().world.isRemote && !event.getItem().isEmpty() && event.getItem().getItem() instanceof IShaderItem && event.getMinecart().hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && (handler = (CapabilityShader.ShaderWrapper)event.getMinecart().getCapability(CapabilityShader.SHADER_CAPABILITY, null)) != null) {
            handler.setShaderItem(Utils.copyStackWithAmount(event.getItem(), 1));
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageMinecartShaderSync((Entity)event.getMinecart(), handler), (EntityPlayerMP)event.getPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (event.getName().getResourceDomain().equals("minecraft")) {
            for (ResourceLocation inject : lootInjections) {
                if (!event.getName().getResourcePath().equals(inject.getResourcePath())) continue;
                LootPool injectPool = Utils.loadBuiltinLootTable(inject, event.getLootTableManager()).getPool("immersiveengineering_loot_inject");
                LootPool mainPool = event.getTable().getPool("main");
                if (injectPool == null || mainPool == null) continue;
                try {
                    if (f_lootEntries == null) {
                        f_lootEntries = LootPool.class.getDeclaredField(ObfuscationReflectionHelper.remapFieldNames((String)LootPool.class.getName(), (String[])new String[]{"field_186453_a"})[0]);
                        f_lootEntries.setAccessible(true);
                    }
                    if (f_lootEntries == null) continue;
                    List entryList = (List)f_lootEntries.get(injectPool);
                    for (LootEntry entry : entryList) {
                        mainPool.addEntry(entry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().world.isRemote && event.getEntity() instanceof EntityMinecart && event.getEntity().hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageMinecartShaderSync(event.getEntity(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && validateConnsNextTick && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            boolean validateConnections = Config.IEConfig.validateConnections;
            int invalidConnectionsDropped = 0;
            for (int dim : ImmersiveNetHandler.INSTANCE.getRelevantDimensions()) {
                if (!validateConnections) continue;
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().getWorld(dim);
                if (world == null) {
                    ImmersiveNetHandler.INSTANCE.directConnections.remove(dim);
                    continue;
                }
                for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                    if (world.getTileEntity(con.start) instanceof IImmersiveConnectable && world.getTileEntity(con.end) instanceof IImmersiveConnectable) continue;
                    ImmersiveNetHandler.INSTANCE.removeConnection((World)world, con);
                    ++invalidConnectionsDropped;
                }
                IELogger.info("removed " + invalidConnectionsDropped + " invalid connections from world");
            }
            int invalidProxies = 0;
            Vec3d[] toRemove = new HashSet();
            for (Map.Entry<DimensionBlockPos, IICProxy> e : ImmersiveNetHandler.INSTANCE.proxies.entrySet()) {
                if (!validateConnections) continue;
                DimensionBlockPos p = e.getKey();
                WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().getWorld(p.dimension);
                if (w != null && w.isBlockLoaded((BlockPos)p)) {
                    toRemove.add(p);
                }
                if (validateConnections && w == null) {
                    ++invalidProxies;
                    toRemove.add(p);
                    continue;
                }
                if (!validateConnections || w.getTileEntity((BlockPos)p) instanceof IImmersiveConnectable) continue;
                ++invalidProxies;
                toRemove.add(p);
            }
            if (invalidProxies > 0) {
                IELogger.info("Removed " + invalidProxies + " invalid connector proxies (used to transfer power through unloaded chunks)");
            }
            validateConnsNextTick = false;
        }
        if (event.phase == TickEvent.Phase.END && ArcRecyclingThreadHandler.recipesToAdd != null) {
            for (ArcFurnaceRecipe recipe : ArcRecyclingThreadHandler.recipesToAdd) {
                ArcFurnaceRecipe.recipeList.add(recipe);
                IECompatModule.jeiAddFunc.accept(recipe);
            }
            ArcRecyclingThreadHandler.recipesToAdd = null;
        }
        if (event.phase == TickEvent.Phase.END && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            int dim = event.world.provider.getDimension();
            for (Map.Entry<ImmersiveNetHandler.Connection, Integer> e : ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).entrySet()) {
                if (e.getValue() <= e.getKey().cableType.getTransferRate()) continue;
                if (event.world instanceof WorldServer) {
                    for (Vec3d vec : e.getKey().getSubVertices(event.world)) {
                        ((WorldServer)event.world).spawnParticle(EnumParticleTypes.FLAME, false, vec.x, vec.y, vec.z, 0, 0.0, 0.02, 0.0, 1.0, new int[0]);
                    }
                }
                ImmersiveNetHandler.INSTANCE.removeConnection(event.world, e.getKey());
            }
            ImmersiveNetHandler.INSTANCE.getTransferedRates(dim).clear();
            if (!REMOVE_FROM_TICKING.isEmpty()) {
                event.world.tickableTileEntities.removeAll(REMOVE_FROM_TICKING);
                REMOVE_FROM_TICKING.removeIf(te -> te.getWorld().provider.getDimension() == dim);
            }
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!currentExplosions.isEmpty()) {
                Iterator<IEExplosion> itExplosion = currentExplosions.iterator();
                while (itExplosion.hasNext()) {
                    IEExplosion ex = itExplosion.next();
                    ex.doExplosionTick();
                    if (!ex.isExplosionFinished) continue;
                    itExplosion.remove();
                }
            }
            Queue<Pair<Integer, BlockPos>> queue = requestedBlockUpdates;
            synchronized (queue) {
                while (!requestedBlockUpdates.isEmpty()) {
                    WorldServer w;
                    Pair<Integer, BlockPos> curr = requestedBlockUpdates.poll();
                    if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER || (w = FMLCommonHandler.instance().getMinecraftServerInstance().getWorld(((Integer)curr.getLeft()).intValue())) == null) continue;
                    IBlockState state = w.getBlockState((BlockPos)curr.getRight());
                    w.notifyBlockUpdate((BlockPos)curr.getRight(), state, state, 3);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ExcavatorHandler.allowPackets = true;
        if (!event.player.world.isRemote) {
            HashMap<ExcavatorHandler.MineralMix, Integer> packetMap = new HashMap<ExcavatorHandler.MineralMix, Integer>();
            for (Map.Entry<ExcavatorHandler.MineralMix, Integer> e : ExcavatorHandler.mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ExcavatorHandler.allowPackets = false;
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.getTargetBlock().getBlock() instanceof BlockIEBase) {
            RayTraceResult mop;
            if (!event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND).isEmpty() && event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND).getItem().getToolClasses(event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND)).contains("IE_HAMMER") && (mop = Utils.getMovingObjectPositionFromPlayer(event.getEntityPlayer().world, (EntityLivingBase)event.getEntityPlayer(), true)) != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && ((BlockIEBase)event.getTargetBlock().getBlock()).allowHammerHarvest(event.getTargetBlock())) {
                event.setCanHarvest(true);
            }
            if (!event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND).isEmpty() && event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND).getItem().getToolClasses(event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND)).contains("IE_WIRECUTTER") && (mop = Utils.getMovingObjectPositionFromPlayer(event.getEntityPlayer().world, (EntityLivingBase)event.getEntityPlayer(), true)) != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && ((BlockIEBase)event.getTargetBlock().getBlock()).allowWirecutterHarvest(event.getTargetBlock())) {
                event.setCanHarvest(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        TileEntityCrusher crusher;
        if (!event.isCanceled() && Lib.DMG_Crusher.equals(event.getSource().getDamageType()) && (crusher = crusherMap.get(event.getEntityLiving().getUniqueID())) != null) {
            for (EntityItem item : event.getDrops()) {
                if (item == null || item.getItem().isEmpty()) continue;
                crusher.doProcessOutput(item.getItem());
            }
            crusherMap.remove(event.getEntityLiving().getUniqueID());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && !event.getEntityLiving().isNonBoss()) {
            EnumRarity r = EnumRarity.EPIC;
            for (Class<? extends EntityLiving> boring : listOfBoringBosses) {
                if (!boring.isAssignableFrom(event.getEntityLiving().getClass())) continue;
                return;
            }
            ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag);
            ItemNBTHelper.setString(bag, "rarity", r.toString());
            event.getDrops().add(new EntityItem(event.getEntityLiving().world, event.getEntityLiving().posX, event.getEntityLiving().posY, event.getEntityLiving().posZ, bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack activeStack;
        if (event.getEntityLiving() instanceof EntityPlayer && !(activeStack = (player = (EntityPlayer)event.getEntityLiving()).getActiveItemStack()).isEmpty() && activeStack.getItem() instanceof ItemIEShield && event.getAmount() >= 3.0f && Utils.canBlockDamageSource((EntityLivingBase)player, event.getSource())) {
            float amount = event.getAmount();
            ((ItemIEShield)activeStack.getItem()).hitShield(activeStack, player, event.getSource(), amount, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        float mod;
        int amp;
        if (event.getSource().isFireDamage() && event.getEntityLiving().getActivePotionEffect(IEPotions.flammable) != null) {
            amp = event.getEntityLiving().getActivePotionEffect(IEPotions.flammable).getAmplifier();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
        if (("flux".equals(event.getSource().getDamageType()) || IEDamageSources.razorShock.equals(event.getSource()) || event.getSource() instanceof IEDamageSources.TeslaDamageSource) && event.getEntityLiving().getActivePotionEffect(IEPotions.conductive) != null) {
            amp = event.getEntityLiving().getActivePotionEffect(IEPotions.conductive).getAmplifier();
            mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setAmount(event.getAmount() * mod);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().getActivePotionEffect(IEPotions.sticky) != null) {
            event.getEntityLiving().motionY -= (double)((float)(event.getEntityLiving().getActivePotionEffect(IEPotions.sticky).getAmplifier() + 1) * 0.3f);
        } else if (event.getEntityLiving().getActivePotionEffect(IEPotions.concreteFeet) != null) {
            event.getEntityLiving().motionX = 0.0;
            event.getEntityLiving().motionY = 0.0;
            event.getEntityLiving().motionZ = 0.0;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack powerpack;
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().getItemStackFromSlot(EntityEquipmentSlot.CHEST).isEmpty() && ItemNBTHelper.hasKey(event.getEntityLiving().getItemStackFromSlot(EntityEquipmentSlot.CHEST), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getEntityLiving().getItemStackFromSlot(EntityEquipmentSlot.CHEST), "IE:Powerpack")).isEmpty()) {
            powerpack.getItem().onArmorTick(event.getEntityLiving().getEntityWorld(), (EntityPlayer)event.getEntityLiving(), powerpack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).isInvalid() || ((TileEntity)interdictor).getWorld() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).getWorld().provider.getDimension() != event.getEntity().world.provider.getDimension() || !(((TileEntity)interdictor).getDistanceSq(event.getEntity().posX, event.getEntity().posY, event.getEntity().posZ) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).isDead || ((Entity)interdictor).world == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).world.provider.getDimension() != event.getEntity().world.provider.getDimension() || !(((Entity)interdictor).getDistanceSqToEntity(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setCanceled(true);
                }
            }
        }
        if (event.getEntityLiving().getActivePotionEffect(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = interdictionTiles;
            synchronized (arrayList) {
                Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.iterator();
                while (it.hasNext()) {
                    IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                    if (interdictor instanceof TileEntity) {
                        if (((TileEntity)interdictor).isInvalid() || ((TileEntity)interdictor).getWorld() == null) {
                            it.remove();
                            continue;
                        }
                        if (((TileEntity)interdictor).getWorld().provider.getDimension() != event.getEntity().world.provider.getDimension() || !(((TileEntity)interdictor).getDistanceSq(event.getEntity().posX, event.getEntity().posY, event.getEntity().posZ) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        continue;
                    }
                    if (!(interdictor instanceof Entity)) continue;
                    if (((Entity)interdictor).isDead || ((Entity)interdictor).world == null) {
                        it.remove();
                        continue;
                    }
                    if (((Entity)interdictor).world.provider.getDimension() != event.getEntity().world.provider.getDimension() || !(((Entity)interdictor).getDistanceSqToEntity(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        TileEntity te;
        ItemStack current = event.getEntityPlayer().getHeldItem(EnumHand.MAIN_HAND);
        if (!current.isEmpty() && current.getItem().equals(IEContent.itemDrill) && current.getItemDamage() == 0 && event.getEntityPlayer().isInsideOfMaterial(Material.WATER)) {
            if (((ItemDrill)IEContent.itemDrill).getUpgrades(current).getBoolean("waterproof")) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().getBlock() == IEContent.blockMetalDecoration2 && IEContent.blockMetalDecoration2.getMetaFromState(event.getState()) == BlockTypes_MetalDecoration2.RAZOR_WIRE.getMeta() && !OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 1), (ItemStack)current, (boolean)false)) {
            event.setCanceled(true);
        }
        if ((te = event.getEntityPlayer().getEntityWorld().getTileEntity(event.getPos())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().isEmpty() && event.getLeft().getItem() instanceof IDrillHead && ((IDrillHead)event.getLeft().getItem()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().isEmpty() && event.getLeft().getItem().getIsRepairable(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().copy());
            int repair = Math.min(((IDrillHead)event.getOutput().getItem()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().getItem()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().getCount(); ++cost) {
                ((IDrillHead)event.getOutput().getItem()).damageHead(event.getOutput(), -repair);
                event.setCost(Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().getItem()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().getItem()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().hasDisplayName()) {
                    event.setCost(event.getCost() + 5);
                    event.getOutput().clearCustomName();
                }
            } else if (!event.getName().equals(event.getLeft().getDisplayName())) {
                event.setCost(event.getCost() + 5);
                if (event.getLeft().hasDisplayName()) {
                    event.setCost(event.getCost() + 2);
                }
                event.getOutput().setStackDisplayName(event.getName());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void breakLast(BlockEvent.BreakEvent event) {
        TileEntity te;
        if (event.getState().getBlock() instanceof BlockIEMultiblock && (te = event.getWorld().getTileEntity(event.getPos())) instanceof TileEntityMultiblockPart) {
            ((TileEntityMultiblockPart)te).onlyLocalDissassembly = event.getWorld().getTotalWorldTime();
        }
    }

    @SubscribeEvent
    public void remap(RegistryEvent.MissingMappings<?> ev) {
        NameRemapper.remap(ev);
    }

    static {
        crusherMap = new HashMap();
        listOfBoringBosses = new HashSet();
        listOfBoringBosses.add(EntityWither.class);
    }
}

