/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderWindmill
extends TileEntitySpecialRenderer<TileEntityWindmill> {
    private List<BakedQuad>[] quads = new List[9];
    private static WeakHashMap<TileRenderWindmill, Boolean> instances = new WeakHashMap();

    public TileRenderWindmill() {
        instances.put(this, true);
    }

    public void render(TileEntityWindmill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = tile.getPos();
        if (this.quads[tile.sails] == null) {
            IBlockState state = this.getWorld().getBlockState(blockPos);
            state = state.getActualState((IBlockAccess)this.getWorld(), blockPos);
            state = state.withProperty((IProperty)IEProperties.FACING_ALL, (Comparable)EnumFacing.NORTH);
            IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
            if (state instanceof IExtendedBlockState) {
                ArrayList<String> parts = new ArrayList<String>();
                parts.add("base");
                for (int i = 1; i <= tile.sails; ++i) {
                    parts.add("sail_" + i);
                }
                state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(parts, true));
            }
            this.quads[tile.sails] = model.getQuads(state, null, 0L);
        }
        Tessellator tessellator = Tessellator.getInstance();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        float dir = tile.facing == EnumFacing.SOUTH ? 0.0f : (tile.facing == EnumFacing.NORTH ? 180.0f : (tile.facing == EnumFacing.EAST ? 90.0f : -90.0f));
        float rot = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * tile.perTick);
        GlStateManager.rotate((float)rot, (float)(tile.facing.getAxis() == EnumFacing.Axis.X ? 1.0f : 0.0f), (float)0.0f, (float)(tile.facing.getAxis() == EnumFacing.Axis.Z ? 1.0f : 0.0f));
        GlStateManager.rotate((float)dir, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.disableStandardItemLighting();
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BufferBuilder worldRenderer = tessellator.getBuffer();
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5, -0.5, -0.5);
        ClientUtils.renderModelTESRFast(this.quads[tile.sails], worldRenderer, tile.getWorld(), blockPos);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }

    public static void reset() {
        for (TileRenderWindmill r : instances.keySet()) {
            for (int i = 0; i < r.quads.length; ++i) {
                r.quads[i] = null;
            }
        }
    }
}

