/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class TileRenderWatermill
extends TileEntitySpecialRenderer<TileEntityWatermill> {
    private static List<BakedQuad> quads;

    public void render(TileEntityWatermill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.isDummy() || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        if (quads == null) {
            BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
            IBlockState state = tile.getWorld().getBlockState(tile.getPos());
            quads = blockRenderer.getModelForState(state).getQuads(state, null, 0L);
        }
        Tessellator tessellator = Tessellator.getInstance();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        float dir = tile.facing == EnumFacing.NORTH ? 180.0f : (tile.facing == EnumFacing.SOUTH ? 0.0f : (tile.facing == EnumFacing.WEST ? 90.0f : -90.0f));
        float wheelRotation = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * (float)tile.perTick);
        if (tile.facing.getAxisDirection() == EnumFacing.AxisDirection.NEGATIVE) {
            wheelRotation *= -1.0f;
        }
        float rot = wheelRotation;
        GlStateManager.rotate((float)dir, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.disableStandardItemLighting();
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BufferBuilder worldRenderer = tessellator.getBuffer();
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5, -0.5, -0.5);
        ClientUtils.renderModelTESRFast(quads, worldRenderer, tile.getWorld(), tile.getPos());
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }

    public static void reset() {
        quads = null;
    }
}

