/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretGun;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderTurret
extends TileEntitySpecialRenderer<TileEntityTurret> {
    public void render(TileEntityTurret tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.isDummy() || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = tile.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalDevice1) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.rotate((float)tile.rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)tile.rotationPitch, (float)tile.facing.getFrontOffsetZ(), (float)0.0f, (float)(-tile.facing.getFrontOffsetX()));
        TileRenderTurret.renderModelPart(blockRenderer, tessellator, worldRenderer, tile.getWorld(), state, model, tile.getPos(), true, "gun");
        if (tile instanceof TileEntityTurretGun) {
            if (((TileEntityTurretGun)tile).cycleRender > 0) {
                float cycle = 0.0f;
                cycle = ((TileEntityTurretGun)tile).cycleRender > 3 ? (float)(((TileEntityTurretGun)tile).cycleRender - 5) / 2.0f : (float)((TileEntityTurretGun)tile).cycleRender / 3.0f;
                GlStateManager.translate((double)0.0, (double)0.0, (double)((double)cycle * 0.3125));
            }
            TileRenderTurret.renderModelPart(blockRenderer, tessellator, worldRenderer, tile.getWorld(), state, model, tile.getPos(), false, "action");
        }
        GlStateManager.popMatrix();
    }

    public static void renderModelPart(BlockRendererDispatcher blockRenderer, Tessellator tessellator, BufferBuilder worldRenderer, World world, IBlockState state, IBakedModel model, BlockPos pos, boolean isFirst, String ... parts) {
        pos = pos.up();
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(Arrays.asList(parts), true));
        }
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5, 0.0, -0.5);
        long randomLong = MathHelper.getPositionRandom((Vec3i)pos);
        int light = world.getCombinedLight(pos, 0);
        List quads = model.getQuads(state, null, randomLong);
        ClientUtils.renderModelTESRFancy(quads, worldRenderer, world, pos, !isFirst);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }
}

