/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTeslaCoil;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class TileRenderTeslaCoil
extends TileEntitySpecialRenderer<TileEntityTeslaCoil> {
    public void render(TileEntityTeslaCoil tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.isDummy() || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        Iterator animationIt = TileEntityTeslaCoil.effectMap.get((Object)tile.getPos()).iterator();
        this.setLightmapDisabled(true);
        GL11.glPushAttrib((int)2896);
        GlStateManager.disableLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        while (animationIt.hasNext()) {
            TileEntityTeslaCoil.LightningAnimation animation = (TileEntityTeslaCoil.LightningAnimation)animationIt.next();
            if (animation.shoudlRecalculateLightning()) {
                animation.createLightning(Utils.RAND);
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)x, (double)y, (double)z);
            GlStateManager.disableTexture2D();
            GlStateManager.enableBlend();
            double tx = tile.getPos().getX();
            double ty = tile.getPos().getY();
            double tz = tile.getPos().getZ();
            float curWidth = GL11.glGetFloat((int)2849);
            TileRenderTeslaCoil.drawAnimation(animation, tx, ty, tz, new float[]{0.3019608f, 0.2901961f, 0.59607846f, 0.75f}, 4.0f);
            TileRenderTeslaCoil.drawAnimation(animation, tx, ty, tz, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f);
            GL11.glLineWidth((float)curWidth);
            GlStateManager.enableTexture2D();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
        GL11.glPopAttrib();
        this.setLightmapDisabled(false);
    }

    public static void drawAnimation(TileEntityTeslaCoil.LightningAnimation animation, double tileX, double tileY, double tileZ, float[] rgba, float lineWidth) {
        GlStateManager.color((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
        GL11.glLineWidth((float)lineWidth);
        Tessellator tes = ClientUtils.tes();
        BufferBuilder worldrenderer = tes.getBuffer();
        worldrenderer.begin(3, DefaultVertexFormats.POSITION);
        List<Vec3d> subs = animation.subPoints;
        worldrenderer.pos(animation.startPos.x - tileX, animation.startPos.y - tileY, animation.startPos.z - tileZ).endVertex();
        for (int i = 0; i < subs.size(); ++i) {
            worldrenderer.pos(subs.get((int)i).x - tileX, subs.get((int)i).y - tileY, subs.get((int)i).z - tileZ).endVertex();
        }
        Vec3d end = (animation.targetEntity != null ? animation.targetEntity.getPositionVector() : animation.targetPos).addVector(-tileX, -tileY, -tileZ);
        worldrenderer.pos(end.x, end.y, end.z).endVertex();
        tes.draw();
    }
}

