/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySilo;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;

public class TileRenderSilo
extends TileEntitySpecialRenderer<TileEntitySilo> {
    public void render(TileEntitySilo tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!tile.formed || tile.pos != 4 || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)y, (double)(z + 0.5));
        if (!tile.identStack.isEmpty()) {
            GlStateManager.translate((float)0.0f, (float)5.0f, (float)0.0f);
            float baseScale = 0.0625f;
            float itemScale = 0.75f;
            float flatScale = 0.001f;
            float textScale = 0.375f;
            GlStateManager.scale((float)(baseScale *= itemScale), (float)(-baseScale), (float)baseScale);
            ItemStack stack = Utils.copyStackWithAmount(tile.identStack, tile.storageAmount);
            String s = "" + stack.getCount();
            float w = this.getFontRenderer().getStringWidth(s);
            float xx = -0.5f * itemScale;
            float zz = 1.501f;
            xx /= baseScale;
            zz /= baseScale;
            w *= textScale;
            for (int i = 0; i < 4; ++i) {
                GlStateManager.pushMatrix();
                GlStateManager.translate((float)xx, (float)0.0f, (float)zz);
                GlStateManager.scale((float)1.0f, (float)1.0f, (float)flatScale);
                ClientUtils.mc().getRenderItem().renderItemAndEffectIntoGUI(stack, 0, 0);
                GlStateManager.scale((float)1.0f, (float)1.0f, (float)(1.0f / flatScale));
                GlStateManager.disableLighting();
                GlStateManager.depthMask((boolean)false);
                GlStateManager.translate((float)(8.0f - w / 2.0f), (float)17.0f, (float)0.001f);
                GlStateManager.scale((float)textScale, (float)textScale, (float)1.0f);
                ClientUtils.font().drawString("" + stack.getCount(), 0.0f, 0.0f, 0x888888, true);
                GlStateManager.scale((float)(1.0f / textScale), (float)(1.0f / textScale), (float)1.0f);
                GlStateManager.translate((float)(-(8.0f - w / 2.0f)), (float)-17.0f, (float)-0.001f);
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableLighting();
                GlStateManager.translate((float)(-xx), (float)0.0f, (float)(-zz));
                GlStateManager.popMatrix();
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.enableAlpha();
                GlStateManager.alphaFunc((int)516, (float)0.1f);
                GlStateManager.enableBlend();
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            }
        }
        GlStateManager.popMatrix();
    }
}

