/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySampleDrill;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.lwjgl.opengl.GL11;

public class TileRenderSampleDrill
extends TileEntitySpecialRenderer<TileEntitySampleDrill> {
    public void render(TileEntitySampleDrill tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.isDummy() || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBlockState state = tile.getWorld().getBlockState(tile.getPos());
        BlockPos blockPos = tile.getPos();
        IBakedModel model = blockRenderer.getModelForState(state);
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"drill"}), true));
        }
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        int max = Config.IEConfig.Machines.coredrill_time;
        if (tile.process > 0 && tile.process < max) {
            GL11.glRotatef((float)(((float)tile.process + partialTicks) * 22.5f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            float push = (float)tile.process / (float)max;
            if (tile.process > max / 2) {
                push = 1.0f - push;
            }
            GL11.glTranslated((double)0.0, (double)(-2.8f * push), (double)0.0);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)tile.getWorld(), model, state, tile.getPos(), worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
    }
}

