/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMixer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class TileRenderMixer
extends TileEntitySpecialRenderer<TileEntityMixer> {
    public void render(TileEntityMixer te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (te.mirrored) {
            GlStateManager.scale((float)(te.facing.getFrontOffsetX() == 0 ? -1.0f : 1.0f), (float)1.0f, (float)(te.facing.getFrontOffsetZ() == 0 ? -1.0f : 1.0f));
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(te.facing == EnumFacing.SOUTH || te.facing == EnumFacing.WEST ? -0.5 : 0.5), (double)0.0, (double)(te.facing == EnumFacing.SOUTH || te.facing == EnumFacing.EAST ? 0.5 : -0.5));
        float agitator = te.animation_agitator - (!te.shouldRenderAsActive() ? 0.0f : (1.0f - partialTicks) * 9.0f);
        GlStateManager.rotate((float)agitator, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
        switch (te.facing) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.scale((float)0.0625f, (float)1.0f, (float)0.0625f);
        GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translate((float)8.0f, (float)-8.0f, (float)0.625f);
        RenderHelper.disableStandardItemLighting();
        for (int i = te.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = te.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            int col = fs.getFluid().getColor(fs);
            GlStateManager.color((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
            float yy = (float)fs.amount / (float)te.tank.getCapacity() * 1.125f;
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)(-yy));
            float w = i < te.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 26.0f : 16.0f + yy / 0.0125f;
            ClientUtils.drawRepeatedFluidSprite(fs, -w / 2.0f, -w / 2.0f, w, w);
        }
        GlStateManager.popMatrix();
    }
}

