/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileRenderMetalPress
extends TileEntitySpecialRenderer<TileEntityMetalPress> {
    public void render(TileEntityMetalPress te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityMultiblockMetal.MultiblockProcess process;
        int i;
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        float piston = 0.0f;
        float[] shift = new float[te.processQueue.size()];
        for (i = 0; i < shift.length; ++i) {
            process = (TileEntityMultiblockMetal.MultiblockProcess)te.processQueue.get(i);
            if (process == null) continue;
            float transportTime = 52.5f / (float)process.maxTicks;
            float pressTime = 3.75f / (float)process.maxTicks;
            float fProcess = ((float)process.processTick + (te.shouldRenderAsActive() ? partialTicks : 0.0f)) / (float)process.maxTicks;
            shift[i] = fProcess < transportTime ? fProcess / transportTime * 0.5f : (fProcess < 1.0f - transportTime ? 0.5f : 0.5f + (fProcess - (1.0f - transportTime)) / transportTime * 0.5f);
            if (te.mold.isEmpty() || !(fProcess >= transportTime) || !(fProcess < 1.0f - transportTime)) continue;
            piston = fProcess < transportTime + pressTime ? (fProcess - transportTime) / pressTime : (fProcess < 1.0f - transportTime - pressTime ? 1.0f : 1.0f - (fProcess - (1.0f - transportTime - pressTime)) / pressTime);
        }
        GlStateManager.translate((float)0.0f, (float)(-piston * 0.6875f), (float)0.0f);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.rotate((float)(te.facing == EnumFacing.SOUTH ? 180.0f : (te.facing == EnumFacing.WEST ? 90.0f : (te.facing == EnumFacing.EAST ? -90.0f : 0.0f))), (float)0.0f, (float)1.0f, (float)0.0f);
        if (!te.mold.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)0.0, (double)0.34, (double)0.0);
            GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float scale = 0.75f;
            GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
            ClientUtils.mc().getRenderItem().renderItem(te.mold, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
            GlStateManager.popMatrix();
        }
        GlStateManager.translate((float)0.0f, (float)(piston * 0.6875f), (float)0.0f);
        GlStateManager.translate((double)0.0, (double)-0.35, (double)1.25);
        for (i = 0; i < shift.length; ++i) {
            List<ItemStack> displays;
            process = (TileEntityMultiblockMetal.MultiblockProcess)te.processQueue.get(i);
            if (process == null || !(process instanceof TileEntityMultiblockMetal.MultiblockProcessInWorld)) continue;
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)0.0, (double)0.0, (double)(-2.5 * (double)shift[i]));
            if ((double)piston > 0.92) {
                GlStateManager.translate((double)0.0, (double)(0.92 - (double)piston), (double)0.0);
            }
            if ((displays = ((TileEntityMultiblockMetal.MultiblockProcessInWorld)process).getDisplayItem()).isEmpty()) continue;
            GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float scale = 0.625f;
            GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
            ClientUtils.mc().getRenderItem().renderItem(displays.get(0), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }
}

