/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDieselGenerator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileRenderDieselGenerator
extends TileEntitySpecialRenderer<TileEntityDieselGenerator> {
    public void render(TileEntityDieselGenerator te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.translate((double)0.5, (double)0.6875, (double)0.5);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.rotate((float)(te.animation_fanRotation + te.animation_fanRotationStep * partialTicks), (float)te.facing.getFrontOffsetX(), (float)0.0f, (float)te.facing.getFrontOffsetZ());
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), (double)(-blockPos.getY()), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }
}

