/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileRenderCrusher
extends TileEntitySpecialRenderer<TileEntityCrusher> {
    public void render(TileEntityCrusher te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        boolean b = te.shouldRenderAsActive();
        float angle = te.animation_barrelRotation + (b ? 18.0f * partialTicks : 0.0f);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.translate((double)0.5, (double)1.5, (double)0.5);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.translate((double)((double)te.facing.getFrontOffsetX() * 0.5), (double)0.0, (double)((double)te.facing.getFrontOffsetZ() * 0.5));
        GlStateManager.rotate((float)angle, (float)(-te.facing.getFrontOffsetZ()), (float)0.0f, (float)te.facing.getFrontOffsetX());
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.rotate((float)(-angle), (float)(-te.facing.getFrontOffsetZ()), (float)0.0f, (float)te.facing.getFrontOffsetX());
        GlStateManager.translate((float)(te.facing.getFrontOffsetX() * -1), (float)0.0f, (float)(te.facing.getFrontOffsetZ() * -1));
        GlStateManager.rotate((float)(-angle), (float)(-te.facing.getFrontOffsetZ()), (float)0.0f, (float)te.facing.getFrontOffsetX());
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.rotate((float)angle, (float)(-te.facing.getFrontOffsetZ()), (float)0.0f, (float)te.facing.getFrontOffsetX());
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }
}

