/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;

public class TileRenderBucketWheel
extends TileEntitySpecialRenderer<TileEntityBucketWheel> {
    private static IBakedModel model = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TileEntityBucketWheel tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!tile.formed || !tile.getWorld().isBlockLoaded(tile.getPos(), false) || tile.isDummy()) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBlockState state = tile.getWorld().getBlockState(tile.getPos());
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        if (model == null) {
            state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
            model = blockRenderer.getModelForState(state);
        }
        OBJModel.OBJState objState = null;
        HashMap<String, String> texMap = new HashMap<String, String>();
        if (state instanceof IExtendedBlockState) {
            ArrayList list = Lists.newArrayList((Object[])new String[]{"bucketWheel"});
            NonNullList<ItemStack> nonNullList = tile.digStacks;
            synchronized (nonNullList) {
                for (int i = 0; i < tile.digStacks.size(); ++i) {
                    if (((ItemStack)tile.digStacks.get(i)).isEmpty()) continue;
                    list.add("dig" + i);
                    Block b = Block.getBlockFromItem((Item)((ItemStack)tile.digStacks.get(i)).getItem());
                    IBlockState digState = b != null ? b.getStateFromMeta(((ItemStack)tile.digStacks.get(i)).getMetadata()) : Blocks.STONE.getDefaultState();
                    IBakedModel digModel = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(digState);
                    if (digModel == null || digModel.getParticleTexture() == null) continue;
                    texMap.put("dig" + i, digModel.getParticleTexture().getIconName());
                }
            }
            objState = new OBJModel.OBJState((List)list, true);
        }
        Tessellator tessellator = Tessellator.getInstance();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        EnumFacing facing = tile.facing;
        if (tile.mirrored) {
            GlStateManager.scale((float)(facing.getAxis() == EnumFacing.Axis.X ? -1.0f : 1.0f), (float)1.0f, (float)(facing.getAxis() == EnumFacing.Axis.Z ? -1.0f : 1.0f));
            GlStateManager.disableCull();
        }
        float dir = tile.facing == EnumFacing.SOUTH ? 90.0f : (tile.facing == EnumFacing.NORTH ? -90.0f : (tile.facing == EnumFacing.EAST ? 180.0f : 0.0f));
        GlStateManager.rotate((float)dir, (float)0.0f, (float)1.0f, (float)0.0f);
        float rot = tile.rotation + (float)(tile.active ? Config.IEConfig.Machines.excavator_speed * (double)partialTicks : 0.0);
        GlStateManager.rotate((float)rot, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.disableStandardItemLighting();
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BufferBuilder worldRenderer = tessellator.getBuffer();
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = model instanceof IESmartObjModel ? ((IESmartObjModel)model).getQuads(state, null, 0L, objState, texMap, true) : model.getQuads(state, null, 0L);
        ClientUtils.renderModelTESRFast(quads, worldRenderer, tile.getWorld(), tile.getPos());
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        if (tile.mirrored) {
            GlStateManager.enableCull();
        }
    }
}

