/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import java.util.Arrays;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileRenderBottlingMachine
extends TileEntitySpecialRenderer<TileEntityBottlingMachine> {
    public void render(TileEntityBottlingMachine te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (te.mirrored) {
            GlStateManager.scale((float)(te.facing.getFrontOffsetX() == 0 ? -1.0f : 1.0f), (float)1.0f, (float)(te.facing.getFrontOffsetZ() == 0 ? -1.0f : 1.0f));
        }
        float[][] itemDisplays = new float[te.bottlingProcessQueue.size()][];
        float lift = 0.0f;
        for (int i = 0; i < itemDisplays.length; ++i) {
            TileEntityBottlingMachine.BottlingProcess process = te.bottlingProcessQueue.get(i);
            if (process == null || process.processTick == process.maxProcessTick) continue;
            float processTimer = (float)process.processTick / (float)process.maxProcessTick * 120.0f;
            float itemX = -1.5f;
            float itemY = -0.15625f;
            float itemZ = 1.0f;
            float itemFill = 0.0f;
            if (processTimer <= 35.0f) {
                itemX = (float)((double)itemX + (double)(processTimer / 35.0f) * 1.5);
            } else if (processTimer <= 85.0f) {
                itemX = 0.0f;
                if (processTimer <= 55.0f) {
                    lift = (processTimer - 35.0f) / 20.0f * 0.125f;
                } else if (processTimer <= 65.0f) {
                    lift = 0.125f;
                    itemFill = (processTimer - 55.0f) / 10.0f;
                } else {
                    lift = (85.0f - processTimer) / 20.0f * 0.125f;
                    itemFill = 1.0f;
                }
                itemY += lift;
                lift = (float)((double)lift + 0.0625);
            } else {
                itemX = (processTimer - 85.0f) / 35.0f * 1.5f;
                itemFill = 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemFill};
        }
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.0f, (float)lift, (float)0.0f);
        TileRenderBottlingMachine.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "lift");
        GlStateManager.translate((float)0.0f, (float)(-lift), (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
        switch (te.facing) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        float scale = 0.0625f;
        FluidStack fs = te.tanks[0].getFluid();
        if (fs != null) {
            GlStateManager.pushMatrix();
            float level = (float)fs.amount / (float)te.tanks[0].getCapacity();
            GlStateManager.translate((double)-0.21875, (double)0.376, (double)1.21875);
            GlStateManager.scale((float)scale, (float)scale, (float)scale);
            float h = level * 9.0f;
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, h);
            GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, h);
            GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translate((float)-7.0f, (float)0.0f, (float)7.0f);
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, h);
            GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, h);
            GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, 7.0f);
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)(-h));
            ClientUtils.drawRepeatedFluidSprite(fs, 0.0f, 0.0f, 7.0f, 7.0f);
            GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            GlStateManager.translate((float)0.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.popMatrix();
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            TileEntityBottlingMachine.BottlingProcess process;
            if (itemDisplays[i] == null || (process = te.bottlingProcessQueue.get(i)) == null) continue;
            ItemStack display = itemDisplays[i][4] == 0.0f || ((ItemStack)process.items.get(1)).isEmpty() ? (ItemStack)process.items.get(0) : (ItemStack)process.items.get(1);
            scale = 0.4375f;
            GlStateManager.translate((float)itemDisplays[i][1], (float)itemDisplays[i][2], (float)itemDisplays[i][3]);
            GlStateManager.scale((float)scale, (float)scale, (float)scale);
            if (itemDisplays[i][4] == 0.0f) {
                ClientUtils.mc().getRenderItem().renderItem((ItemStack)process.items.get(0), ItemCameraTransforms.TransformType.FIXED);
            } else if (itemDisplays[i][4] == 1.0f) {
                ClientUtils.mc().getRenderItem().renderItem(display, ItemCameraTransforms.TransformType.FIXED);
            } else {
                float h0 = -0.5f;
                float h1 = h0 + itemDisplays[i][4];
                BufferBuilder worldrenderer = tessellator.getBuffer();
                GL11.glEnable((int)2960);
                GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.depthMask((boolean)false);
                GL11.glStencilFunc((int)512, (int)1, (int)255);
                GL11.glStencilOp((int)7681, (int)7680, (int)7680);
                GL11.glStencilMask((int)255);
                GlStateManager.clear((int)1024);
                GlStateManager.rotate((float)(90.0f - ClientUtils.mc().getRenderManager().playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.disableTexture2D();
                worldrenderer.begin(7, DefaultVertexFormats.POSITION);
                ClientUtils.renderBox(worldrenderer, -0.5, h0, -0.5, 0.5, h1, 0.5);
                tessellator.draw();
                GlStateManager.enableTexture2D();
                GlStateManager.rotate((float)(-(90.0f - ClientUtils.mc().getRenderManager().playerViewY)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.depthMask((boolean)true);
                GL11.glStencilMask((int)0);
                GL11.glStencilFunc((int)514, (int)0, (int)255);
                ClientUtils.mc().getRenderItem().renderItem((ItemStack)process.items.get(0), ItemCameraTransforms.TransformType.FIXED);
                GL11.glStencilFunc((int)514, (int)1, (int)255);
                ClientUtils.mc().getRenderItem().renderItem(display, ItemCameraTransforms.TransformType.FIXED);
                GL11.glDisable((int)2960);
            }
            GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            GlStateManager.translate((float)(-itemDisplays[i][1]), (float)(-itemDisplays[i][2]), (float)(-itemDisplays[i][3]));
        }
        GlStateManager.popMatrix();
    }

    public static void renderModelPart(BlockRendererDispatcher blockRenderer, Tessellator tessellator, BufferBuilder worldRenderer, World world, IBlockState state, IBakedModel model, BlockPos pos, String ... parts) {
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(Arrays.asList(parts), true));
        }
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)pos.getX(), -0.5 - (double)pos.getY(), -0.5 - (double)pos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)world, model, state, pos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
    }
}

