/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBelljar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderBelljar
extends TileEntitySpecialRenderer<TileEntityBelljar> {
    private static HashMap<EnumFacing, List<BakedQuad>> quads = new HashMap();
    private static HashMap<IBlockState, List<BakedQuad>> plantQuads = new HashMap();

    public void render(TileEntityBelljar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.dummy != 0 || !tile.getWorld().isBlockLoaded(tile.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = tile.getPos();
        if (!quads.containsKey(tile.getFacing())) {
            IBlockState state = this.getWorld().getBlockState(blockPos);
            if (state.getBlock() != IEContent.blockMetalDevice1) {
                return;
            }
            state = state.getActualState((IBlockAccess)this.getWorld(), blockPos);
            IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
            if (state instanceof IExtendedBlockState) {
                state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(Arrays.asList("glass"), true));
            }
            quads.put(tile.getFacing(), model.getQuads(state, null, 0L));
        }
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        BufferBuilder worldRenderer = Tessellator.getInstance().getBuffer();
        GlStateManager.enableCull();
        BelljarHandler.IPlantHandler plantHandler = tile.getCurrentPlantHandler();
        if (plantHandler != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)0.0, (double)1.0625, (double)0.0);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            NonNullList<ItemStack> inventory = tile.getInventory();
            float scale = plantHandler.getRenderSize((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile);
            GlStateManager.translate((float)((1.0f - scale) / 2.0f), (float)0.0f, (float)((1.0f - scale) / 2.0f));
            GlStateManager.scale((float)scale, (float)scale, (float)scale);
            if (!plantHandler.overrideRender((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile, blockRenderer)) {
                IBlockState[] states = plantHandler.getRenderedPlant((ItemStack)inventory.get(1), (ItemStack)inventory.get(0), tile.renderGrowth, tile);
                if (states == null || states.length < 1) {
                    return;
                }
                for (IBlockState s : states) {
                    List<BakedQuad> plantQuadList = plantQuads.get(s);
                    if (plantQuadList == null) {
                        IBakedModel plantModel = blockRenderer.getModelForState(s);
                        plantQuadList = new ArrayList<BakedQuad>(plantModel.getQuads(s, null, 0L));
                        for (EnumFacing f : EnumFacing.values()) {
                            plantQuadList.addAll(plantModel.getQuads(s, f, 0L));
                        }
                        plantQuads.put(s, plantQuadList);
                    }
                    if (plantQuadList == null) continue;
                    GlStateManager.pushMatrix();
                    worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
                    ClientUtils.renderModelTESRFancy(plantQuadList, worldRenderer, tile.getWorld(), blockPos, false);
                    Tessellator.getInstance().draw();
                    GlStateManager.popMatrix();
                    GlStateManager.translate((float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GlStateManager.popMatrix();
        }
        GlStateManager.depthMask((boolean)false);
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        ClientUtils.renderModelTESRFast(quads.get(tile.getFacing()), worldRenderer, tile.getWorld(), blockPos);
        Tessellator.getInstance().draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
    }

    public static void reset() {
        quads.clear();
        plantQuads.clear();
    }
}

