/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAutoWorkbench;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class TileRenderAutoWorkbench
extends TileEntitySpecialRenderer<TileEntityAutoWorkbench> {
    public static HashMap<BlueprintCraftingRecipe, BlueprintLines> blueprintCache = new HashMap();

    public void render(TileEntityAutoWorkbench te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float tx;
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        if (te.mirrored) {
            GlStateManager.scale((float)(te.facing.getFrontOffsetX() == 0 ? -1.0f : 1.0f), (float)1.0f, (float)(te.facing.getFrontOffsetZ() == 0 ? -1.0f : 1.0f));
        }
        float[][] itemDisplays = new float[te.processQueue.size()][];
        float drill = 0.0f;
        float lift = 0.0f;
        float press = 0.0f;
        float liftPress = 0.0f;
        for (int i = 0; i < itemDisplays.length; ++i) {
            float processTimer;
            TileEntityMultiblockMetal.MultiblockProcess process = (TileEntityMultiblockMetal.MultiblockProcess)te.processQueue.get(i);
            if (process == null || process.processTick <= 0 || process.processTick == process.maxTicks || (processTimer = (float)process.processTick / (float)process.maxTicks * 180.0f) <= 9.0f) continue;
            float itemX = -1.0f;
            float itemY = -0.34375f;
            float itemZ = -0.9375f;
            float itemAngle = 90.0f;
            if (processTimer <= 24.0f) {
                itemAngle = 67.5f;
                if (processTimer <= 19.0f) {
                    itemZ = (float)((double)itemZ + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.5f)));
                    itemY = (float)((double)itemY + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.21875f)));
                } else {
                    itemZ += (24.0f - processTimer) / 5.0f * 0.25f;
                    itemY += (24.0f - processTimer) / 5.0f * 0.25f;
                }
            } else if (processTimer <= 40.0f) {
                itemX += (processTimer - 24.0f) / 16.0f;
            } else if (processTimer <= 100.0f) {
                itemX += 1.0f;
                float drillStep = 0.0f;
                if (processTimer <= 60.0f) {
                    lift = (processTimer - 40.0f) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (60.0f - processTimer) * 4.0f;
                } else if (processTimer <= 80.0f) {
                    lift = 0.3125f;
                    drillStep = 4.0f;
                } else {
                    lift = (100.0f - processTimer) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (processTimer - 80.0f) * 4.0f;
                }
                if (drillStep > 0.0f) {
                    drill = processTimer % drillStep / drillStep * 360.0f;
                }
                itemY = (float)((double)itemY + Math.max(0.0, (double)lift - 0.0625));
            } else if (processTimer <= 116.0f) {
                itemX += 1.0f;
                itemZ += (processTimer - 100.0f) / 16.0f;
            } else if (processTimer <= 132.0f) {
                itemX += 1.0f + (processTimer - 116.0f) / 16.0f;
                itemZ += 1.0f;
            } else if (processTimer <= 172.0f) {
                itemX += 2.0f;
                itemZ += 1.0f;
                press = processTimer <= 142.0f ? (processTimer - 132.0f) / 10.0f : (processTimer <= 162.0f ? 1.0f : (172.0f - processTimer) / 10.0f);
                liftPress = press * 0.0625f;
                itemY += liftPress;
            } else if (processTimer <= 180.0f) {
                itemX += 2.0f + (processTimer - 172.0f) / 16.0f;
                itemZ += 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemAngle};
        }
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        ItemStack blueprintStack = (ItemStack)te.inventory.get(0);
        if (!blueprintStack.isEmpty()) {
            TileRenderAutoWorkbench.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "blueprint");
        }
        GlStateManager.translate((float)0.0f, (float)lift, (float)0.0f);
        TileRenderAutoWorkbench.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "lift");
        GlStateManager.translate((float)0.0f, (float)(-lift), (float)0.0f);
        EnumFacing f = te.getFacing();
        float f2 = f == EnumFacing.WEST ? -0.9375f : (tx = f == EnumFacing.EAST ? 0.9375f : 0.0f);
        float tz = f == EnumFacing.NORTH ? -0.9375f : (f == EnumFacing.SOUTH ? 0.9375f : 0.0f);
        GlStateManager.translate((float)tx, (float)0.0f, (float)tz);
        GlStateManager.rotate((float)drill, (float)0.0f, (float)1.0f, (float)0.0f);
        TileRenderAutoWorkbench.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "drill");
        GlStateManager.rotate((float)(-drill), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)(-tx), (float)0.0f, (float)(-tz));
        float f3 = f == EnumFacing.WEST ? -0.59375f : (tx = f == EnumFacing.EAST ? 0.59375f : 0.0f);
        tz = f == EnumFacing.NORTH ? -0.59375f : (f == EnumFacing.SOUTH ? 0.59375f : 0.0f);
        GlStateManager.translate((double)tx, (double)-0.21875, (double)tz);
        GlStateManager.rotate((float)(press * 90.0f), (float)(-f.getFrontOffsetZ()), (float)0.0f, (float)f.getFrontOffsetX());
        TileRenderAutoWorkbench.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "press");
        GlStateManager.rotate((float)(-press * 90.0f), (float)(-f.getFrontOffsetZ()), (float)0.0f, (float)f.getFrontOffsetX());
        GlStateManager.translate((double)(-tx), (double)0.21875, (double)(-tz));
        GlStateManager.translate((float)0.0f, (float)liftPress, (float)0.0f);
        TileRenderAutoWorkbench.renderModelPart(blockRenderer, tessellator, worldRenderer, te.getWorld(), state, model, blockPos, "pressLift");
        GlStateManager.translate((float)0.0f, (float)(-liftPress), (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
        switch (f) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotate((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            TileEntityMultiblockMetal.MultiblockProcess process;
            if (itemDisplays[i] == null || (process = (TileEntityMultiblockMetal.MultiblockProcess)te.processQueue.get(i)) == null || !(process instanceof TileEntityMultiblockMetal.MultiblockProcessInWorld)) continue;
            float scale = 0.3125f;
            List<ItemStack> dList = ((TileEntityMultiblockMetal.MultiblockProcessInWorld)process).getDisplayItem();
            if (dList.isEmpty()) continue;
            if (dList.size() < 2) {
                GlStateManager.translate((float)itemDisplays[i][1], (float)itemDisplays[i][2], (float)itemDisplays[i][3]);
                GlStateManager.rotate((float)itemDisplays[i][4], (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.scale((float)scale, (float)scale, (float)0.5f);
                ClientUtils.mc().getRenderItem().renderItem(dList.get(0), ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)2.0f);
                GlStateManager.rotate((float)(-itemDisplays[i][4]), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translate((float)(-itemDisplays[i][1]), (float)(-itemDisplays[i][2]), (float)(-itemDisplays[i][3]));
                continue;
            }
            int size = dList.size();
            int lines = (int)Math.ceil((float)size / 2.0f);
            float spacer = (float)(lines - 1) * 0.234375f;
            for (int d = 0; d < size; ++d) {
                float oX = (size > 2 ? -0.3125f : 0.0f) + (float)(lines - d / 2) * 0.0625f + (float)(d % 2) * 0.3125f;
                float oZ = -spacer / 2.0f + (float)(d / 2) * 0.234375f;
                float oY = 0.0f;
                float localItemX = itemDisplays[i][1] + oX;
                float localItemY = itemDisplays[i][2] + oY;
                float localItemZ = itemDisplays[i][3] + oZ;
                float subProcess = itemDisplays[i][0] - (float)(d / 2 * 4);
                float localAngle = itemDisplays[i][4];
                if (subProcess <= 24.0f) {
                    localAngle = 67.5f;
                    if (subProcess <= 19.0f) {
                        localItemZ = -0.75f + (19.0f - subProcess) / 10.0f * 0.5f;
                        localItemY = -0.09375f + (19.0f - subProcess) / 10.0f * 0.21875f;
                    } else {
                        localItemZ = -1.0f + (oZ - (24.0f - subProcess) / 5.0f * oZ);
                        localItemY = -0.34375f + (24.0f - subProcess) / 5.0f * 0.25f;
                    }
                }
                GlStateManager.translate((float)localItemX, (float)localItemY, (float)localItemZ);
                GlStateManager.rotate((float)localAngle, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.scale((float)scale, (float)scale, (float)0.5f);
                ClientUtils.mc().getRenderItem().renderItem(dList.get(d), ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)2.0f);
                GlStateManager.rotate((float)(-localAngle), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translate((float)(-localItemX), (float)(-localItemY), (float)(-localItemZ));
            }
        }
        double playerDistanceSq = ClientUtils.mc().player.getDistanceSq(blockPos);
        if (!blueprintStack.isEmpty() && playerDistanceSq < 1000.0) {
            BlueprintLines blueprint;
            BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(blueprintStack, "blueprint"));
            BlueprintCraftingRecipe recipe = te.selectedRecipe < 0 || te.selectedRecipe >= recipes.length ? null : recipes[te.selectedRecipe];
            BlueprintLines blueprintLines = blueprint = recipe == null ? null : TileRenderAutoWorkbench.getBlueprintDrawable(recipe, te.getWorld());
            if (blueprint != null) {
                float lineWidth = playerDistanceSq < 6.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                GlStateManager.translate((double)-0.195, (double)0.125, (double)0.97);
                GlStateManager.rotate((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.disableCull();
                GlStateManager.disableTexture2D();
                GlStateManager.enableBlend();
                float scale = 0.0375f / ((float)blueprint.textureScale / 16.0f);
                GlStateManager.scale((float)scale, (float)(-scale), (float)scale);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                blueprint.draw(lineWidth);
                GlStateManager.scale((float)(1.0f / scale), (float)(-1.0f / scale), (float)(1.0f / scale));
                GlStateManager.enableAlpha();
                GlStateManager.enableTexture2D();
                GlStateManager.enableCull();
            }
        }
        GlStateManager.popMatrix();
    }

    public static void renderModelPart(BlockRendererDispatcher blockRenderer, Tessellator tessellator, BufferBuilder worldRenderer, World world, IBlockState state, IBakedModel model, BlockPos pos, String ... parts) {
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(Arrays.asList(parts), true));
        }
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)pos.getX(), -0.5 - (double)pos.getY(), -0.5 - (double)pos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)world, model, state, pos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
    }

    public static BlueprintLines getBlueprintDrawable(BlueprintCraftingRecipe recipe, World world) {
        if (recipe == null) {
            return null;
        }
        BlueprintLines blueprint = blueprintCache.get(recipe);
        if (blueprint == null) {
            blueprint = TileRenderAutoWorkbench.getBlueprintDrawable(recipe.output, world);
            blueprintCache.put(recipe, blueprint);
        }
        return blueprint;
    }

    public static BlueprintLines getBlueprintDrawable(ItemStack stack, World world) {
        if (stack.isEmpty()) {
            return null;
        }
        EntityPlayerSP player = ClientUtils.mc().player;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            IBakedModel ibakedmodel = ClientUtils.mc().getRenderItem().getItemModelWithOverrides(stack, world, (EntityLivingBase)player);
            HashSet<String> textures = new HashSet<String>();
            List quads = ibakedmodel.getQuads(null, null, 0L);
            for (BakedQuad bakedQuad : quads) {
                if (bakedQuad == null || bakedQuad.getSprite() == null) continue;
                textures.add(bakedQuad.getSprite().getIconName());
            }
            for (String string : textures) {
                ResourceLocation rl = new ResourceLocation(string);
                rl = new ResourceLocation(rl.getResourceDomain(), String.format("%s/%s%s", "textures", rl.getResourcePath(), ".png"));
                IResource resource = ClientUtils.mc().getResourceManager().getResource(rl);
                BufferedImage bufferedImage = TextureUtil.readBufferedImage((InputStream)resource.getInputStream());
                if (bufferedImage == null) continue;
                images.add(bufferedImage);
            }
        }
        catch (Exception ibakedmodel) {
            // empty catch block
        }
        if (images.isEmpty()) {
            return null;
        }
        ArrayList lines = new ArrayList();
        HashSet<TexturePoint> testSet = new HashSet<TexturePoint>();
        HashMultimap area = HashMultimap.create();
        int wMax = 0;
        for (BufferedImage bufferedImage : images) {
            HashSet<Pair> temp_lines = new HashSet<Pair>();
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            if (h > w) {
                h = w;
            }
            if (w > wMax) {
                wMax = w;
            }
            for (int hh = 0; hh < h; ++hh) {
                for (int ww = 0; ww < w; ++ww) {
                    int argb = bufferedImage.getRGB(ww, hh);
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    float intesity = (r + b + g) / 3.0f;
                    int alpha = argb >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    boolean added = false;
                    TexturePoint tp = new TexturePoint(ww, hh, w);
                    if (!testSet.contains(tp)) {
                        for (Integer key : area.keySet()) {
                            for (Point p : area.get((Object)key)) {
                                float dB;
                                float dG;
                                int pColour = bufferedImage.getRGB(p.x, p.y);
                                float dR = r - (float)(pColour >> 16 & 0xFF) / 255.0f;
                                double delta = Math.sqrt(dR * dR + (dG = g - (float)(pColour >> 8 & 0xFF) / 255.0f) * dG + (dB = b - (float)(pColour & 0xFF) / 255.0f) * dB);
                                if (!(delta < 0.25)) continue;
                                area.put((Object)key, (Object)tp);
                                added = true;
                                break;
                            }
                            if (!added) continue;
                            break;
                        }
                        if (!added) {
                            area.put((Object)argb, (Object)tp);
                        }
                        testSet.add(tp);
                    }
                    for (int i = 0; i < 4; ++i) {
                        int xx;
                        int n = i == 0 ? -1 : (xx = i == 1 ? 1 : 0);
                        int yy = i == 2 ? -1 : (i == 3 ? 1 : 0);
                        int u = ww + xx;
                        int v = hh + yy;
                        int neighbour = 0;
                        float delta = 1.0f;
                        boolean notTransparent = false;
                        if (u >= 0 && u < w && v >= 0 && v < h) {
                            neighbour = bufferedImage.getRGB(u, v);
                            boolean bl = notTransparent = (neighbour >> 24 & 0xFF) > 0;
                            if (notTransparent) {
                                float bDelta;
                                float gDelta;
                                float rDelta;
                                float neighbourIntesity = (float)((neighbour >> 16 & 0xFF) + (neighbour >> 8 & 0xFF) + (neighbour & 0xFF)) / 765.0f;
                                float intesityDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(intesity - neighbourIntesity)));
                                delta = Math.max(intesityDelta, Math.max(rDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(r - (float)(neighbour >> 16 & 0xFF) / 255.0f))), Math.max(gDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(g - (float)(neighbour >> 8 & 0xFF) / 255.0f))), bDelta = Math.max(0.0f, Math.min(1.0f, Math.abs(b - (float)(neighbour & 0xFF) / 255.0f))))));
                                float f = (double)delta < 0.25 ? 0.0f : (delta = (double)delta > 0.4 ? 1.0f : delta);
                            }
                        }
                        if (!(delta > 0.0f)) continue;
                        Pair l = Pair.of((Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 0)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 0)), w), (Object)new TexturePoint(ww + (i == 0 ? 0 : (i == 1 ? 1 : 1)), hh + (i == 2 ? 0 : (i == 3 ? 1 : 1)), w));
                        temp_lines.add(l);
                    }
                }
            }
            lines.addAll(temp_lines);
        }
        ArrayList arrayList = new ArrayList(area.keySet());
        Collections.sort(arrayList, (rgb1, rgb2) -> Double.compare(TileRenderAutoWorkbench.getLuminance(rgb1), TileRenderAutoWorkbench.getLuminance(rgb2)));
        HashMultimap complete_areaMap = HashMultimap.create();
        int lineNumber = 2;
        int lineStyle = 0;
        for (Integer i : arrayList) {
            complete_areaMap.putAll((Object)new ShadeStyle(lineNumber, lineStyle), (Iterable)area.get((Object)i));
            ++lineStyle;
            if ((lineStyle %= 3) != 0) continue;
            ++lineNumber;
        }
        HashSet<Pair<Point, Point>> complete_lines = new HashSet<Pair<Point, Point>>();
        for (Pair line : lines) {
            TexturePoint p1 = (TexturePoint)line.getKey();
            TexturePoint p2 = (TexturePoint)line.getValue();
            complete_lines.add((Pair<Point, Point>)Pair.of((Object)new Point((int)((float)p1.x / (float)p1.scale * (float)wMax), (int)((float)p1.y / (float)p1.scale * (float)wMax)), (Object)new Point((int)((float)p2.x / (float)p2.scale * (float)wMax), (int)((float)p2.y / (float)p2.scale * (float)wMax))));
        }
        return new BlueprintLines(wMax, complete_lines, (HashMultimap<ShadeStyle, Point>)complete_areaMap);
    }

    private static double getLuminance(int rgb) {
        return Math.sqrt(0.241 * (double)(rgb >> 16 & 0xFF) + 0.691 * (double)(rgb >> 8 & 0xFF) + 0.068 * (double)(rgb & 0xFF));
    }

    private static class TexturePoint
    extends Point {
        final int scale;

        public TexturePoint(int x, int y, int scale) {
            super(x, y);
            this.scale = scale;
        }

        @Override
        public int hashCode() {
            return 31 * (31 * this.x + this.y) + this.scale;
        }
    }

    private static class ShadeStyle {
        int stripeAmount = 1;
        int stripeDirection = 0;

        ShadeStyle(int stripeAmount, int stripeDirection) {
            this.stripeAmount = stripeAmount;
            this.stripeDirection = stripeDirection;
        }

        void drawShading(Point pixel) {
            float step = 1.0f / (float)this.stripeAmount;
            float offset = step / 2.0f;
            if (this.stripeDirection > 1) {
                int perSide = this.stripeAmount / 2 + (this.stripeAmount % 2 == 1 ? 1 : 0);
                step = 1.0f / (float)perSide;
                offset = this.stripeAmount % 2 == 1 ? step : step / 2.0f;
            }
            for (int i = 0; i < this.stripeAmount; ++i) {
                if (this.stripeDirection == 0) {
                    GlStateManager.glVertex3f((float)((float)pixel.x + offset + step * (float)i), (float)pixel.y, (float)0.0f);
                    GlStateManager.glVertex3f((float)((float)pixel.x + offset + step * (float)i), (float)(pixel.y + 1), (float)0.0f);
                    continue;
                }
                if (this.stripeDirection == 1) {
                    GlStateManager.glVertex3f((float)pixel.x, (float)((float)pixel.y + offset + step * (float)i), (float)0.0f);
                    GlStateManager.glVertex3f((float)(pixel.x + 1), (float)((float)pixel.y + offset + step * (float)i), (float)0.0f);
                    continue;
                }
                if (this.stripeDirection != 2) continue;
                if (i == this.stripeAmount - 1 && this.stripeAmount % 2 == 1) {
                    GlStateManager.glVertex3f((float)pixel.x, (float)(pixel.y + 1), (float)0.0f);
                    GlStateManager.glVertex3f((float)(pixel.x + 1), (float)pixel.y, (float)0.0f);
                    continue;
                }
                if (i % 2 == 0) {
                    GlStateManager.glVertex3f((float)pixel.x, (float)((float)pixel.y + offset + step * (float)(i / 2)), (float)0.0f);
                    GlStateManager.glVertex3f((float)((float)pixel.x + offset + step * (float)(i / 2)), (float)pixel.y, (float)0.0f);
                    continue;
                }
                GlStateManager.glVertex3f((float)((float)(pixel.x + 1) - offset - step * (float)(i / 2)), (float)(pixel.y + 1), (float)0.0f);
                GlStateManager.glVertex3f((float)(pixel.x + 1), (float)((float)(pixel.y + 1) - offset - step * (float)(i / 2)), (float)0.0f);
            }
        }
    }

    public static class BlueprintLines {
        final int textureScale;
        final Set<Pair<Point, Point>> lines;
        final HashMultimap<ShadeStyle, Point> areas;

        BlueprintLines(int textureScale, Set<Pair<Point, Point>> lines, HashMultimap<ShadeStyle, Point> areas) {
            this.textureScale = textureScale;
            this.lines = lines;
            this.areas = areas;
        }

        public int getTextureScale() {
            return this.textureScale;
        }

        public void draw(float lineWidth) {
            GlStateManager.glLineWidth((float)lineWidth);
            GlStateManager.glBegin((int)1);
            for (Pair<Point, Point> line : this.lines) {
                GlStateManager.glVertex3f((float)((Point)line.getKey()).x, (float)((Point)line.getKey()).y, (float)0.0f);
                GlStateManager.glVertex3f((float)((Point)line.getValue()).x, (float)((Point)line.getValue()).y, (float)0.0f);
            }
            GlStateManager.glEnd();
            if (lineWidth >= 1.0f) {
                GlStateManager.glLineWidth((float)(lineWidth * 0.66f));
                GL11.glPointSize((float)4.0f);
                GlStateManager.glBegin((int)1);
                for (ShadeStyle style : this.areas.keySet()) {
                    for (Point pixel : this.areas.get((Object)style)) {
                        style.drawShading(pixel);
                    }
                }
                GlStateManager.glEnd();
            }
        }
    }
}

