/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;

public class TileRenderArcFurnace
extends TileEntitySpecialRenderer<TileEntityArcFurnace> {
    public void render(TileEntityArcFurnace te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.formed || te.isDummy() || !te.getWorld().isBlockLoaded(te.getPos(), false)) {
            return;
        }
        List renderedParts = null;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)te.getInventory().get(23 + i)).isEmpty()) continue;
            if (renderedParts == null) {
                renderedParts = Lists.newArrayList((Object[])new String[]{"electrode" + (i + 1)});
                continue;
            }
            renderedParts.add("electrode" + (i + 1));
        }
        if (renderedParts == null) {
            return;
        }
        if (te.shouldRenderAsActive()) {
            renderedParts.add("active");
        }
        BlockRendererDispatcher blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        BlockPos blockPos = te.getPos();
        IBlockState state = this.getWorld().getBlockState(blockPos);
        if (state.getBlock() != IEContent.blockMetalMultiblock) {
            return;
        }
        state = state.getBlock().getActualState(state, (IBlockAccess)this.getWorld(), blockPos);
        state = state.withProperty((IProperty)IEProperties.DYNAMICRENDER, (Comparable)Boolean.valueOf(true));
        IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(state);
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).withProperty(Properties.AnimationProperty, (Object)new OBJModel.OBJState(renderedParts, true));
        }
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder worldRenderer = tessellator.getBuffer();
        ClientUtils.bindAtlas();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        RenderHelper.disableStandardItemLighting();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        worldRenderer.begin(7, DefaultVertexFormats.BLOCK);
        worldRenderer.setTranslation(-0.5 - (double)blockPos.getX(), -0.5 - (double)blockPos.getY(), -0.5 - (double)blockPos.getZ());
        worldRenderer.color(255, 255, 255, 255);
        blockRenderer.getBlockModelRenderer().renderModel((IBlockAccess)te.getWorld(), model, state, blockPos, worldRenderer, true);
        worldRenderer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
        GlStateManager.popMatrix();
    }
}

