/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class EntityRenderRailgunShot
extends Render {
    public EntityRenderRailgunShot(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(Entity entity, double x, double y, double z, float f0, float f1) {
        double yaw = entity.prevRotationYaw + (entity.rotationYaw - entity.prevRotationYaw) * f1 - 90.0f;
        double pitch = entity.prevRotationPitch + (entity.rotationPitch - entity.prevRotationPitch) * f1;
        ItemStack ammo = ((EntityRailgunShot)entity).getAmmo();
        int[][] colourMap = new int[][]{{0x777777, 0xA4A4A4}};
        if (!ammo.isEmpty()) {
            RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(ammo);
            colourMap = prop != null ? (Object)prop.colourMap : colourMap;
        }
        EntityRenderRailgunShot.renderRailgunProjectile(x, y, z, yaw, pitch, colourMap);
    }

    public static void renderRailgunProjectile(double x, double y, double z, double yaw, double pitch, int[][] colourMap) {
        int colB;
        int colG;
        int colR;
        int i;
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.enableRescaleNormal();
        Tessellator tes = ClientUtils.tes();
        BufferBuilder worldrenderer = ClientUtils.tes().getBuffer();
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GlStateManager.disableCull();
        GlStateManager.rotate((float)((float)yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)((float)pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.scale((float)0.25f, (float)0.25f, (float)0.25f);
        if (((int[][])colourMap).length == 1) {
            colourMap = new int[][]{colourMap[0], colourMap[0]};
        }
        float height = 0.1875f;
        float halfWidth = height / 2.0f;
        float length = 2.0f;
        int colWidth = colourMap[0].length;
        for (int i2 = 0; i2 < ((int[][])colourMap).length; ++i2) {
            colWidth = Math.min(colWidth, colourMap[i2].length);
        }
        int colLength = ((int[][])colourMap).length;
        float widthStep = height / (float)colWidth;
        float lengthStep = length / (float)colLength;
        GlStateManager.translate((float)(-length * 0.85f), (float)0.0f, (float)0.0f);
        worldrenderer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < colWidth; ++i) {
            colR = colourMap[0][i] >> 16 & 0xFF;
            colG = colourMap[0][i] >> 8 & 0xFF;
            colB = colourMap[0][i] & 0xFF;
            worldrenderer.pos(0.0, (double)height, (double)(-halfWidth + widthStep * (float)i)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos(0.0, 0.0, (double)(-halfWidth + widthStep * (float)i)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos(0.0, 0.0, (double)(-halfWidth + widthStep * (float)(i + 1))).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos(0.0, (double)height, (double)(-halfWidth + widthStep * (float)(i + 1))).color(colR, colG, colB, 255).endVertex();
            colR = colourMap[colLength - 1][i] >> 16 & 0xFF;
            colG = colourMap[colLength - 1][i] >> 8 & 0xFF;
            colB = colourMap[colLength - 1][i] & 0xFF;
            worldrenderer.pos((double)length, 0.0, (double)(-halfWidth + widthStep * (float)i)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)length, (double)height, (double)(-halfWidth + widthStep * (float)i)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)length, (double)height, (double)(-halfWidth + widthStep * (float)(i + 1))).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)length, 0.0, (double)(-halfWidth + widthStep * (float)(i + 1))).color(colR, colG, colB, 255).endVertex();
        }
        for (i = 0; i < colLength; ++i) {
            colR = colourMap[i][0] >> 16 & 0xFF;
            colG = colourMap[i][0] >> 8 & 0xFF;
            colB = colourMap[i][0] & 0xFF;
            worldrenderer.pos((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth)).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth)).color(colR, colG, colB, 255).endVertex();
            colR = colourMap[i][colWidth - 1] >> 16 & 0xFF;
            colG = colourMap[i][colWidth - 1] >> 8 & 0xFF;
            colB = colourMap[i][colWidth - 1] & 0xFF;
            worldrenderer.pos((double)(lengthStep * (float)i), (double)height, (double)halfWidth).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)i), 0.0, (double)halfWidth).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)(i + 1)), 0.0, (double)halfWidth).color(colR, colG, colB, 255).endVertex();
            worldrenderer.pos((double)(lengthStep * (float)(i + 1)), (double)height, (double)halfWidth).color(colR, colG, colB, 255).endVertex();
        }
        for (i = 0; i < colLength; ++i) {
            for (int j = 0; j < colWidth; ++j) {
                colR = colourMap[i][j] >> 16 & 0xFF;
                colG = colourMap[i][j] >> 8 & 0xFF;
                colB = colourMap[i][j] & 0xFF;
                worldrenderer.pos((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth + widthStep * (float)j)).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth + widthStep * (float)j)).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth + widthStep * (float)(j + 1))).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth + widthStep * (float)(j + 1))).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth + widthStep * (float)j)).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth + widthStep * (float)j)).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth + widthStep * (float)(j + 1))).color(colR, colG, colB, 255).endVertex();
                worldrenderer.pos((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth + widthStep * (float)(j + 1))).color(colR, colG, colB, 255).endVertex();
            }
        }
        tes.draw();
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
        GlStateManager.enableCull();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return new ResourceLocation("immersiveengineering:textures/models/white.png");
    }
}

