/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityFluorescentTube;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class EntityRenderFluorescentTube
extends Render<EntityFluorescentTube> {
    static double sqrt2Half = Math.sqrt(2.0) / 2.0;
    public static final double[][] octagon = new double[][]{{1.0, 0.0}, {sqrt2Half, sqrt2Half}, {0.0, 1.0}, {-sqrt2Half, sqrt2Half}, {-1.0, 0.0}, {-sqrt2Half, -sqrt2Half}, {0.0, -1.0}, {sqrt2Half, -sqrt2Half}};
    Random r = new Random();
    ResourceLocation modelLocation = new ResourceLocation("immersiveengineering:fluorescent_tube.obj");
    TextureAtlasSprite tex;

    public EntityRenderFluorescentTube(RenderManager renderManager) {
        super(renderManager);
        this.shadowOpaque = 0.0f;
        this.shadowSize = 0.0f;
    }

    protected ResourceLocation getEntityTexture(EntityFluorescentTube entity) {
        return null;
    }

    public void doRender(EntityFluorescentTube entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Tessellator tes = Tessellator.getInstance();
        BufferBuilder wr = tes.getBuffer();
        GlStateManager.enableRescaleNormal();
        ClientUtils.bindAtlas();
        if (entity.active) {
            GlStateManager.disableRescaleNormal();
            GlStateManager.pushAttrib();
            GlStateManager.enableBlend();
            GlStateManager.disableLighting();
            GlStateManager.blendFunc((int)770, (int)771);
        }
        if (entity.rgb != null && entity.rgb.length >= 3) {
            float mult = 0.5f + (entity.active ? this.r.nextFloat() * 0.5f : 0.0f);
            GlStateManager.color((float)(entity.rgb[0] * mult), (float)(entity.rgb[1] * mult), (float)(entity.rgb[2] * mult));
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)(y + 1.0), (double)z);
        GlStateManager.rotate((float)(entityYaw + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.disableTexture2D();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)0.0, (double)0.0, (double)0.03125);
        GlStateManager.rotate((float)entity.angleHorizontal, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scale((double)0.0625, (double)1.0, (double)0.0625);
        wr.begin(7, DefaultVertexFormats.POSITION);
        float size = entity.tubeLength / 2.0f;
        for (int i = 0; i < 8; ++i) {
            wr.pos(octagon[i][0], (double)size, octagon[i][1]).endVertex();
            wr.pos(octagon[(i + 1) % 8][0], (double)size, octagon[(i + 1) % 8][1]).endVertex();
            wr.pos(octagon[(i + 1) % 8][0], (double)(-size), octagon[(i + 1) % 8][1]).endVertex();
            wr.pos(octagon[i][0], (double)(-size), octagon[i][1]).endVertex();
        }
        tes.draw();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        if (!entity.active) {
            GlStateManager.disableRescaleNormal();
        }
        GlStateManager.color((float)0.0f, (float)0.0f, (float)0.0f);
        wr.begin(7, DefaultVertexFormats.POSITION);
        wr.pos(octagon[0][0], (double)(-size), octagon[0][1]).endVertex();
        wr.pos(octagon[1][0], (double)(-size), octagon[1][1]).endVertex();
        wr.pos(octagon[2][0], (double)(-size), octagon[2][1]).endVertex();
        wr.pos(octagon[3][0], (double)(-size), octagon[3][1]).endVertex();
        wr.pos(octagon[3][0], (double)(-size), octagon[3][1]).endVertex();
        wr.pos(octagon[4][0], (double)(-size), octagon[4][1]).endVertex();
        wr.pos(octagon[7][0], (double)(-size), octagon[7][1]).endVertex();
        wr.pos(octagon[0][0], (double)(-size), octagon[0][1]).endVertex();
        wr.pos(octagon[4][0], (double)(-size), octagon[4][1]).endVertex();
        wr.pos(octagon[5][0], (double)(-size), octagon[5][1]).endVertex();
        wr.pos(octagon[6][0], (double)(-size), octagon[6][1]).endVertex();
        wr.pos(octagon[7][0], (double)(-size), octagon[7][1]).endVertex();
        wr.pos(octagon[3][0], (double)size, octagon[3][1]).endVertex();
        wr.pos(octagon[2][0], (double)size, octagon[2][1]).endVertex();
        wr.pos(octagon[1][0], (double)size, octagon[1][1]).endVertex();
        wr.pos(octagon[0][0], (double)size, octagon[0][1]).endVertex();
        wr.pos(octagon[0][0], (double)size, octagon[0][1]).endVertex();
        wr.pos(octagon[7][0], (double)size, octagon[7][1]).endVertex();
        wr.pos(octagon[4][0], (double)size, octagon[4][1]).endVertex();
        wr.pos(octagon[3][0], (double)size, octagon[3][1]).endVertex();
        wr.pos(octagon[7][0], (double)size, octagon[7][1]).endVertex();
        wr.pos(octagon[6][0], (double)size, octagon[6][1]).endVertex();
        wr.pos(octagon[5][0], (double)size, octagon[5][1]).endVertex();
        wr.pos(octagon[4][0], (double)size, octagon[4][1]).endVertex();
        tes.draw();
        if (entity.active) {
            GlStateManager.popAttrib();
        }
        GlStateManager.enableTexture2D();
        GlStateManager.popMatrix();
        GlStateManager.translate((double)-0.25, (double)-1.0, (double)0.0);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tex == null) {
            this.tex = Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite("minecraft:blocks/iron_block");
        }
        wr.begin(7, DefaultVertexFormats.POSITION_TEX);
        ClientUtils.renderTexturedBox(wr, 0.0, 0.0, 0.0, 0.0625, 1.0, 0.0625, this.tex.getMinU(), this.tex.getMinV(), this.tex.getMaxU(), this.tex.getMaxV());
        ClientUtils.renderTexturedBox(wr, 0.0625, 0.9375, 0.0, 0.25, 1.0, 0.0625, this.tex.getMinU(), this.tex.getMinV(), this.tex.getMaxU(), this.tex.getMaxV());
        tes.draw();
        GlStateManager.popMatrix();
    }
}

