/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class EntityRenderChemthrowerShot
extends Render {
    public EntityRenderChemthrowerShot(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(Entity entity, double x, double y, double z, float f0, float f1) {
        FluidStack f = ((EntityChemthrowerShot)entity).getFluid();
        if (f == null && (f = ((EntityChemthrowerShot)entity).getFluidSynced()) == null) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.disableStandardItemLighting();
        Tessellator tessellator = ClientUtils.tes();
        GlStateManager.rotate((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)(-this.renderManager.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        TextureAtlasSprite sprite = ClientUtils.mc().getTextureMapBlocks().getAtlasSprite(f.getFluid().getStill(f).toString());
        if (sprite != null) {
            int colour = f.getFluid().getColor(f);
            float a = (float)(colour >> 24 & 0xFF) / 255.0f;
            float r = (float)(colour >> 16 & 0xFF) / 255.0f;
            float g = (float)(colour >> 8 & 0xFF) / 255.0f;
            float b = (float)(colour & 0xFF) / 255.0f;
            ClientUtils.bindAtlas();
            int lightAll = entity.getBrightnessForRender();
            int lightA = lightAll >> 16 & 0xFFFF;
            int lightB = lightAll & 0xFFFF;
            GlStateManager.scale((float)0.25f, (float)0.25f, (float)0.25f);
            BufferBuilder worldrenderer = ClientUtils.tes().getBuffer();
            worldrenderer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
            worldrenderer.pos(-0.25, -0.25, 0.0).tex((double)sprite.getInterpolatedU(4.0), (double)sprite.getInterpolatedV(4.0)).lightmap(lightA, lightB).color(r, g, b, a).endVertex();
            worldrenderer.pos(0.25, -0.25, 0.0).tex((double)sprite.getInterpolatedU(0.0), (double)sprite.getInterpolatedV(4.0)).lightmap(lightA, lightB).color(r, g, b, a).endVertex();
            worldrenderer.pos(0.25, 0.25, 0.0).tex((double)sprite.getInterpolatedU(0.0), (double)sprite.getInterpolatedV(0.0)).lightmap(lightA, lightB).color(r, g, b, a).endVertex();
            worldrenderer.pos(-0.25, 0.25, 0.0).tex((double)sprite.getInterpolatedU(4.0), (double)sprite.getInterpolatedV(0.0)).lightmap(lightA, lightB).color(r, g, b, a).endVertex();
            tessellator.draw();
        }
        RenderHelper.enableStandardItemLighting();
        GlStateManager.disableBlend();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return new ResourceLocation("immersiveengineering:textures/models/bullet.png");
    }
}

