/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.common.items.ItemPowerpack;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.Vec3d;

public class ModelPowerpack
extends ModelIEArmorBase {
    public ModelRenderer[] modelParts = new ModelRenderer[8];
    public ModelRenderer[] colouredParts = new ModelRenderer[4];
    static final DecimalFormat keyFormat = new DecimalFormat("0.0000");
    public static final Cache<String, Vec3d[]> catenaryCacheLeft = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<String, Vec3d[]> catenaryCacheRight = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    static ModelPowerpack modelInstance;

    public ModelPowerpack(float modelSize, float p_i1149_2_, int textureWidthIn, int textureHeightIn) {
        super(modelSize, p_i1149_2_, textureWidthIn, textureHeightIn);
        this.modelParts[0] = new ModelRenderer((ModelBase)this, 40, 0);
        this.modelParts[0].addBox(-4.0f, -5.0f, -2.0f, 8, 10, 3, 0.0f);
        this.modelParts[0].setRotationPoint(0.0f, 5.0f, 4.0f);
        this.bipedBody.addChild(this.modelParts[0]);
        this.modelParts[1] = new ModelRenderer((ModelBase)this, 12, 0);
        this.modelParts[1].addBox(-3.0f, -2.0f, -2.0f, 6, 4, 4, 0.0f);
        this.modelParts[1].setRotationPoint(0.0f, 12.0f, 4.0f);
        this.bipedBody.addChild(this.modelParts[1]);
        this.modelParts[2] = new ModelRenderer((ModelBase)this, 0, 0);
        this.modelParts[2].addBox(-1.0f, -4.0f, -1.0f, 2, 8, 2, 0.0f);
        this.modelParts[2].setRotationPoint(-5.0f, 5.0f, 3.0f);
        this.bipedBody.addChild(this.modelParts[2]);
        this.modelParts[3] = new ModelRenderer((ModelBase)this, 0, 0);
        this.modelParts[3].addBox(-1.0f, -4.0f, -1.0f, 2, 8, 2, 0.0f);
        this.modelParts[3].setRotationPoint(5.0f, 5.0f, 3.0f);
        this.modelParts[3].rotateAngleZ = 3.14159f;
        this.bipedBody.addChild(this.modelParts[3]);
        ModelRenderer gauge = new ModelRenderer((ModelBase)this, 40, 13);
        gauge.addBox(-0.5f, -1.5f, -0.5f, 1, 3, 1, 0.0f);
        gauge.setRotationPoint(-3.0f, 5.5f, 5.0f);
        this.bipedBody.addChild(gauge);
        gauge = new ModelRenderer((ModelBase)this, 40, 13);
        gauge.addBox(-0.5f, -1.5f, -0.5f, 1, 3, 1, 0.0f);
        gauge.setRotationPoint(1.0f, 5.5f, 5.0f);
        this.bipedBody.addChild(gauge);
        gauge = new ModelRenderer((ModelBase)this, 44, 13);
        gauge.addBox(-2.0f, -0.5f, -0.5f, 3, 1, 1, 0.0f);
        gauge.setRotationPoint(-0.5f, 3.5f, 5.0f);
        this.bipedBody.addChild(gauge);
        gauge = new ModelRenderer((ModelBase)this, 44, 13);
        gauge.addBox(-2.0f, -0.5f, -0.5f, 3, 1, 1, 0.0f);
        gauge.setRotationPoint(-0.5f, 7.5f, 5.0f);
        this.bipedBody.addChild(gauge);
        this.modelParts[7] = new ModelRenderer((ModelBase)this, 52, 14);
        this.modelParts[7].addBox(-0.5f, -3.5f, -0.5f, 1, 4, 1, -0.25f);
        this.modelParts[7].setRotationPoint(-1.0f, 7.625f, 5.0f);
        this.modelParts[7].rotateAngleZ = 0.7853975f;
        this.bipedBody.addChild(this.modelParts[7]);
        ModelRenderer connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 3, 3, 3, 0.0f);
        connector.setRotationPoint(-4.5f, 0.0f, 0.0f);
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 3, 3, 3, -0.375f);
        connector.setRotationPoint(-6.0f, 0.0f, 0.0f);
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 29, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 1, 3, 3, 0.0f);
        connector.setRotationPoint(-6.25f, 0.0f, 0.0f);
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 12, 8);
        connector.addBox(-0.5f, -1.0f, -1.0f, 2, 2, 2, 0.0f);
        connector.setRotationPoint(-7.5f, 0.0f, 0.0f);
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 3, 3, 3, 0.0f);
        connector.setRotationPoint(4.5f, 0.0f, 0.0f);
        connector.rotateAngleY = 3.14159f;
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 17, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 3, 3, 3, -0.375f);
        connector.setRotationPoint(6.0f, 0.0f, 0.0f);
        connector.rotateAngleY = 3.14159f;
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 29, 9);
        connector.addBox(-1.0f, -1.5f, -1.5f, 1, 3, 3, 0.0f);
        connector.setRotationPoint(6.25f, 0.0f, 0.0f);
        connector.rotateAngleY = 3.14159f;
        this.modelParts[1].addChild(connector);
        connector = new ModelRenderer((ModelBase)this, 12, 8);
        connector.addBox(-0.5f, -1.0f, -1.0f, 2, 2, 2, 0.0f);
        connector.setRotationPoint(7.5f, 0.0f, 0.0f);
        connector.rotateAngleY = 3.14159f;
        this.modelParts[1].addChild(connector);
        for (int i = 0; i < 3; ++i) {
            float pos = 3.125f - (float)i * 2.25f;
            ModelRenderer tube = new ModelRenderer((ModelBase)this, 56, 19);
            tube.addBox(-1.0f, -1.0f, -1.0f, 2, 2, 2, -0.25f);
            tube.setRotationPoint(pos, 1.0f, 5.0f);
            tube.rotateAngleX = (float)Math.toRadians(-45.0);
            this.bipedBody.addChild(tube);
            ModelRenderer tube2 = new ModelRenderer((ModelBase)this, 52, 18);
            tube2.addBox(-0.5f, -2.0f, -0.5f, 1, 3, 1, 0.0f);
            tube2.setRotationPoint(0.0f, -0.5f, 0.0f);
            tube.addChild(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 15);
            tube2.addBox(-1.0f, -2.0f, -1.0f, 2, 2, 2, 0.0f);
            tube2.setRotationPoint(0.0f, -0.75f, 0.0f);
            tube.addChild(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 13);
            tube2.addBox(-0.5f, -1.0f, -0.5f, 1, 1, 1, 0.0f);
            tube2.setRotationPoint(0.0f, -2.25f, 0.0f);
            tube.addChild(tube2);
            tube2 = new ModelRenderer((ModelBase)this, 56, 13);
            tube2.addBox(-0.5f, -1.0f, -0.5f, 1, 1, 1, -0.25f);
            tube2.setRotationPoint(0.0f, -3.0f, 0.0f);
            tube.addChild(tube2);
        }
        this.bipedHead.isHidden = true;
        this.bipedHeadwear.isHidden = true;
        this.bipedLeftArm.isHidden = true;
        this.bipedRightArm.isHidden = true;
        this.bipedLeftLeg.isHidden = true;
        this.bipedRightLeg.isHidden = true;
    }

    @Override
    public void render(Entity entity, float p_78088_2_, float p_78088_3_, float p_78088_4_, float p_78088_5_, float p_78088_6_, float scale) {
        if (entity instanceof EntityLivingBase) {
            ItemStack chest = ((EntityLivingBase)entity).getItemStackFromSlot(EntityEquipmentSlot.CHEST);
            float storage = 0.0f;
            if (!chest.isEmpty() && chest.getItem() instanceof ItemArmor) {
                if (!(chest.getItem() instanceof ItemPowerpack)) {
                    chest = ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
                }
                if (chest.getItem() instanceof ItemPowerpack) {
                    float max = EnergyHelper.getMaxEnergyStored(chest);
                    storage = max <= 0.0f ? 0.0f : (float)EnergyHelper.getEnergyStored(chest) / max;
                }
                this.modelParts[7].rotateAngleZ = 0.5235987f - 1.047197f * storage;
            }
        }
        GlStateManager.enableBlend();
        super.render(entity, p_78088_2_, p_78088_3_, p_78088_4_, p_78088_5_, p_78088_6_, scale);
        GlStateManager.disableBlend();
        ClientUtils.bindTexture("immersiveengineering:textures/blocks/wire.png");
        GlStateManager.pushMatrix();
        if (entity instanceof EntityLivingBase) {
            for (EnumHand hand : EnumHand.values()) {
                ItemStack stack = ((EntityLivingBase)entity).getHeldItem(hand);
                if (stack.isEmpty() || !EnergyHelper.isFluxItem(stack)) continue;
                boolean right = hand == EnumHand.MAIN_HAND == (((EntityLivingBase)entity).getPrimaryHand() == EnumHandSide.RIGHT);
                float angleX = (right ? this.bipedRightArm : this.bipedLeftArm).rotateAngleX;
                float angleZ = (right ? this.bipedRightArm : this.bipedLeftArm).rotateAngleZ;
                String cacheKey = keyFormat.format(angleX) + "_" + keyFormat.format(angleZ);
                Vec3d[] vex = new Vec3d[]{};
                try {
                    vex = (Vec3d[])(right ? catenaryCacheRight : catenaryCacheLeft).get((Object)cacheKey, () -> {
                        double armLength = 0.75;
                        double x = 0.3125 + (double)(right ? 1 : -1) * armLength * Math.sin(angleZ);
                        double y = armLength * Math.cos(angleX);
                        double z = armLength * Math.sin(angleX);
                        return ApiUtils.getConnectionCatenary(new Vec3d(0.484375, -0.75, 0.25), new Vec3d(x, -y, z), 1.5);
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float vStep = 1.0f / (float)vex.length;
                int i = 0;
                Tessellator tes = ClientUtils.tes();
                BufferBuilder worldrenderer = tes.getBuffer();
                float[] colour = new float[]{0.93f, 0.63f, 0.27f, 1.0f};
                worldrenderer.begin(8, DefaultVertexFormats.POSITION_TEX_COLOR);
                for (Vec3d v : vex) {
                    worldrenderer.pos((right ? -v.x : v.x) - 0.015625, -v.y, v.z).tex((double)(vStep * (float)i), 0.0).color(colour[0], colour[1], colour[2], colour[3]).endVertex();
                    worldrenderer.pos((right ? -v.x : v.x) + 0.015625, -v.y, v.z).tex((double)(vStep * (float)i++), 1.0).color(colour[0], colour[1], colour[2], colour[3]).endVertex();
                }
                tes.draw();
                worldrenderer.begin(8, DefaultVertexFormats.POSITION_TEX_COLOR);
                i = 0;
                for (Vec3d v : vex) {
                    worldrenderer.pos(right ? -v.x : v.x, -v.y - 0.015625, v.z).tex((double)(vStep * (float)i), 0.0).color(colour[0], colour[1], colour[2], colour[3]).endVertex();
                    worldrenderer.pos(right ? -v.x : v.x, -v.y + 0.015625, v.z).tex((double)(vStep * (float)i++), 1.0).color(colour[0], colour[1], colour[2], colour[3]).endVertex();
                }
                tes.draw();
            }
        }
        GlStateManager.popMatrix();
    }

    public static ModelPowerpack getModel() {
        if (modelInstance == null) {
            modelInstance = new ModelPowerpack(0.0625f, 0.0f, 64, 32);
        }
        return modelInstance;
    }
}

