/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.lwjgl.util.vector.Vector3f;

public class DynamicAccessQuad
extends UnpackedBakedQuad {
    private Cache<Integer, DynamicAccessQuad> cachedVariations = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private int arraypos_POS = -1;
    private final String name;

    public DynamicAccessQuad(float[][][] unpackedData, String name, int tint, EnumFacing orientation, TextureAtlasSprite texture, boolean applyDiffuseLighting, VertexFormat format) {
        super(unpackedData, tint, orientation, texture, applyDiffuseLighting, format);
        this.name = name;
        for (int i = 0; i < format.getElementCount(); ++i) {
            if (format.getElement(i) != DefaultVertexFormats.POSITION_3F) continue;
            this.arraypos_POS = i;
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    public DynamicAccessQuad applyMatrix(Matrix4 matrix) {
        if (matrix == null) {
            return this;
        }
        if (this.arraypos_POS >= 0) {
            try {
                return (DynamicAccessQuad)((Object)this.cachedVariations.get((Object)matrix.hashCode(), () -> {
                    DynamicAccessQuad ret = new DynamicAccessQuad(this.getDataCopy(), this.name, this.tintIndex, this.face, this.sprite, this.applyDiffuseLighting, this.format);
                    for (int vertex = 0; vertex < 4; ++vertex) {
                        Vector3f vec = new Vector3f(this.unpackedData[vertex][this.arraypos_POS][0], this.unpackedData[vertex][this.arraypos_POS][1], this.unpackedData[vertex][this.arraypos_POS][2]);
                        vec = matrix.apply(vec);
                        ret.unpackedData[vertex][this.arraypos_POS][0] = vec.x;
                        ret.unpackedData[vertex][this.arraypos_POS][1] = vec.y;
                        ret.unpackedData[vertex][this.arraypos_POS][2] = vec.z;
                    }
                    return ret;
                }));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private float[][][] getDataCopy() {
        float[][][] dataCopy = new float[4][this.format.getElementCount()][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.format.getElementCount(); ++j) {
                for (int k = 0; k < 4; ++k) {
                    dataCopy[i][j][k] = this.unpackedData[i][j][k];
                }
            }
        }
        return dataCopy;
    }

    public static class Builder
    implements IVertexConsumer {
        private final VertexFormat format;
        private final float[][][] unpackedData;
        private final String name;
        private int tint = -1;
        private EnumFacing orientation;
        private TextureAtlasSprite texture;
        private boolean applyDiffuseLighting = true;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;
        private boolean contractUVs = false;
        private final float eps = 0.00390625f;

        public Builder(VertexFormat format, String name) {
            this.format = format;
            this.unpackedData = new float[4][format.getElementCount()][4];
            this.name = name;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setContractUVs(boolean value) {
            this.contractUVs = value;
        }

        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.orientation = orientation;
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.format.getElementCount()) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public UnpackedBakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            if (this.texture == null) {
                throw new IllegalStateException("texture not set");
            }
            if (this.contractUVs) {
                int i;
                int v;
                VertexFormatElement e;
                int uve;
                float tY;
                float tX = (float)this.texture.getOriginX() / this.texture.getMinU();
                float tS = tX > (tY = (float)this.texture.getOriginY() / this.texture.getMinV()) ? tX : tY;
                float ep = 1.0f / (tS * 256.0f);
                for (uve = 0; uve < this.format.getElementCount() && ((e = this.format.getElement(uve)).getUsage() != VertexFormatElement.EnumUsage.UV || e.getIndex() != 0); ++uve) {
                }
                if (uve == this.format.getElementCount()) {
                    throw new IllegalStateException("Can't contract UVs: format doesn't contain UVs");
                }
                float[] uvc = new float[4];
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        int n = i;
                        uvc[n] = uvc[n] + this.unpackedData[v][uve][i] / 4.0f;
                    }
                }
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        float uo = this.unpackedData[v][uve][i];
                        float un = uo * 0.99609375f + uvc[i] * 0.00390625f;
                        float ud = uo - un;
                        float aud = ud;
                        if (aud < 0.0f) {
                            aud = -aud;
                        }
                        if (aud < ep) {
                            float udc = uo - uvc[i];
                            if (udc < 0.0f) {
                                udc = -udc;
                            }
                            un = udc < 2.0f * ep ? (uo + uvc[i]) / 2.0f : uo + (ud < 0.0f ? ep : -ep);
                        }
                        this.unpackedData[v][uve][i] = un;
                    }
                }
            }
            return new DynamicAccessQuad(this.unpackedData, this.name, this.tint, this.orientation, this.texture, this.applyDiffuseLighting, this.format);
        }
    }
}

