/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.IEItemFontRender;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageShaderManual;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import java.util.LinkedHashSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class IEManualInstance
extends ManualInstance {
    LinkedHashSet<String> categorySet = new LinkedHashSet();

    public IEManualInstance() {
        super(new IEItemFontRender(), "immersiveengineering:textures/gui/manual.png");
        this.fontRenderer.colorCode[6] = -557004;
        this.fontRenderer.colorCode[22] = -12705779;
        ((IEItemFontRender)this.fontRenderer).createColourBackup();
        if (Minecraft.getMinecraft().gameSettings.language != null) {
            this.fontRenderer.setUnicodeFlag(ClientUtils.mc().getLanguageManager().isCurrentLocaleUnicode());
            this.fontRenderer.setBidiFlag(ClientUtils.mc().getLanguageManager().isCurrentLanguageBidirectional());
        }
        ((IReloadableResourceManager)ClientUtils.mc().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)this.fontRenderer);
    }

    @Override
    public String formatText(String s) {
        String result;
        String[] segment;
        String rep;
        int end;
        int start;
        if (!s.contains(" ")) {
            s = ManualUtils.attemptStringTranslation("ie.manual.entry.%s", s);
        }
        String splitKey = ";";
        s = s.replaceAll("<br>", "\n");
        int overflow = 0;
        while ((start = s.indexOf("<config")) >= 0 && overflow < 50) {
            block32: {
                int i;
                int idx;
                ++overflow;
                end = s.indexOf(">", start);
                rep = s.substring(start, end + 1);
                segment = rep.substring(0, rep.length() - 1).split(splitKey);
                if (segment.length < 3) break;
                result = "";
                if (segment[1].equalsIgnoreCase("b")) {
                    result = segment.length > 3 ? (Config.manual_bool.get(segment[2]) != false ? segment[3] : (segment.length > 4 ? segment[4] : "")) : "" + Config.manual_bool.get(segment[2]);
                } else if (segment[1].equalsIgnoreCase("i")) {
                    result = "" + Config.manual_int.get(segment[2]);
                } else if (segment[1].equalsIgnoreCase("iA")) {
                    int[] iA = Config.manual_intA.get(segment[2]);
                    if (segment.length > 3) {
                        try {
                            if (segment[3].startsWith("l")) {
                                int limiter = Integer.parseInt(segment[3].substring(1));
                                for (int i2 = 0; i2 < limiter; ++i2) {
                                    result = result + (i2 > 0 ? ", " : "") + iA[i2];
                                }
                            } else {
                                idx = Integer.parseInt(segment[3]);
                                result = "" + iA[idx];
                            }
                            break block32;
                        }
                        catch (Exception ex) {
                            break;
                        }
                    }
                    for (i = 0; i < iA.length; ++i) {
                        result = result + (i > 0 ? ", " : "") + iA[i];
                    }
                } else if (segment[1].equalsIgnoreCase("d")) {
                    result = "" + Config.manual_double.get(segment[2]);
                } else if (segment[1].equalsIgnoreCase("dA")) {
                    double[] iD = Config.manual_doubleA.get(segment[2]);
                    if (segment.length > 3) {
                        try {
                            idx = Integer.parseInt(segment[3]);
                            result = "" + Utils.formatDouble(iD[idx], "##0.0##");
                            break block32;
                        }
                        catch (Exception ex) {
                            break;
                        }
                    }
                    for (i = 0; i < iD.length; ++i) {
                        result = result + (i > 0 ? ", " : "") + Utils.formatDouble(iD[i], "##0.0##");
                    }
                }
            }
            s = s.replaceFirst(rep, result);
        }
        overflow = 0;
        while ((start = s.indexOf("<dim")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            result = "";
            try {
                int dim = Integer.parseInt(segment[1]);
                WorldServer world = DimensionManager.getWorld((int)dim);
                if (world != null && world.provider != null) {
                    String name = world.provider.getDimensionType().getName();
                    if (name.toLowerCase(Locale.ENGLISH).startsWith("the ") || name.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                        name = name.substring(4, 5).toUpperCase() + name.substring(5);
                    }
                    result = name;
                } else {
                    result = "Dimension " + dim;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            s = s.replaceFirst(rep, result);
        }
        overflow = 0;
        while ((start = s.indexOf("<keybind")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            result = "";
            for (KeyBinding kb : ClientUtils.mc().gameSettings.keyBindings) {
                if (!segment[1].equalsIgnoreCase(kb.getKeyDescription())) continue;
                result = Utils.toCamelCase(Keyboard.getKeyName((int)kb.getKeyCode()));
                break;
            }
            s = s.replaceFirst(rep, result);
        }
        if (this.improveReadability()) {
            end = 0;
            for (overflow = 0; (start = s.indexOf(TextFormatting.RESET.toString(), end)) >= 0 && overflow < 50; ++overflow) {
                end = start + TextFormatting.RESET.toString().length();
                s = s.substring(0, end) + TextFormatting.BOLD.toString() + s.substring(end);
            }
            s = TextFormatting.BOLD + s;
        }
        return s;
    }

    @Override
    public void openManual() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).spacingModifier = -0.5f;
            ((IEItemFontRender)this.fontRenderer).customSpaceWidth = 1.0f;
        }
    }

    @Override
    public void titleRenderPre() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).spacingModifier = 0.5f;
            ((IEItemFontRender)this.fontRenderer).customSpaceWidth = 4.0f;
        }
    }

    @Override
    public void titleRenderPost() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).spacingModifier = -0.5f;
            ((IEItemFontRender)this.fontRenderer).customSpaceWidth = 1.0f;
        }
    }

    @Override
    public void entryRenderPre() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).verticalBoldness = true;
        }
    }

    @Override
    public void entryRenderPost() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).verticalBoldness = false;
        }
    }

    @Override
    public void tooltipRenderPre() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).spacingModifier = 0.0f;
            ((IEItemFontRender)this.fontRenderer).customSpaceWidth = 4.0f;
            ((IEItemFontRender)this.fontRenderer).verticalBoldness = false;
        }
    }

    @Override
    public void tooltipRenderPost() {
        if (this.improveReadability()) {
            ((IEItemFontRender)this.fontRenderer).spacingModifier = -0.5f;
            ((IEItemFontRender)this.fontRenderer).customSpaceWidth = 1.0f;
            ((IEItemFontRender)this.fontRenderer).verticalBoldness = true;
        }
    }

    @Override
    public String getManualName() {
        return I18n.format((String)"item.immersiveengineering.tool.manual.name", (Object[])new Object[0]);
    }

    @Override
    public void addEntry(String name, String category, IManualPage ... pages) {
        super.addEntry(name, category, pages);
        if (!this.categorySet.contains(category)) {
            this.categorySet.add(category);
        }
    }

    @Override
    public String[] getSortedCategoryList() {
        return this.categorySet.toArray(new String[this.categorySet.size()]);
    }

    @Override
    public String formatCategoryName(String s) {
        return (this.improveReadability() ? TextFormatting.BOLD : "") + I18n.format((String)("ie.manual.category." + s + ".name"), (Object[])new Object[0]);
    }

    @Override
    public String formatEntryName(String s) {
        String unformatted = "ie.manual.entry." + s + ".name";
        String formatted = I18n.format((String)unformatted, (Object[])new Object[0]);
        return (this.improveReadability() ? TextFormatting.BOLD : "") + (unformatted.equals(formatted) ? s : formatted);
    }

    @Override
    public String formatEntrySubtext(String s) {
        String formatted;
        String unformatted = "ie.manual.entry." + s + ".subtext";
        return unformatted.equals(formatted = I18n.format((String)unformatted, (Object[])new Object[0])) ? "" : formatted;
    }

    @Override
    public boolean showEntryInList(ManualInstance.ManualEntry entry) {
        if (entry != null && ManualHelper.CAT_UPDATE.equalsIgnoreCase(entry.getCategory())) {
            return Config.IEConfig.showUpdateNews;
        }
        return entry == null || !"shaderList".equalsIgnoreCase(entry.getName());
    }

    @Override
    public boolean showCategoryInList(String category) {
        return true;
    }

    @Override
    public String formatLink(ManualInstance.ManualLink link) {
        return TextFormatting.GOLD + "  -> " + this.formatEntryName(link.getKey()) + ", " + (link.getPage() + 1);
    }

    @Override
    public void openEntry(String entry) {
        if ("shaderList".equalsIgnoreCase(entry)) {
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageShaderManual(MessageShaderManual.MessageType.SYNC, ClientUtils.mc().player.getName()));
        }
    }

    @Override
    public int getTitleColour() {
        return 16220212;
    }

    @Override
    public int getSubTitleColour() {
        return 16220212;
    }

    @Override
    public int getTextColour() {
        return this.improveReadability() ? 0 : 0x555555;
    }

    @Override
    public int getHighlightColour() {
        return 13926474;
    }

    @Override
    public int getPagenumberColour() {
        return 10260860;
    }

    @Override
    public boolean allowGuiRescale() {
        return Config.IEConfig.adjustManualScale;
    }

    @Override
    public boolean improveReadability() {
        return Config.IEConfig.badEyesight;
    }
}

