/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.GuiReactiveList;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurret;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretChem;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityTurretGun;
import blusunrize.immersiveengineering.common.gui.ContainerTurret;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTurret
extends GuiIEContainerBase {
    public TileEntityTurret tile;
    private GuiTextField nameField;

    public GuiTurret(InventoryPlayer inventoryPlayer, TileEntityTurret tile) {
        super(new ContainerTurret(inventoryPlayer, tile));
        this.tile = tile;
        this.ySize = 190;
    }

    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        this.nameField = new GuiTextField(0, this.fontRenderer, this.guiLeft + 11, this.guiTop + 88, 58, 12);
        this.nameField.setTextColor(-1);
        this.nameField.setDisabledTextColour(-1);
        this.nameField.setEnableBackgroundDrawing(false);
        this.nameField.setMaxStringLength(30);
        this.buttonList.clear();
        this.buttonList.add(new GuiReactiveList((GuiScreen)this, 0, this.guiLeft + 10, this.guiTop + 10, 60, 72, this.tile.targetList.toArray(new String[this.tile.targetList.size()])).setPadding(0, 0, 2, 2).setFormatting(1.0f, false));
        this.buttonList.add(new GuiButtonIE(1, this.guiLeft + 74, this.guiTop + 84, 24, 16, I18n.format((String)"gui.immersiveengineering.config.turret.add", (Object[])new Object[0]), "immersiveengineering:textures/gui/turret.png", 176, 65));
        this.buttonList.add(new GuiButtonCheckbox(2, this.guiLeft + 74, this.guiTop + 10, I18n.format((String)"gui.immersiveengineering.config.turret.blacklist", (Object[])new Object[0]), !this.tile.whitelist));
        this.buttonList.add(new GuiButtonCheckbox(3, this.guiLeft + 74, this.guiTop + 26, I18n.format((String)"gui.immersiveengineering.config.turret.animals", (Object[])new Object[0]), this.tile.attackAnimals));
        this.buttonList.add(new GuiButtonCheckbox(4, this.guiLeft + 74, this.guiTop + 42, I18n.format((String)"gui.immersiveengineering.config.turret.players", (Object[])new Object[0]), this.tile.attackPlayers));
        this.buttonList.add(new GuiButtonCheckbox(5, this.guiLeft + 74, this.guiTop + 58, I18n.format((String)"gui.immersiveengineering.config.turret.neutrals", (Object[])new Object[0]), this.tile.attackNeutrals));
        if (this.tile instanceof TileEntityTurretChem) {
            this.buttonList.add(new GuiButtonState(6, this.guiLeft + 135, this.guiTop + 68, 14, 14, null, ((TileEntityTurretChem)this.tile).ignite, "immersiveengineering:textures/gui/turret.png", 176, 51, 0));
        } else if (this.tile instanceof TileEntityTurretGun) {
            this.buttonList.add(new GuiButtonState(6, this.guiLeft + 134, this.guiTop + 31, 16, 16, null, ((TileEntityTurretGun)this.tile).expelCasings, "immersiveengineering:textures/gui/turret.png", 176, 81, 0));
        }
    }

    protected void actionPerformed(GuiButton button) {
        NBTTagCompound tag = new NBTTagCompound();
        int listOffset = -1;
        if (button.id == 0) {
            int rem = ((GuiReactiveList)button).selectedOption;
            this.tile.targetList.remove(rem);
            tag.setInteger("remove", rem);
            listOffset = ((GuiReactiveList)button).getOffset() - 1;
        } else if (button.id == 1 && !this.nameField.getText().isEmpty()) {
            String name = this.nameField.getText();
            if (!this.tile.targetList.contains(name)) {
                listOffset = ((GuiReactiveList)((Object)this.buttonList.get(0))).getMaxOffset();
                tag.setString("add", name);
                this.tile.targetList.add(name);
            }
            this.nameField.setText("");
        } else if (button.id == 2) {
            this.tile.whitelist = !((GuiButtonState)button).state;
            tag.setBoolean("whitelist", this.tile.whitelist);
        } else if (button.id == 3) {
            this.tile.attackAnimals = ((GuiButtonState)button).state;
            tag.setBoolean("attackAnimals", this.tile.attackAnimals);
        } else if (button.id == 4) {
            this.tile.attackPlayers = ((GuiButtonState)button).state;
            tag.setBoolean("attackPlayers", this.tile.attackPlayers);
        } else if (button.id == 5) {
            this.tile.attackNeutrals = ((GuiButtonState)button).state;
            tag.setBoolean("attackNeutrals", this.tile.attackNeutrals);
        } else if (button.id == 6 && this.tile instanceof TileEntityTurretChem) {
            ((TileEntityTurretChem)this.tile).ignite = ((GuiButtonState)button).state;
            tag.setBoolean("ignite", ((TileEntityTurretChem)this.tile).ignite);
        } else if (button.id == 6 && this.tile instanceof TileEntityTurretGun) {
            ((TileEntityTurretGun)this.tile).expelCasings = ((GuiButtonState)button).state;
            tag.setBoolean("expelCasings", ((TileEntityTurretGun)this.tile).expelCasings);
        }
        if (!tag.hasNoTags()) {
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            this.initGui();
            if (listOffset >= 0) {
                ((GuiReactiveList)((Object)this.buttonList.get(0))).setOffset(listOffset);
            }
        }
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        this.nameField.drawTextBox();
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx >= this.guiLeft + 158 && mx < this.guiLeft + 165 && my >= this.guiTop + 16 && my < this.guiTop + 62) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        if (this.tile instanceof TileEntityTurretChem) {
            ClientUtils.handleGuiTank((IFluidTank)((TileEntityTurretChem)this.tile).tank, this.guiLeft + 134, this.guiTop + 16, 16, 47, 196, 0, 20, 51, mx, my, "immersiveengineering:textures/gui/turret.png", tooltip);
            if (mx >= this.guiLeft + 135 && mx < this.guiLeft + 149 && my >= this.guiTop + 68 && my < this.guiTop + 82) {
                tooltip.add(I18n.format((String)"gui.immersiveengineering.config.turret.ignite_fluid", (Object[])new Object[0]));
            }
        } else if (this.tile instanceof TileEntityTurretGun && mx >= this.guiLeft + 134 && mx < this.guiLeft + 150 && my >= this.guiTop + 31 && my < this.guiTop + 47) {
            tooltip.add(I18n.format((String)("gui.immersiveengineering.config.turret.expel_casings_" + (((TileEntityTurretGun)this.tile).expelCasings ? "on" : "off")), (Object[])new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, -1, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/turret.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 158, this.guiTop + 16 + (46 - stored), this.guiLeft + 165, this.guiTop + 62, -4909824, -10482944);
        if (this.tile instanceof TileEntityTurretChem) {
            this.drawTexturedModalRect(this.guiLeft + 132, this.guiTop + 14, 176, 0, 20, 51);
            ClientUtils.handleGuiTank((IFluidTank)((TileEntityTurretChem)this.tile).tank, this.guiLeft + 134, this.guiTop + 16, 16, 47, 196, 0, 20, 51, mx, my, "immersiveengineering:textures/gui/turret.png", null);
        } else if (this.tile instanceof TileEntityTurretGun) {
            ClientUtils.drawDarkSlot(this.guiLeft + 134, this.guiTop + 13, 16, 16);
            ClientUtils.drawDarkSlot(this.guiLeft + 134, this.guiTop + 49, 16, 16);
        }
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.nameField.isFocused() && keyCode == 28) {
            String name = this.nameField.getText();
            if (!this.tile.targetList.contains(name)) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.setString("add", name);
                this.tile.targetList.add(name);
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
                this.initGui();
                ((GuiReactiveList)((Object)this.buttonList.get(0))).setOffset(((GuiReactiveList)((Object)this.buttonList.get(0))).getMaxOffset());
            }
        } else if (!this.nameField.textboxKeyTyped(typedChar, keyCode)) {
            super.keyTyped(typedChar, keyCode);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.nameField.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

