/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiSliderIE;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GuiModWorkbench
extends GuiIEContainerBase {
    TileEntityModWorkbench workbench;
    NBTTagCompound lastMessage;

    public GuiModWorkbench(InventoryPlayer inventoryPlayer, TileEntityModWorkbench tile) {
        super(new ContainerModWorkbench(inventoryPlayer, tile));
        this.workbench = tile;
        this.ySize = 168;
    }

    public void initGui() {
        this.buttonList.clear();
        super.initGui();
        Slot s = this.inventorySlots.getSlot(0);
        if (s != null && s.getHasStack() && s.getStack().getItem() instanceof IConfigurableTool) {
            IConfigurableTool.ToolConfig.ToolConfigFloat[] floatArray;
            ItemStack stack = s.getStack();
            IConfigurableTool tool = (IConfigurableTool)stack.getItem();
            int buttonid = 0;
            IConfigurableTool.ToolConfig.ToolConfigBoolean[] boolArray = tool.getBooleanOptions(stack);
            if (boolArray != null) {
                for (IConfigurableTool.ToolConfig.ToolConfigBoolean b : boolArray) {
                    this.buttonList.add(new GuiButtonCheckbox(buttonid++, this.guiLeft + b.x, this.guiTop + b.y, tool.fomatConfigName(stack, b), b.value));
                }
            }
            if ((floatArray = tool.getFloatOptions(stack)) != null) {
                for (IConfigurableTool.ToolConfig.ToolConfigFloat f : floatArray) {
                    this.buttonList.add(new GuiSliderIE(buttonid++, this.guiLeft + f.x, this.guiTop + f.y, 80, tool.fomatConfigName(stack, f), f.value));
                }
            }
        }
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        Slot s = this.inventorySlots.getSlot(0);
        if (s != null && s.getHasStack() && s.getStack().getItem() instanceof IConfigurableTool) {
            ItemStack stack = s.getStack();
            IConfigurableTool tool = (IConfigurableTool)stack.getItem();
            NBTTagCompound message = new NBTTagCompound();
            IConfigurableTool.ToolConfig.ToolConfigBoolean[] boolArray = tool.getBooleanOptions(stack);
            int iBool = 0;
            IConfigurableTool.ToolConfig.ToolConfigFloat[] floatArray = tool.getFloatOptions(stack);
            int iFloat = 0;
            for (GuiButton button : this.buttonList) {
                if (button instanceof GuiButtonCheckbox && boolArray != null) {
                    message.setBoolean("b_" + boolArray[iBool++].name, ((GuiButtonCheckbox)button).state);
                }
                if (!(button instanceof GuiSliderIE) || floatArray == null) continue;
                message.setFloat("f_" + floatArray[iFloat++].name, (float)((GuiSliderIE)button).sliderValue);
            }
            if (this.lastMessage == null || !this.lastMessage.equals((Object)message)) {
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.workbench, message));
            }
            this.lastMessage = message;
        }
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        for (int i = 0; i < ((ContainerModWorkbench)this.inventorySlots).slotCount; ++i) {
            BlueprintCraftingRecipe recipe;
            Slot s = this.inventorySlots.getSlot(i);
            if (!(s instanceof IESlot.BlueprintOutput) || s.getHasStack() || (recipe = ((IESlot.BlueprintOutput)s).recipe) == null || recipe.output.isEmpty() || !this.isPointInRegion(s.xPos, s.yPos, 16, 16, mx, my)) continue;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(recipe.output.getRarity().rarityColor + recipe.output.getDisplayName());
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (IngredientStack stack : recipe.inputs) {
                ItemStack toAdd = Utils.copyStackWithAmount(stack.getRandomizedExampleStack(this.mc.player.ticksExisted), stack.inputSize);
                if (toAdd.isEmpty()) continue;
                boolean isNew = true;
                for (ItemStack ss : inputs) {
                    if (!OreDictionary.itemMatches((ItemStack)ss, (ItemStack)toAdd, (boolean)true)) continue;
                    ss.grow(toAdd.getCount());
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                inputs.add(toAdd.copy());
            }
            for (ItemStack ss : inputs) {
                tooltip.add(TextFormatting.GRAY.toString() + ss.getCount() + "x " + ss.getDisplayName());
            }
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        Slot s;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/workbench.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (i = 0; i < ((ContainerModWorkbench)this.inventorySlots).slotCount; ++i) {
            s = this.inventorySlots.getSlot(i);
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos - 1, this.guiTop + s.yPos - 1, 17, 1, 0x77222222);
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos - 1, this.guiTop + s.yPos + 0, 1, 16, 0x77222222);
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos + 16, this.guiTop + s.yPos + 0, 1, 17, 0x77999999);
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos + 0, this.guiTop + s.yPos + 16, 16, 1, 0x77999999);
            if (s instanceof IESlot.BlueprintOutput && !s.getHasStack() && !((IESlot.BlueprintOutput)s).recipe.output.isEmpty()) continue;
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos + 0, this.guiTop + s.yPos + 0, 16, 16, 0x77444444);
        }
        for (i = 0; i < ((ContainerModWorkbench)this.inventorySlots).slotCount; ++i) {
            ItemStack ghostStack;
            s = this.inventorySlots.getSlot(i);
            if (!(s instanceof IESlot.BlueprintOutput) || s.getHasStack() || (ghostStack = ((IESlot.BlueprintOutput)s).recipe.output).isEmpty()) continue;
            this.zLevel = 200.0f;
            this.itemRender.zLevel = 200.0f;
            FontRenderer font = ghostStack.getItem().getFontRenderer(ghostStack);
            if (font == null) {
                font = this.fontRenderer;
            }
            this.itemRender.renderItemAndEffectIntoGUI(ghostStack, this.guiLeft + s.xPos, this.guiTop + s.yPos);
            this.zLevel = 0.0f;
            this.itemRender.zLevel = 0.0f;
            GlStateManager.disableLighting();
            GlStateManager.disableDepth();
            ClientUtils.drawColouredRect(this.guiLeft + s.xPos + 0, this.guiTop + s.yPos + 0, 16, 16, 0x77444444);
            GlStateManager.enableLighting();
            GlStateManager.enableDepth();
        }
    }
}

