/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMixer;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.gui.ContainerMixer;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiMixer
extends GuiIEContainerBase {
    TileEntityMixer tile;

    public GuiMixer(InventoryPlayer inventoryPlayer, TileEntityMixer tile) {
        super(new ContainerMixer(inventoryPlayer, tile));
        this.tile = tile;
        this.ySize = 167;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButtonState(0, this.guiLeft + 106, this.guiTop + 61, 30, 16, null, this.tile.outputAll, "immersiveengineering:textures/gui/mixer.png", 176, 82, 1));
    }

    protected void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tile.outputAll = ((GuiButtonState)button).state;
            tag.setBoolean("outputAll", this.tile.outputAll);
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            this.initGui();
        }
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx >= this.guiLeft + 76 && mx <= this.guiLeft + 134 && my >= this.guiTop + 11 && my <= this.guiTop + 58) {
            float capacity = this.tile.tank.getCapacity();
            int yy = this.guiTop + 58;
            if (this.tile.tank.getFluidTypes() == 0) {
                tooltip.add(I18n.format((String)"gui.immersiveengineering.empty", (Object[])new Object[0]));
            } else {
                for (int i = this.tile.tank.getFluidTypes() - 1; i >= 0; --i) {
                    int fluidHeight;
                    FluidStack fs = this.tile.tank.fluids.get(i);
                    if (fs == null || fs.getFluid() == null || my < (yy -= (fluidHeight = (int)(47.0f * ((float)fs.amount / capacity)))) || my >= yy + fluidHeight) continue;
                    ClientUtils.addFluidTooltip(fs, tooltip, (int)capacity);
                }
            }
        }
        if (mx >= this.guiLeft + 158 && mx < this.guiLeft + 165 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        if (mx >= this.guiLeft + 106 && mx <= this.guiLeft + 136 && my >= this.guiTop + 61 && my <= this.guiTop + 77) {
            tooltip.add(I18n.format((String)("gui.immersiveengineering.config.mixer.output" + (this.tile.outputAll ? "All" : "Single")), (Object[])new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/mixer.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
            float mod = 1.0f - (float)process.processTick / (float)process.maxTicks;
            for (int slot : ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process).getInputSlots()) {
                int h = (int)Math.max(1.0f, mod * 16.0f);
                this.drawTexturedModalRect(this.guiLeft + 24 + slot % 2 * 21, this.guiTop + 7 + slot / 2 * 18 + (16 - h), 176, 16 - h, 2, h);
            }
        }
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 158, this.guiTop + 22 + (46 - stored), this.guiLeft + 165, this.guiTop + 68, -4909824, -10482944);
        float capacity = this.tile.tank.getCapacity();
        int yy = this.guiTop + 58;
        for (int i = this.tile.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = this.tile.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            int fluidHeight = (int)(47.0f * ((float)fs.amount / capacity));
            ClientUtils.drawRepeatedFluidSprite(fs, this.guiLeft + 76, yy -= fluidHeight, 58.0f, fluidHeight);
        }
    }
}

