/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.GuiSorter;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityFluidSorter;
import blusunrize.immersiveengineering.common.gui.ContainerFluidSorter;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class GuiFluidSorter
extends GuiIEContainerBase {
    TileEntityFluidSorter tile;
    InventoryPlayer playerInventory;

    public GuiFluidSorter(InventoryPlayer inventoryPlayer, TileEntityFluidSorter tile) {
        super(new ContainerFluidSorter(inventoryPlayer, tile));
        this.tile = tile;
        this.playerInventory = inventoryPlayer;
        this.ySize = 244;
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        for (GuiButton button : this.buttonList) {
            if (!(button instanceof GuiSorter.ButtonSorter) || mx <= button.x || mx >= button.x + 18 || my <= button.y || my >= button.y + 18) continue;
            int type = ((GuiSorter.ButtonSorter)button).type;
            String[] split = I18n.format((String)"desc.immersiveengineering.info.filter.nbt", (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                tooltip.add((i == 0 ? TextFormatting.WHITE : TextFormatting.GRAY) + split[i]);
            }
        }
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                if (this.tile.filters[side][i] == null) continue;
                int x = this.guiLeft + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.guiTop + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (mx <= x || mx >= x + 16 || my <= y || my >= y + 16) continue;
                ClientUtils.addFluidTooltip(this.tile.filters[side][i], tooltip, 0);
            }
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        for (int side = 0; side < 6; ++side) {
            for (int i = 0; i < 8; ++i) {
                FluidStack fs;
                int x = this.guiLeft + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.guiTop + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                this.tile.filters[side][i] = fs = FluidUtil.getFluidContained((ItemStack)this.playerInventory.getItemStack());
                NBTTagCompound tag = new NBTTagCompound();
                tag.setInteger("filter_side", side);
                tag.setInteger("filter_slot", i);
                if (fs != null) {
                    tag.setTag("filter", (NBTBase)fs.writeToNBT(new NBTTagCompound()));
                }
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            }
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (int side = 0; side < 6; ++side) {
            ClientUtils.bindAtlas();
            for (int i = 0; i < 8; ++i) {
                TextureAtlasSprite sprite;
                if (this.tile.filters[side][i] == null || (sprite = ClientUtils.getSprite(this.tile.filters[side][i].getFluid().getStill(this.tile.filters[side][i]))) == null) continue;
                int x = this.guiLeft + 4 + side / 2 * 58 + (i < 3 ? i * 18 : (i > 4 ? (i - 5) * 18 : (i == 3 ? 0 : 36)));
                int y = this.guiTop + 22 + side % 2 * 76 + (i < 3 ? 0 : (i > 4 ? 36 : 18));
                int col = this.tile.filters[side][i].getFluid().getColor(this.tile.filters[side][i]);
                GlStateManager.color((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
                ClientUtils.drawTexturedRect((float)x, (float)y, 16.0f, 16.0f, sprite.getMinU(), sprite.getMaxU(), sprite.getMinV(), sprite.getMaxV());
            }
            int x = this.guiLeft + 30 + side / 2 * 58;
            int y = this.guiTop + 44 + side % 2 * 76;
            String s = I18n.format((String)("desc.immersiveengineering.info.blockSide." + EnumFacing.getFront((int)side).toString()), (Object[])new Object[0]).substring(0, 1);
            GL11.glEnable((int)3042);
            ClientUtils.font().drawString(s, (float)(x - ClientUtils.font().getStringWidth(s) / 2), (float)y, -1429418804, true);
        }
        ClientUtils.bindTexture("immersiveengineering:textures/gui/sorter.png");
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        for (int side = 0; side < 6; ++side) {
            int x = this.guiLeft + 21 + side / 2 * 58;
            int y = this.guiTop + 3 + side % 2 * 76;
            GuiSorter.ButtonSorter b = new GuiSorter.ButtonSorter(side, x, y, 1);
            b.active = this.tile.doNBT(side);
            this.buttonList.add(b);
        }
    }

    protected void actionPerformed(GuiButton button) {
        if (button instanceof GuiSorter.ButtonSorter && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            int side = button.id;
            this.tile.sortWithNBT[side] = (byte)(this.tile.sortWithNBT[side] != 1 ? 1 : 0);
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByteArray("sideConfig", this.tile.sortWithNBT);
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
            this.initGui();
        }
    }
}

