/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBelljar;
import blusunrize.immersiveengineering.common.gui.ContainerBelljar;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.IFluidTank;

public class GuiBelljar
extends GuiIEContainerBase {
    TileEntityBelljar tile;

    public GuiBelljar(InventoryPlayer inventoryPlayer, TileEntityBelljar tile) {
        super(new ContainerBelljar(inventoryPlayer, tile));
        this.tile = tile;
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tank, this.guiLeft + 8, this.guiTop + 8, 16, 47, 176, 30, 20, 51, mx, my, "immersiveengineering:textures/gui/belljar.png", tooltip);
        if (mx > this.guiLeft + 30 && mx < this.guiLeft + 37 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(I18n.format((String)"desc.immersiveengineering.info.fertFill", (Object[])new Object[]{Utils.formatDouble((float)this.tile.fertilizerAmount / (float)Config.IEConfig.Machines.belljar_fertilizer, "0.00")}));
            tooltip.add(I18n.format((String)"desc.immersiveengineering.info.fertMod", (Object[])new Object[]{Utils.formatDouble(this.tile.fertilizerMod, "0.00")}));
        }
        if (mx > this.guiLeft + 158 && mx < this.guiLeft + 165 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        ClientUtils.bindTexture("immersiveengineering:textures/gui/belljar.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.disableBlend();
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tank, this.guiLeft + 8, this.guiTop + 8, 16, 47, 176, 30, 20, 51, mx, my, "immersiveengineering:textures/gui/belljar.png", null);
        int stored = (int)(46.0f * ((float)this.tile.fertilizerAmount / (float)Config.IEConfig.Machines.belljar_fertilizer));
        ClientUtils.drawGradientRect(this.guiLeft + 30, this.guiTop + 22 + (46 - stored), this.guiLeft + 37, this.guiTop + 68, -6951680, -7710208);
        stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 158, this.guiTop + 22 + (46 - stored), this.guiLeft + 165, this.guiTop + 68, -4909824, -10482944);
    }
}

