/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonItem;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAutoWorkbench;
import blusunrize.immersiveengineering.common.gui.ContainerAutoWorkbench;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiAutoWorkbench
extends GuiIEContainerBase {
    TileEntityAutoWorkbench tile;
    NBTTagCompound lastMessage;

    public GuiAutoWorkbench(InventoryPlayer inventoryPlayer, TileEntityAutoWorkbench tile) {
        super(new ContainerAutoWorkbench(inventoryPlayer, tile));
        this.tile = tile;
        this.ySize = 184;
    }

    public void initGui() {
        BlueprintCraftingRecipe[] recipes;
        this.buttonList.clear();
        super.initGui();
        Slot s = this.inventorySlots.getSlot(0);
        if (s != null && s.getHasStack() && s.getStack().getItem() instanceof ItemEngineersBlueprint && (recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(s.getStack(), "blueprint"))) != null && recipes.length > 0) {
            int l = recipes.length;
            int xx = this.guiLeft + 121;
            int yy = this.guiTop + (l > 6 ? 59 - (l - 3) / 3 * 18 : (l > 3 ? 59 : 68));
            for (int i = 0; i < l; ++i) {
                if (recipes[i] == null || recipes[i].output.isEmpty()) continue;
                this.buttonList.add(new GuiButtonItem(i, xx + i % 3 * 18, yy + i / 3 * 18, recipes[i].output.copy(), i == this.tile.selectedRecipe));
            }
        }
    }

    protected void actionPerformed(GuiButton button) throws IOException {
        if (button instanceof GuiButtonItem) {
            this.tile.selectedRecipe = button.id == this.tile.selectedRecipe ? -1 : button.id;
            NBTTagCompound message = new NBTTagCompound();
            message.setInteger("recipe", this.tile.selectedRecipe);
            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, message));
            this.initGui();
        }
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        Slot s = this.inventorySlots.getSlot(0);
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx > this.guiLeft + 80 && mx < this.guiLeft + 87 && my > this.guiTop + 36 && my < this.guiTop + 82) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/auto_workbench.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 80, this.guiTop + 36 + (46 - stored), this.guiLeft + 87, this.guiTop + 82, -4909824, -10482944);
    }
}

