/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.gui.ContainerAssembler;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiAssembler
extends GuiIEContainerBase {
    static final String texture = "immersiveengineering:textures/gui/assembler.png";
    public TileEntityAssembler tile;

    public GuiAssembler(InventoryPlayer inventoryPlayer, TileEntityAssembler tile) {
        super(new ContainerAssembler(inventoryPlayer, tile));
        this.tile = tile;
        this.xSize = 230;
        this.ySize = 218;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButtonIE(0, this.guiLeft + 11, this.guiTop + 67, 10, 10, null, texture, 230, 50).setHoverOffset(0, 10));
        this.buttonList.add(new GuiButtonIE(1, this.guiLeft + 69, this.guiTop + 67, 10, 10, null, texture, 230, 50).setHoverOffset(0, 10));
        this.buttonList.add(new GuiButtonIE(2, this.guiLeft + 127, this.guiTop + 67, 10, 10, null, texture, 230, 50).setHoverOffset(0, 10));
        this.buttonList.add(new GuiButtonState(3, this.guiLeft + 162, this.guiTop + 69, 16, 16, null, this.tile.recursiveIngredients, texture, 240, 66, 3));
    }

    protected void actionPerformed(GuiButton button) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("buttonID", button.id);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
        if (button.id == 3) {
            this.tile.recursiveIngredients = !this.tile.recursiveIngredients;
            this.initGui();
        }
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx >= this.guiLeft + 187 && mx < this.guiLeft + 194 && my >= this.guiTop + 12 && my < this.guiTop + 59) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[0], this.guiLeft + 204, this.guiTop + 13, 16, 46, 250, 0, 20, 50, mx, my, texture, tooltip);
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[1], this.guiLeft + 182, this.guiTop + 70, 16, 46, 250, 0, 20, 50, mx, my, texture, tooltip);
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[2], this.guiLeft + 204, this.guiTop + 70, 16, 46, 250, 0, 20, 50, mx, my, texture, tooltip);
        for (int i = 0; i < this.tile.patterns.length; ++i) {
            if (!((ItemStack)this.tile.inventory.get(18 + i)).isEmpty() || ((ItemStack)this.tile.patterns[i].inv.get(9)).isEmpty() || mx < this.guiLeft + 27 + i * 58 || mx >= this.guiLeft + 43 + i * 58 || my < this.guiTop + 64 || my >= this.guiTop + 80) continue;
            tooltip.add(((ItemStack)this.tile.patterns[i].inv.get(9)).getDisplayName());
            ((ItemStack)this.tile.patterns[i].inv.get(9)).getItem().addInformation((ItemStack)this.tile.patterns[i].inv.get(9), (World)ClientUtils.mc().world, tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            for (int j = 0; j < tooltip.size(); ++j) {
                tooltip.set(j, (j == 0 ? ((ItemStack)this.tile.patterns[i].inv.get((int)9)).getRarity().rarityColor : TextFormatting.GRAY) + tooltip.get(j));
            }
        }
        if ((mx >= this.guiLeft + 11 && mx < this.guiLeft + 21 || mx >= this.guiLeft + 69 && mx < this.guiLeft + 79 || mx >= this.guiLeft + 127 && mx < this.guiLeft + 137) && my > this.guiTop + 67 && my < this.guiTop + 77) {
            tooltip.add(I18n.format((String)"gui.immersiveengineering.config.assembler.clearRecipe", (Object[])new Object[0]));
        }
        if (mx >= this.guiLeft + 162 && mx < this.guiLeft + 178 && my > this.guiTop + 69 && my < this.guiTop + 85) {
            tooltip.add(I18n.format((String)("gui.immersiveengineering.config.assembler." + (this.tile.recursiveIngredients ? "recursiveIngredients" : "nonRecursiveIngredients")), (Object[])new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture(texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 187, this.guiTop + 13 + (46 - stored), this.guiLeft + 194, this.guiTop + 59, -4909824, -10482944);
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[0], this.guiLeft + 204, this.guiTop + 13, 16, 46, 230, 0, 20, 50, mx, my, texture, null);
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[1], this.guiLeft + 182, this.guiTop + 70, 16, 46, 230, 0, 20, 50, mx, my, texture, null);
        ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[2], this.guiLeft + 204, this.guiTop + 70, 16, 46, 230, 0, 20, 50, mx, my, texture, null);
        for (int i = 0; i < this.tile.patterns.length; ++i) {
            if (!((ItemStack)this.tile.inventory.get(18 + i)).isEmpty() || ((ItemStack)this.tile.patterns[i].inv.get(9)).isEmpty()) continue;
            ItemStack stack = (ItemStack)this.tile.patterns[i].inv.get(9);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.disableStandardItemLighting();
            this.zLevel = 200.0f;
            this.itemRender.zLevel = 200.0f;
            FontRenderer font = null;
            if (!stack.isEmpty()) {
                font = stack.getItem().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.fontRenderer;
            }
            this.itemRender.renderItemAndEffectIntoGUI(stack, this.guiLeft + 27 + i * 58, this.guiTop + 64);
            this.itemRender.renderItemOverlayIntoGUI(font, stack, this.guiLeft + 27 + i * 58, this.guiTop + 64, TextFormatting.GRAY.toString() + stack.getCount());
            this.zLevel = 0.0f;
            this.itemRender.zLevel = 0.0f;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            ClientUtils.drawColouredRect(this.guiLeft + 27 + i * 58, this.guiTop + 64, 16, 16, 0x77444444);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }
}

