/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.gui.ContainerArcFurnace;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiArcFurnace
extends GuiIEContainerBase {
    TileEntityArcFurnace tile;

    public GuiArcFurnace(InventoryPlayer inventoryPlayer, TileEntityArcFurnace tile) {
        super(new ContainerArcFurnace(inventoryPlayer, tile));
        this.ySize = 207;
        this.tile = tile;
    }

    @Override
    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx > this.guiLeft + 157 && mx < this.guiLeft + 164 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " RF");
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRenderer, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/arc_furnace.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof TileEntityMultiblockMetal.MultiblockProcessInMachine)) continue;
            float mod = (float)process.processTick / (float)process.maxTicks;
            int slot = ((TileEntityMultiblockMetal.MultiblockProcessInMachine)process).getInputSlots()[0];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            this.drawTexturedModalRect(this.guiLeft + 27 + slot % 3 * 21, this.guiTop + 34 + slot / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.guiLeft + 157, this.guiTop + 22 + (46 - stored), this.guiLeft + 164, this.guiTop + 68, -4909824, -10482944);
    }
}

