/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleFluidSplash
extends Particle {
    public ParticleFluidSplash(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.motionX *= (double)0.3f;
        this.motionY = Math.random() * (double)0.2f + (double)0.1f;
        this.motionZ *= (double)0.3f;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.setSize(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleScale = 0.375f;
        this.setParticleTexture(ClientUtils.getSprite(FluidRegistry.WATER.getStill()));
    }

    public void onUpdate() {
        BlockPos blockpos;
        IBlockState iblockstate;
        Material material;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)this.particleGravity;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setExpired();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.setExpired();
            }
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if ((material = (iblockstate = this.world.getBlockState(blockpos = new BlockPos(this.posX, this.posY, this.posZ))).getMaterial()).isLiquid() || material.isSolid()) {
            double d0 = iblockstate.getBlock() instanceof BlockLiquid ? (double)(1.0f - BlockLiquid.getLiquidHeightPercent((int)((Integer)iblockstate.getValue((IProperty)BlockLiquid.LEVEL)))) : iblockstate.getBoundingBox((IBlockAccess)this.world, (BlockPos)blockpos).maxY;
            double d1 = (double)MathHelper.floor((double)this.posY) + d0;
            if (this.posY < d1) {
                this.setExpired();
            }
        }
    }

    public void setFluidTexture(FluidStack fluid) {
        this.setParticleTexture(ClientUtils.getSprite(fluid.getFluid().getStill(fluid)));
        int argb = fluid.getFluid().getColor(fluid);
        this.particleAlpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.particleRed = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.particleRed = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.particleRed = (float)(argb & 0xFF) / 255.0f;
    }

    public int getFXLayer() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle createParticle(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleFluidSplash(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        }
    }
}

