/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.models.IESmartObjModel;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ImmersiveModelRegistry {
    public static ImmersiveModelRegistry instance = new ImmersiveModelRegistry();
    private static final ImmutableMap<String, String> flipData = ImmutableMap.of((Object)"flip-v", (Object)String.valueOf(true));
    private HashMap<ModelResourceLocation, ItemModelReplacement> itemModelReplacements = new HashMap();

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, ItemModelReplacement> entry : this.itemModelReplacements.entrySet()) {
            Object object = event.getModelRegistry().getObject((Object)entry.getKey());
            if (!(object instanceof IBakedModel)) continue;
            try {
                IBakedModel existingModel = (IBakedModel)object;
                event.getModelRegistry().putObject((Object)entry.getKey(), (Object)entry.getValue().createBakedModel(existingModel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ModelResourceLocation mLoc = new ModelResourceLocation(new ResourceLocation("immersiveengineering", IEContent.itemCoresample.itemName), "inventory");
        event.getModelRegistry().putObject((Object)mLoc, (Object)new ModelCoresample());
        ConveyorHandler.IConveyorBelt belt = ConveyorHandler.getConveyor(new ResourceLocation("immersiveengineering", "conveyor"), null);
        ModelConveyor modelConveyor = new ModelConveyor(belt);
        mLoc = new ModelResourceLocation(new ResourceLocation("immersiveengineering", "conveyor"), "normal");
        event.getModelRegistry().putObject((Object)mLoc, (Object)modelConveyor);
        mLoc = new ModelResourceLocation(new ResourceLocation("immersiveengineering", "conveyor"), "inventory");
        event.getModelRegistry().putObject((Object)mLoc, (Object)modelConveyor);
    }

    public void registerCustomItemModel(ItemStack stack, ItemModelReplacement replacement) {
        if (stack.getItem() instanceof ItemIEBase) {
            ResourceLocation loc = ((ItemIEBase)stack.getItem()).getSubNames() != null && ((ItemIEBase)stack.getItem()).getSubNames().length > 0 ? new ResourceLocation("immersiveengineering", ((ItemIEBase)stack.getItem()).itemName + "/" + ((ItemIEBase)stack.getItem()).getSubNames()[stack.getItemDamage()]) : new ResourceLocation("immersiveengineering", ((ItemIEBase)stack.getItem()).itemName);
            this.itemModelReplacements.put(new ModelResourceLocation(loc, "inventory"), replacement);
        }
    }

    public static class ItemModelReplacement_OBJ
    extends ItemModelReplacement {
        String objPath;
        HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap = new HashMap();

        public ItemModelReplacement_OBJ(String path) {
            this.objPath = path;
            for (ItemCameraTransforms.TransformType t : ItemCameraTransforms.TransformType.values()) {
                this.transformationMap.put(t, new Matrix4());
            }
        }

        public ItemModelReplacement_OBJ setTransformations(ItemCameraTransforms.TransformType type, Matrix4 matrix) {
            this.transformationMap.put(type, matrix);
            return this;
        }

        @Override
        public IBakedModel createBakedModel(IBakedModel existingModel) {
            try {
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(location.toString());
                    }
                };
                ResourceLocation modelLocation = new ResourceLocation(this.objPath);
                OBJModel objModel = (OBJModel)OBJLoader.INSTANCE.loadModel(modelLocation);
                objModel = (OBJModel)objModel.process(flipData);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
                TextureAtlasSprite missing = (TextureAtlasSprite)textureGetter.apply((Object)new ResourceLocation("missingno"));
                for (String s : objModel.getMatLib().getMaterialNames()) {
                    if (objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().getResourcePath().startsWith("#")) {
                        FMLLog.severe((String)"OBJLoader: Unresolved texture '%s' for obj model '%s'", (Object[])new Object[]{objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().getResourcePath(), modelLocation});
                        builder.put((Object)s, (Object)missing);
                        continue;
                    }
                    builder.put((Object)s, textureGetter.apply((Object)objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation()));
                }
                return new IESmartObjModel(existingModel, objModel, (IModelState)new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"}), true), DefaultVertexFormats.ITEM, (ImmutableMap<String, TextureAtlasSprite>)builder.build(), this.transformationMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static abstract class ItemModelReplacement {
        public abstract IBakedModel createBakedModel(IBakedModel var1);
    }
}

