/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiBlastFurnace;
import blusunrize.immersiveengineering.client.gui.GuiToolbox;
import blusunrize.immersiveengineering.client.render.TileRenderAutoWorkbench;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySampleDrill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityTurntable;
import blusunrize.immersiveengineering.common.gui.ContainerRevolver;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemChemthrower;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemEarmuffs;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.items.ItemFluorescentTube;
import blusunrize.immersiveengineering.common.items.ItemIEShield;
import blusunrize.immersiveengineering.common.items.ItemRailgun;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.items.ItemSpeedloader;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.network.MessageChemthrowerSwitch;
import blusunrize.immersiveengineering.common.util.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.util.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledSound;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledTickableSound;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GLContext;

public class ClientEventHandler
implements IResourceManagerReloadListener {
    private boolean shieldToggleButton = false;
    private int shieldToggleTimer = 0;
    public static Set<ImmersiveNetHandler.Connection> skyhookGrabableConnections = new HashSet<ImmersiveNetHandler.Connection>();
    private static double[][] rotationArrowCoords = new double[][]{{0.375, 0.0}, {0.5, -0.125}, {0.4375, -0.125}, {0.4375, -0.25}, {0.25, -0.4375}, {-0.25, -0.4375}, {-0.4375, -0.25}, {-0.4375, -0.0625}, {-0.3125, -0.0625}, {-0.3125, -0.1875}, {-0.1875, -0.3125}, {0.1875, -0.3125}, {0.3125, -0.1875}, {0.3125, -0.125}, {0.25, -0.125}};
    private static double[][] rotationArrowQuads = new double[][]{rotationArrowCoords[7], rotationArrowCoords[8], rotationArrowCoords[6], rotationArrowCoords[9], rotationArrowCoords[5], rotationArrowCoords[10], rotationArrowCoords[4], rotationArrowCoords[11], rotationArrowCoords[3], rotationArrowCoords[12], rotationArrowCoords[2], rotationArrowCoords[13], rotationArrowCoords[1], rotationArrowCoords[14], rotationArrowCoords[0], rotationArrowCoords[0]};
    private static float[][] arrowCoords = new float[][]{{0.0f, 0.375f}, {0.3125f, 0.0625f}, {0.125f, 0.0625f}, {0.125f, -0.375f}, {-0.125f, -0.375f}, {-0.125f, 0.0625f}, {-0.3125f, 0.0625f}};

    public void onResourceManagerReload(IResourceManager resourceManager) {
        TextureMap texturemap = Minecraft.getMinecraft().getTextureMapBlocks();
        for (int i = 0; i < ClientUtils.destroyBlockIcons.length; ++i) {
            ClientUtils.destroyBlockIcons[i] = texturemap.getAtlasSprite("minecraft:blocks/destroy_stage_" + i);
        }
        ImmersiveEngineering.proxy.clearRenderCaches();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.side.isClient() && event.phase == TickEvent.Phase.START && event.player != null && event.player == ClientUtils.mc().getRenderViewEntity()) {
            skyhookGrabableConnections.clear();
            player = event.player;
            ItemStack stack = player.getActiveItemStack();
            if (!stack.isEmpty() && stack.getItem() instanceof ItemSkyhook) {
                TileEntity connector = null;
                double lastDist = 0.0;
                ImmersiveNetHandler.Connection line = null;
                double py = player.posY + (double)player.getEyeHeight();
                BlockPos pos = new BlockPos(player.posX, player.posY, player.posZ);
                for (int xx = -2; xx <= 2; ++xx) {
                    for (int zz = -2; zz <= 2; ++zz) {
                        for (int yy = 0; yy <= 3; ++yy) {
                            ImmersiveNetHandler.Connection con;
                            TileEntity tile = player.world.getTileEntity(pos.add(xx, yy, zz));
                            if (tile == null || (con = SkylineHelper.getTargetConnection(player.world, pos.add(xx, yy, zz), (EntityLivingBase)player, null)) == null) continue;
                            double d = tile.getDistanceSq(player.posX, py, player.posZ);
                            if (connector != null && !(d < lastDist)) continue;
                            connector = tile;
                            lastDist = d;
                            line = con;
                        }
                    }
                }
                if (line != null && connector != null) {
                    skyhookGrabableConnections.add(line);
                }
            }
        }
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player != null) {
            ItemStack held;
            if (this.shieldToggleTimer > 0) {
                --this.shieldToggleTimer;
            }
            if (ClientProxy.keybind_magnetEquip.isKeyDown() && !this.shieldToggleButton) {
                if (this.shieldToggleTimer <= 0) {
                    this.shieldToggleTimer = 7;
                } else {
                    player = event.player;
                    ItemStack held2 = player.getHeldItem(EnumHand.OFF_HAND);
                    if (!held2.isEmpty() && held2.getItem() instanceof ItemIEShield) {
                        if (((ItemIEShield)held2.getItem()).getUpgrades(held2).getBoolean("magnet") && ((ItemIEShield)held2.getItem()).getUpgrades(held2).hasKey("prevSlot")) {
                            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageMagnetEquip(player.getName(), -1));
                        }
                    } else {
                        for (int i = 0; i < player.inventory.mainInventory.size(); ++i) {
                            ItemStack s = (ItemStack)player.inventory.mainInventory.get(i);
                            if (s.isEmpty() || !(s.getItem() instanceof ItemIEShield) || !((ItemIEShield)s.getItem()).getUpgrades(s).getBoolean("magnet")) continue;
                            ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageMagnetEquip(player.getName(), i));
                        }
                    }
                }
            }
            if (this.shieldToggleButton != ClientUtils.mc().gameSettings.keyBindBack.isKeyDown()) {
                this.shieldToggleButton = ClientUtils.mc().gameSettings.keyBindBack.isKeyDown();
            }
            if (ClientProxy.keybind_chemthrowerSwitch.isPressed() && (held = event.player.getHeldItem(EnumHand.MAIN_HAND)).getItem() instanceof ItemChemthrower && ((ItemChemthrower)held.getItem()).getUpgrades(held).getBoolean("multitank")) {
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageChemthrowerSwitch(event.player.getName(), true));
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack powerpack;
        ItemStack earmuffs;
        if (event.getItemStack() == null || event.getItemStack().isEmpty()) {
            return;
        }
        if (event.getItemStack().hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            ItemStack shader;
            CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)event.getItemStack().getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            ItemStack itemStack = shader = wrapper != null ? wrapper.getShaderItem() : null;
            if (!shader.isEmpty()) {
                event.getToolTip().add(TextFormatting.DARK_GRAY + shader.getDisplayName());
            }
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Earmuffs") && !(earmuffs = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Earmuffs")).isEmpty()) {
            event.getToolTip().add(TextFormatting.GRAY + earmuffs.getDisplayName());
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Powerpack")).isEmpty()) {
            event.getToolTip().add(TextFormatting.GRAY + powerpack.getDisplayName());
            event.getToolTip().add(TextFormatting.GRAY.toString() + EnergyHelper.getEnergyStored(powerpack) + "/" + EnergyHelper.getMaxEnergyStored(powerpack) + " IF");
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && ClientUtils.mc().currentScreen != null && ClientUtils.mc().currentScreen instanceof GuiBlastFurnace && BlastFurnaceRecipe.isValidBlastFuel(event.getItemStack())) {
            event.getToolTip().add(TextFormatting.GRAY + I18n.format((String)"desc.immersiveengineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceRecipe.getBlastFuelTime(event.getItemStack())}));
        }
        if (Config.IEConfig.oreTooltips && event.getFlags().isAdvanced()) {
            for (int oid : OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                event.getToolTip().add(TextFormatting.GRAY + OreDictionary.getOreName((int)oid));
            }
        }
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getSound() == null || event.getSound().getCategory() == null) {
            return;
        }
        if (!ItemEarmuffs.affectedSoundCategories.contains(event.getSound().getCategory().getName())) {
            return;
        }
        if (ClientUtils.mc().player != null && !ClientUtils.mc().player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).isEmpty()) {
            ItemStack earmuffs = ClientUtils.mc().player.getItemStackFromSlot(EntityEquipmentSlot.HEAD);
            if (ItemNBTHelper.hasKey(earmuffs, "IE:Earmuffs")) {
                earmuffs = ItemNBTHelper.getItemStack(earmuffs, "IE:Earmuffs");
            }
            if (!earmuffs.isEmpty() && IEContent.itemEarmuffs.equals(earmuffs.getItem()) && !ItemNBTHelper.getBoolean(earmuffs, "IE:Earmuffs:Cat_" + event.getSound().getCategory().getName())) {
                BlockPos pos;
                for (String blacklist : Config.IEConfig.Tools.earDefenders_SoundBlacklist) {
                    if (blacklist == null || !blacklist.equalsIgnoreCase(event.getSound().getSoundLocation().toString())) continue;
                    return;
                }
                if (event.getSound() instanceof ITickableSound) {
                    event.setResultSound((ISound)new IEMuffledTickableSound((ITickableSound)event.getSound(), ItemEarmuffs.getVolumeMod(earmuffs)));
                } else {
                    event.setResultSound((ISound)new IEMuffledSound(event.getSound(), ItemEarmuffs.getVolumeMod(earmuffs)));
                }
                if (event.getSound() instanceof PositionedSoundRecord && ClientUtils.mc().renderGlobal.mapSoundPositions.containsKey(pos = new BlockPos((double)event.getSound().getXPosF(), (double)event.getSound().getYPosF(), (double)event.getSound().getZPosF()))) {
                    ClientUtils.mc().renderGlobal.mapSoundPositions.put(pos, event.getResultSound());
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        BlueprintCraftingRecipe[] recipes;
        double playerDistanceSq;
        if (!event.getItem().isEmpty() && event.getItem().getItem() instanceof ItemEngineersBlueprint && (playerDistanceSq = ClientUtils.mc().player.getDistanceSq(event.getEntityItemFrame().getPosition())) < 1000.0 && (recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(event.getItem(), "blueprint"))) != null && recipes.length > 0) {
            TileRenderAutoWorkbench.BlueprintLines blueprint;
            int i = event.getEntityItemFrame().getRotation();
            BlueprintCraftingRecipe recipe = recipes[i % recipes.length];
            TileRenderAutoWorkbench.BlueprintLines blueprintLines = blueprint = recipe == null ? null : TileRenderAutoWorkbench.getBlueprintDrawable(recipe, event.getEntityItemFrame().getEntityWorld());
            if (blueprint != null) {
                GlStateManager.rotate((float)((float)(-i) * 45.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                ClientUtils.bindTexture("immersiveengineering:textures/models/blueprint_frame.png");
                GlStateManager.translate((double)-0.5, (double)0.5, (double)-0.001);
                ClientUtils.drawTexturedRect(0.125f, -0.875f, 0.75f, 0.75f, 1.0, 0.0, 1.0, 0.0);
                float lineWidth = playerDistanceSq < 3.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                GlStateManager.translate((double)0.75, (double)-0.25, (double)-0.002);
                GlStateManager.disableCull();
                GlStateManager.disableTexture2D();
                GlStateManager.enableBlend();
                float scale = 0.0375f / ((float)blueprint.getTextureScale() / 16.0f);
                GlStateManager.scale((float)(-scale), (float)(-scale), (float)scale);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                blueprint.draw(lineWidth);
                GlStateManager.scale((float)(1.0f / scale), (float)(-1.0f / scale), (float)(1.0f / scale));
                GlStateManager.enableAlpha();
                GlStateManager.enableTexture2D();
                GlStateManager.enableCull();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (ZoomHandler.isZooming && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                ClientUtils.bindTexture("immersiveengineering:textures/gui/scope.png");
                int width = event.getResolution().getScaledWidth();
                int height = event.getResolution().getScaledHeight();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientUtils.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216);
                    ClientUtils.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216);
                } else {
                    ClientUtils.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216);
                    ClientUtils.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216);
                }
                GlStateManager.enableBlend();
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                GlStateManager.translate((float)offsetX, (float)offsetY, (float)0.0f);
                ClientUtils.drawTexturedRect(0.0f, 0.0f, (float)resMin, (float)resMin, 0.0, 1.0, 0.0, 1.0);
                ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
                ClientUtils.drawTexturedRect(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 0.25, 0.34375, 0.375, 0.875);
                ItemStack equipped = ClientUtils.mc().player.getHeldItem(EnumHand.MAIN_HAND);
                if (!equipped.isEmpty() && equipped.getItem() instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)equipped.getItem()).getZoomSteps(equipped, (EntityPlayer)ClientUtils.mc().player)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    GlStateManager.translate((float)(0.87109375f * (float)resMin), (float)(0.25f * (float)resMin), (float)0.0f);
                    GlStateManager.translate((float)0.0f, (float)((5.0f + stepOffset) / 256.0f * (float)resMin), (float)0.0f);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.375, 0.375, 0.40234375);
                        GlStateManager.translate((float)0.0f, (float)(stepLength / 256.0f * (float)resMin), (float)0.0f);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    GlStateManager.translate((float)0.0f, (float)(-totalOffset / 256.0f * (float)resMin), (float)0.0f);
                    if (curStep >= 0 && curStep < steps.length) {
                        GlStateManager.translate((float)(0.0234375f * (float)resMin), (float)((float)curStep * stepLength / 256.0f * (float)resMin), (float)0.0f);
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.3828125, 0.40234375, 0.4296875);
                        ClientUtils.font().drawString(1.0f / steps[curStep] + "x", (int)(0.0625f * (float)resMin), 0, 0xFFFFFF);
                        GlStateManager.translate((float)(-0.0234375f * (float)resMin), (float)((float)(-curStep) * stepLength / 256.0f * (float)resMin), (float)0.0f);
                    }
                    GlStateManager.translate((float)0.0f, (float)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), (float)0.0f);
                    GlStateManager.translate((float)(-0.87109375f * (float)resMin), (float)(-0.25f * (float)resMin), (float)0.0f);
                }
                GlStateManager.translate((float)(-offsetX), (float)(-offsetY), (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        if (ClientUtils.mc().player != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            EntityPlayerSP player = ClientUtils.mc().player;
            for (EnumHand hand : EnumHand.values()) {
                RayTraceResult mop;
                NBTTagCompound upgrades;
                if (player.getHeldItem(hand).isEmpty()) continue;
                ItemStack equipped = player.getHeldItem(hand);
                if (OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)false) || equipped.getItem() instanceof IWireCoil) {
                    int[] link;
                    if (ItemNBTHelper.hasKey(equipped, "linkingPos") && (link = ItemNBTHelper.getIntArray(equipped, "linkingPos")) != null && link.length > 3) {
                        int max;
                        RayTraceResult rtr;
                        double d;
                        String s = I18n.format((String)"desc.immersiveengineering.info.attachedTo", (Object[])new Object[]{link[1], link[2], link[3]});
                        int col = WireType.ELECTRUM.getColour(null);
                        if (equipped.getItem() instanceof IWireCoil && (d = (rtr = ClientUtils.mc().objectMouseOver) != null && rtr.getBlockPos() != null ? rtr.getBlockPos().distanceSq((double)link[1], (double)link[2], (double)link[3]) : player.getDistanceSq((double)link[1], (double)link[2], (double)link[3])) > (double)((max = ((IWireCoil)equipped.getItem()).getWireType(equipped).getMaxLength()) * max)) {
                            col = 0xDD3333;
                        }
                        ClientUtils.font().drawString(s, (float)(event.getResolution().getScaledWidth() / 2 - ClientUtils.font().getStringWidth(s) / 2), (float)(event.getResolution().getScaledHeight() - GuiIngameForge.left_height - 20), col, true);
                    }
                } else if (OreDictionary.itemMatches((ItemStack)equipped, (ItemStack)new ItemStack((Item)IEContent.itemFluorescentTube), (boolean)false)) {
                    String s = I18n.format((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"#" + ItemFluorescentTube.hexColorString(equipped)});
                    ClientUtils.font().drawString(s, (float)(event.getResolution().getScaledWidth() / 2 - ClientUtils.font().getStringWidth(s) / 2), (float)(event.getResolution().getScaledHeight() - GuiIngameForge.left_height - 20), ItemFluorescentTube.getRGBInt(equipped), true);
                } else if (equipped.getItem() instanceof ItemRevolver || equipped.getItem() instanceof ItemSpeedloader) {
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/revolver.png");
                    NonNullList<ItemStack> bullets = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBullets(equipped, true);
                    if (bullets != null) {
                        float cdMax;
                        int cd;
                        float cooldown;
                        int bulletAmount = ((IEItemInterfaces.IBulletContainer)equipped.getItem()).getBulletCount(equipped);
                        EnumHandSide side = hand == EnumHand.MAIN_HAND ? player.getPrimaryHand() : player.getPrimaryHand().opposite();
                        boolean right = side == EnumHandSide.RIGHT;
                        float dx = right ? (float)(event.getResolution().getScaledWidth() - 32 - 48) : 48.0f;
                        float dy = event.getResolution().getScaledHeight() - 64;
                        GlStateManager.pushMatrix();
                        GlStateManager.enableBlend();
                        GlStateManager.translate((float)dx, (float)dy, (float)0.0f);
                        GlStateManager.scale((float)0.5f, (float)0.5f, (float)1.0f);
                        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        ClientUtils.drawTexturedRect(0.0f, 1.0f, 74.0f, 74.0f, 0.0, 0.2890625, 0.19921875, 0.48828125);
                        if (bulletAmount >= 18) {
                            ClientUtils.drawTexturedRect(47.0f, 1.0f, 103.0f, 74.0f, 0.2890625, 0.69140625, 0.19921875, 0.48828125);
                        } else if (bulletAmount > 8) {
                            ClientUtils.drawTexturedRect(57.0f, 1.0f, 79.0f, 39.0f, 0.22265625, 0.53125, 0.046875, 0.19921875);
                        }
                        RenderItem ir = ClientUtils.mc().getRenderItem();
                        int[][] slots = ContainerRevolver.slotPositions[bulletAmount >= 18 ? 2 : (bulletAmount > 8 ? 1 : 0)];
                        for (int i = 0; i < bulletAmount; ++i) {
                            ItemStack b = (ItemStack)bullets.get(i);
                            if (b.isEmpty()) continue;
                            int x = 0;
                            int y = 0;
                            if (i == 0) {
                                x = 29;
                                y = 3;
                            } else if (i - 1 < slots.length) {
                                x = slots[i - 1][0];
                                y = slots[i - 1][1];
                            } else {
                                int ii = i - (slots.length + 1);
                                int n = ii == 0 ? 48 : (ii == 1 ? 29 : (x = ii == 3 ? 2 : 10));
                                y = ii == 1 ? 57 : (ii == 3 ? 30 : (ii == 4 ? 11 : 49));
                            }
                            ir.renderItemIntoGUI(b, x, y);
                        }
                        if (equipped.getItem() instanceof ItemRevolver && (cooldown = 1.0f - (float)(cd = ((ItemRevolver)equipped.getItem()).getShootCooldown(equipped)) / (cdMax = (float)((ItemRevolver)equipped.getItem()).getMaxShootCooldown(equipped))) > 0.0f) {
                            GlStateManager.scale((float)2.0f, (float)2.0f, (float)1.0f);
                            GlStateManager.translate((float)(-dx), (float)(-dy), (float)0.0f);
                            GlStateManager.translate((float)(event.getResolution().getScaledWidth() / 2 + (right ? 1 : -6)), (float)(event.getResolution().getScaledHeight() / 2 - 7), (float)0.0f);
                            float h1 = (double)cooldown > 0.33 ? 0.5f : cooldown * 1.5f;
                            float h2 = cooldown;
                            float x2 = (double)cooldown < 0.75 ? 1.0f : 4.0f * (1.0f - cooldown);
                            float uMin = (88.0f + (right ? 0.0f : 7.0f * x2)) / 256.0f;
                            float uMax = (88.0f + (right ? 7.0f * x2 : 0.0f)) / 256.0f;
                            float vMin1 = (112.0f + (right ? h1 : h2) * 15.0f) / 256.0f;
                            float vMin2 = (112.0f + (right ? h2 : h1) * 15.0f) / 256.0f;
                            ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
                            Tessellator tessellator = Tessellator.getInstance();
                            BufferBuilder worldrenderer = tessellator.getBuffer();
                            worldrenderer.begin(7, DefaultVertexFormats.POSITION_TEX);
                            worldrenderer.pos((double)((right ? 0.0f : 1.0f - x2) * 7.0f), 15.0, 0.0).tex((double)uMin, 0.49609375).endVertex();
                            worldrenderer.pos((double)((right ? x2 : 1.0f) * 7.0f), 15.0, 0.0).tex((double)uMax, 0.49609375).endVertex();
                            worldrenderer.pos((double)((right ? x2 : 1.0f) * 7.0f), (double)((right ? h2 : h1) * 15.0f), 0.0).tex((double)uMax, (double)vMin2).endVertex();
                            worldrenderer.pos((double)((right ? 0.0f : 1.0f - x2) * 7.0f), (double)((right ? h1 : h2) * 15.0f), 0.0).tex((double)uMin, (double)vMin1).endVertex();
                            tessellator.draw();
                        }
                        RenderHelper.disableStandardItemLighting();
                        GlStateManager.disableBlend();
                        GlStateManager.popMatrix();
                    }
                } else if (equipped.getItem() instanceof ItemRailgun) {
                    int duration = 72000 - (player.isHandActive() && player.getActiveHand() == hand ? player.getItemInUseCount() : 0);
                    int chargeTime = ((ItemRailgun)equipped.getItem()).getChargeTime(equipped);
                    int chargeLevel = duration < 72000 ? Math.min(99, (int)((float)duration / (float)chargeTime * 100.0f)) : 0;
                    float scale = 2.0f;
                    GlStateManager.pushMatrix();
                    GlStateManager.translate((float)(event.getResolution().getScaledWidth() - 80), (float)(event.getResolution().getScaledHeight() - 30), (float)0.0f);
                    GlStateManager.scale((float)scale, (float)scale, (float)1.0f);
                    ClientProxy.nixieFont.drawString((chargeLevel < 10 ? "0" : "") + chargeLevel, 0.0f, 0.0f, 0xFF9900, false);
                    GlStateManager.scale((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
                    GlStateManager.popMatrix();
                } else if (equipped.getItem() instanceof ItemDrill && equipped.getItemDamage() == 0 || equipped.getItem() instanceof ItemChemthrower) {
                    IFluidTankProperties[] props;
                    boolean drill = equipped.getItem() instanceof ItemDrill;
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float dx = event.getResolution().getScaledWidth() - 16;
                    float dy = event.getResolution().getScaledHeight();
                    GlStateManager.pushMatrix();
                    GlStateManager.translate((float)dx, (float)dy, (float)0.0f);
                    int w = 31;
                    int h = 62;
                    double uMin = 0.69921875;
                    double uMax = 0.8203125;
                    double vMin = 0.03515625;
                    double vMax = 0.27734375;
                    ClientUtils.drawTexturedRect(-24.0f, -68.0f, (float)w, (float)h, uMin, uMax, vMin, vMax);
                    GlStateManager.translate((float)-23.0f, (float)-37.0f, (float)0.0f);
                    IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)equipped);
                    int capacity = -1;
                    if (handler != null && (props = handler.getTankProperties()) != null && props.length > 0) {
                        capacity = props[0].getCapacity();
                    }
                    if (capacity > -1) {
                        int amount;
                        FluidStack fuel = FluidUtil.getFluidContained((ItemStack)equipped);
                        int n = amount = fuel != null ? fuel.amount : 0;
                        if (!drill && player.isHandActive() && player.getActiveHand() == hand) {
                            int use = player.getItemInUseMaxCount();
                            amount -= use * Config.IEConfig.Tools.chemthrower_consumption;
                        }
                        float cap = capacity;
                        float angle = 83.0f - (float)(166 * amount) / cap;
                        GlStateManager.rotate((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                        ClientUtils.drawTexturedRect(6.0f, -2.0f, 24.0f, 4.0f, 0.35546875, 0.48046875, 0.3125, 0.33984375);
                        GlStateManager.rotate((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.translate((float)23.0f, (float)37.0f, (float)0.0f);
                        if (drill) {
                            ClientUtils.drawTexturedRect(-54.0f, -73.0f, 66.0f, 72.0f, 0.421875, 0.6796875, 0.015625, 0.296875);
                            RenderItem ir = ClientUtils.mc().getRenderItem();
                            ItemStack head = ((ItemDrill)equipped.getItem()).getHead(equipped);
                            if (!head.isEmpty()) {
                                ir.renderItemIntoGUI(head, -51, -45);
                                ir.renderItemOverlayIntoGUI(head.getItem().getFontRenderer(head), head, -51, -45, null);
                                RenderHelper.disableStandardItemLighting();
                            }
                        } else {
                            ClientUtils.drawTexturedRect(-41.0f, -73.0f, 53.0f, 72.0f, 0.03125, 0.23828125, 0.015625, 0.296875);
                            boolean ignite = ItemNBTHelper.getBoolean(equipped, "ignite");
                            ClientUtils.drawTexturedRect(-32.0f, -43.0f, 12.0f, 12.0f, 0.2578125, 0.3046875, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
                            ClientUtils.drawTexturedRect(-100.0f, -20.0f, 64.0f, 16.0f, 0.0, 0.25, 0.296875, 0.359375);
                            if (fuel != null) {
                                String name = ClientUtils.font().trimStringToWidth(fuel.getLocalizedName(), 50).trim();
                                ClientUtils.font().drawString(name, -68 - ClientUtils.font().getStringWidth(name) / 2, -15, 0);
                            }
                        }
                    }
                    GlStateManager.popMatrix();
                } else if (equipped.getItem() instanceof ItemIEShield && !(upgrades = ((ItemIEShield)equipped.getItem()).getUpgrades(equipped)).hasNoTags()) {
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
                    GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    boolean boundLeft = player.getPrimaryHand() == EnumHandSide.RIGHT == (hand == EnumHand.OFF_HAND);
                    float dx = boundLeft ? 16.0f : (float)(event.getResolution().getScaledWidth() - 16 - 64);
                    float dy = event.getResolution().getScaledHeight();
                    GlStateManager.pushMatrix();
                    GlStateManager.enableBlend();
                    GlStateManager.translate((float)dx, (float)dy, (float)0.0f);
                    ClientUtils.drawTexturedRect(0.0f, -22.0f, 64.0f, 22.0f, 0.0, 0.25, 0.6875, 0.7734375);
                    if (upgrades.getBoolean("flash")) {
                        ClientUtils.drawTexturedRect(11.0f, -38.0f, 16.0f, 16.0f, 0.04296875, 0.10546875, 0.625, 0.6875);
                        if (upgrades.hasKey("flash_cooldown")) {
                            float h = (float)upgrades.getInteger("flash_cooldown") / 40.0f * 16.0f;
                            ClientUtils.drawTexturedRect(11.0f, -22.0f - h, 16.0f, h, 0.04296875, 0.10546875, (214.0f - h) / 256.0f, 0.8359375);
                        }
                    }
                    if (upgrades.getBoolean("shock")) {
                        ClientUtils.drawTexturedRect(40.0f, -38.0f, 12.0f, 16.0f, 0.15625, 0.203125, 0.625, 0.6875);
                        if (upgrades.hasKey("shock_cooldown")) {
                            float h = (float)upgrades.getInteger("shock_cooldown") / 40.0f * 16.0f;
                            ClientUtils.drawTexturedRect(40.0f, -22.0f - h, 12.0f, h, 0.15625, 0.203125, (214.0f - h) / 256.0f, 0.8359375);
                        }
                    }
                    GlStateManager.disableBlend();
                    GlStateManager.popMatrix();
                }
                if ((mop = ClientUtils.mc().objectMouseOver) == null || mop.getBlockPos() == null) continue;
                TileEntity tileEntity = player.world.getTileEntity(mop.getBlockPos());
                if (!OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)true)) continue;
                int col = Config.IEConfig.nixietubeFont ? 0xFF9900 : 0xFFFFFF;
                String[] text = null;
                if (tileEntity instanceof IFluxReceiver) {
                    int maxStorage = ((IFluxReceiver)tileEntity).getMaxEnergyStored(mop.sideHit);
                    int storage = ((IFluxReceiver)tileEntity).getEnergyStored(mop.sideHit);
                    if (maxStorage > 0) {
                        text = I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                    }
                } else if (mop.entityHit instanceof IFluxReceiver) {
                    int maxStorage = ((IFluxReceiver)mop.entityHit).getMaxEnergyStored(null);
                    int storage = ((IFluxReceiver)mop.entityHit).getEnergyStored(null);
                    if (maxStorage > 0) {
                        text = I18n.format((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                    }
                }
                if (text == null) continue;
                if (player.world.getTotalWorldTime() % 20L == 0L) {
                    ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageRequestBlockUpdate(player.dimension, mop.getBlockPos()));
                }
                int i = 0;
                String[] stringArray = text;
                int n = stringArray.length;
                for (int uMax = 0; uMax < n; ++uMax) {
                    void s = stringArray[uMax];
                    if (s == null) continue;
                    int w = ClientProxy.nixieFontOptional.getStringWidth((String)s);
                    ClientProxy.nixieFontOptional.drawString((String)s, (float)(event.getResolution().getScaledWidth() / 2 - w / 2), (float)(event.getResolution().getScaledHeight() / 2 - 4 - text.length * (ClientProxy.nixieFontOptional.FONT_HEIGHT + 2) + i++ * (ClientProxy.nixieFontOptional.FONT_HEIGHT + 2)), col, true);
                }
            }
            if (ClientUtils.mc().objectMouseOver != null) {
                TileEntity tileEntity;
                boolean hammer = !player.getHeldItem(EnumHand.MAIN_HAND).isEmpty() && Utils.isHammer(player.getHeldItem(EnumHand.MAIN_HAND));
                RayTraceResult mop = ClientUtils.mc().objectMouseOver;
                if (mop != null && mop.getBlockPos() != null && (tileEntity = player.world.getTileEntity(mop.getBlockPos())) instanceof IEBlockInterfaces.IBlockOverlayText) {
                    IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                    String[] text = overlayBlock.getOverlayText((EntityPlayer)ClientUtils.mc().player, mop, hammer);
                    boolean useNixie = overlayBlock.useNixieFont((EntityPlayer)ClientUtils.mc().player, mop);
                    if (text != null && text.length > 0) {
                        FontRenderer font = useNixie ? ClientProxy.nixieFontOptional : ClientUtils.font();
                        int col = useNixie && Config.IEConfig.nixietubeFont ? 0xFF9900 : 0xFFFFFF;
                        int i = 0;
                        for (String s : text) {
                            if (s == null) continue;
                            font.drawString(s, (float)(event.getResolution().getScaledWidth() / 2 + 8), (float)(event.getResolution().getScaledHeight() / 2 + 8 + i++ * font.FONT_HEIGHT), col, true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFogUpdate(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).getActivePotionEffect(IEPotions.flashed) != null) {
            PotionEffect effect = ((EntityLivingBase)event.getEntity()).getActivePotionEffect(IEPotions.flashed);
            int timeLeft = effect.getDuration();
            float saturation = 1.0f - (float)timeLeft / (float)(80 + 40 * effect.getAmplifier());
            float f1 = -2.5f + 15.0f * saturation;
            if (timeLeft < 20) {
                f1 += event.getFarPlaneDistance() / 4.0f * (1.0f - (float)timeLeft / 20.0f);
            }
            GlStateManager.setFog((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            GlStateManager.setFogStart((float)(f1 * 0.25f));
            GlStateManager.setFogEnd((float)f1);
            GlStateManager.setFogDensity((float)0.125f);
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GlStateManager.glFogi((int)34138, (int)34139);
            }
        }
    }

    @SubscribeEvent
    public void onFogColourUpdate(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).getActivePotionEffect(IEPotions.flashed) != null) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP player = ClientUtils.mc().player;
        if (!player.getHeldItem(EnumHand.MAIN_HAND).isEmpty() && player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ZoomHandler.IZoomTool) {
            if (player.isSneaking() && player.onGround) {
                ItemStack equipped = player.getHeldItem(EnumHand.MAIN_HAND);
                ZoomHandler.IZoomTool tool = (ZoomHandler.IZoomTool)equipped.getItem();
                if (tool.canZoom(equipped, (EntityPlayer)player)) {
                    if (!ZoomHandler.isZooming) {
                        float[] steps = tool.getZoomSteps(equipped, (EntityPlayer)player);
                        if (steps != null && steps.length > 0) {
                            int curStep = -1;
                            float dist = 0.0f;
                            for (int i = 0; i < steps.length; ++i) {
                                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                                curStep = i;
                                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                            }
                            ZoomHandler.fovZoom = curStep != -1 ? steps[curStep] : event.getFov();
                        }
                        ZoomHandler.isZooming = true;
                    }
                    event.setNewfov(ZoomHandler.fovZoom);
                } else if (ZoomHandler.isZooming) {
                    ZoomHandler.isZooming = false;
                }
            } else if (ZoomHandler.isZooming) {
                ZoomHandler.isZooming = false;
            }
        } else if (ZoomHandler.isZooming) {
            ZoomHandler.isZooming = false;
        }
        if (player.getActivePotionEffect(IEPotions.concreteFeet) != null) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player;
        if (event.getDwheel() != 0 && !(player = ClientUtils.mc().player).getHeldItem(EnumHand.MAIN_HAND).isEmpty() && player.isSneaking()) {
            float[] steps;
            ZoomHandler.IZoomTool tool;
            ItemStack equipped = player.getHeldItem(EnumHand.MAIN_HAND);
            if (equipped.getItem() instanceof ZoomHandler.IZoomTool && (tool = (ZoomHandler.IZoomTool)equipped.getItem()).canZoom(equipped, (EntityPlayer)player) && (steps = tool.getZoomSteps(equipped, (EntityPlayer)player)) != null && steps.length > 0) {
                int curStep = -1;
                float dist = 0.0f;
                for (int i = 0; i < steps.length; ++i) {
                    if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                    curStep = i;
                    dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                }
                if (curStep != -1) {
                    int newStep = curStep + (event.getDwheel() > 0 ? -1 : 1);
                    if (newStep >= 0 && newStep < steps.length) {
                        ZoomHandler.fovZoom = steps[newStep];
                    }
                    event.setCanceled(true);
                }
            }
            if (Config.IEConfig.Tools.chemthrower_scroll && equipped.getItem() instanceof ItemChemthrower && ((ItemChemthrower)equipped.getItem()).getUpgrades(equipped).getBoolean("multitank")) {
                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageChemthrowerSwitch(player.getName(), event.getDwheel() < 0));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onKey(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (event.getGui() instanceof GuiToolbox && Mouse.getEventButton() == 2) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawBlockHighlightEvent event) {
        if (event.getSubID() == 0 && event.getTarget().typeOfHit == RayTraceResult.Type.BLOCK) {
            ItemStack head;
            IEBlockInterfaces.IAdvancedSelectionBounds iasb;
            List<AxisAlignedBB> boxes;
            float f1 = 0.002f;
            double px = -TileEntityRendererDispatcher.staticPlayerX;
            double py = -TileEntityRendererDispatcher.staticPlayerY;
            double pz = -TileEntityRendererDispatcher.staticPlayerZ;
            TileEntity tile = event.getPlayer().world.getTileEntity(event.getTarget().getBlockPos());
            ItemStack stack = event.getPlayer().getHeldItem(EnumHand.MAIN_HAND);
            if (tile instanceof IEBlockInterfaces.IAdvancedSelectionBounds && (boxes = (iasb = (IEBlockInterfaces.IAdvancedSelectionBounds)tile).getAdvancedSelectionBounds()) != null && !boxes.isEmpty()) {
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.glLineWidth((float)2.0f);
                GlStateManager.disableTexture2D();
                GlStateManager.depthMask((boolean)false);
                ArrayList<AxisAlignedBB> additionalBoxes = new ArrayList<AxisAlignedBB>();
                AxisAlignedBB overrideBox = null;
                for (AxisAlignedBB aabb : boxes) {
                    if (aabb == null || !iasb.isOverrideBox(aabb, event.getPlayer(), event.getTarget(), additionalBoxes)) continue;
                    overrideBox = aabb;
                }
                if (overrideBox != null) {
                    RenderGlobal.drawSelectionBoundingBox((AxisAlignedBB)overrideBox.grow((double)f1).offset(px, py, pz), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                } else {
                    for (AxisAlignedBB aabb : additionalBoxes.isEmpty() ? boxes : additionalBoxes) {
                        RenderGlobal.drawSelectionBoundingBox((AxisAlignedBB)aabb.grow((double)f1).offset(px, py, pz), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    }
                }
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableTexture2D();
                GlStateManager.disableBlend();
                event.setCanceled(true);
            }
            if (Utils.isHammer(stack) && tile instanceof TileEntityTurntable) {
                BlockPos pos = event.getTarget().getBlockPos();
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.glLineWidth((float)2.0f);
                GlStateManager.disableTexture2D();
                GlStateManager.depthMask((boolean)false);
                Tessellator tessellator = Tessellator.getInstance();
                BufferBuilder BufferBuilder2 = tessellator.getBuffer();
                EnumFacing f = ((TileEntityTurntable)tile).getFacing();
                double tx = (double)pos.getX() + 0.5;
                double ty = (double)pos.getY() + 0.5;
                double tz = (double)pos.getZ() + 0.5;
                if (!event.getPlayer().world.isAirBlock(pos.offset(f))) {
                    tx += (double)f.getFrontOffsetX();
                    ty += (double)f.getFrontOffsetY();
                    tz += (double)f.getFrontOffsetZ();
                }
                BufferBuilder2.setTranslation(tx + px, ty + py, tz + pz);
                double angle = (double)(-event.getPlayer().ticksExisted % 80) / 40.0 * Math.PI;
                ClientEventHandler.drawRotationArrows(tessellator, BufferBuilder2, f, angle, ((TileEntityTurntable)tile).invert);
                BufferBuilder2.setTranslation(0.0, 0.0, 0.0);
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableTexture2D();
                GlStateManager.disableBlend();
            }
            World world = event.getPlayer().world;
            if (!stack.isEmpty() && IEContent.blockConveyor.equals(Block.getBlockFromItem((Item)stack.getItem())) && event.getTarget().sideHit.getAxis() == EnumFacing.Axis.Y) {
                EnumFacing side = event.getTarget().sideHit;
                BlockPos pos = event.getTarget().getBlockPos();
                AxisAlignedBB targetedBB = world.getBlockState(pos).getSelectedBoundingBox(world, pos);
                if (targetedBB != null) {
                    targetedBB = targetedBB.offset((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
                }
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.glLineWidth((float)2.0f);
                GlStateManager.disableTexture2D();
                GlStateManager.depthMask((boolean)false);
                Tessellator tessellator = Tessellator.getInstance();
                BufferBuilder BufferBuilder3 = tessellator.getBuffer();
                BufferBuilder3.setTranslation((double)pos.getX() + px, (double)pos.getY() + py, (double)pos.getZ() + pz);
                double[][] points = new double[4][];
                if (side.getAxis() == EnumFacing.Axis.Y) {
                    points[0] = new double[]{0.0f - f1, side == EnumFacing.DOWN ? (targetedBB != null ? targetedBB.minY : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxY : 1.0) + (double)f1, 0.0f - f1};
                    points[1] = new double[]{1.0f + f1, side == EnumFacing.DOWN ? (targetedBB != null ? targetedBB.minY : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxY : 1.0) + (double)f1, 1.0f + f1};
                    points[2] = new double[]{0.0f - f1, side == EnumFacing.DOWN ? (targetedBB != null ? targetedBB.minY : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxY : 1.0) + (double)f1, 1.0f + f1};
                    points[3] = new double[]{1.0f + f1, side == EnumFacing.DOWN ? (targetedBB != null ? targetedBB.minY : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxY : 1.0) + (double)f1, 0.0f - f1};
                } else if (side.getAxis() == EnumFacing.Axis.Z) {
                    points[0] = new double[]{1.0f + f1, 1.0f + f1, side == EnumFacing.NORTH ? (targetedBB != null ? targetedBB.minZ : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxZ : 1.0) + (double)f1};
                    points[1] = new double[]{0.0f - f1, 0.0f - f1, side == EnumFacing.NORTH ? (targetedBB != null ? targetedBB.minZ : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxZ : 1.0) + (double)f1};
                    points[2] = new double[]{0.0f - f1, 1.0f + f1, side == EnumFacing.NORTH ? (targetedBB != null ? targetedBB.minZ : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxZ : 1.0) + (double)f1};
                    points[3] = new double[]{1.0f + f1, 0.0f - f1, side == EnumFacing.NORTH ? (targetedBB != null ? targetedBB.minZ : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxZ : 1.0) + (double)f1};
                } else {
                    points[0] = new double[]{side == EnumFacing.WEST ? (targetedBB != null ? targetedBB.minX : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxX : 1.0) + (double)f1, 1.0f + f1, 1.0f + f1};
                    points[1] = new double[]{side == EnumFacing.WEST ? (targetedBB != null ? targetedBB.minX : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxX : 1.0) + (double)f1, 0.0f - f1, 0.0f - f1};
                    points[2] = new double[]{side == EnumFacing.WEST ? (targetedBB != null ? targetedBB.minX : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxX : 1.0) + (double)f1, 1.0f + f1, 0.0f - f1};
                    points[3] = new double[]{side == EnumFacing.WEST ? (targetedBB != null ? targetedBB.minX : 0.0) - (double)f1 : (targetedBB != null ? targetedBB.maxX : 1.0) + (double)f1, 0.0f - f1, 1.0f + f1};
                }
                BufferBuilder3.begin(1, DefaultVertexFormats.POSITION_COLOR);
                for (double[] point : points) {
                    BufferBuilder3.pos(point[0], point[1], point[2]).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                }
                tessellator.draw();
                BufferBuilder3.begin(2, DefaultVertexFormats.POSITION_COLOR);
                BufferBuilder3.pos(points[0][0], points[0][1], points[0][2]).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                BufferBuilder3.pos(points[2][0], points[2][1], points[2][2]).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                BufferBuilder3.pos(points[1][0], points[1][1], points[1][2]).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                BufferBuilder3.pos(points[3][0], points[3][1], points[3][2]).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                tessellator.draw();
                float xFromMid = side.getAxis() == EnumFacing.Axis.X ? 0.0f : (float)event.getTarget().hitVec.x - (float)pos.getX() - 0.5f;
                float yFromMid = side.getAxis() == EnumFacing.Axis.Y ? 0.0f : (float)event.getTarget().hitVec.y - (float)pos.getY() - 0.5f;
                float zFromMid = side.getAxis() == EnumFacing.Axis.Z ? 0.0f : (float)event.getTarget().hitVec.z - (float)pos.getZ() - 0.5f;
                float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
                Vec3d dir = new Vec3d(max == Math.abs(xFromMid) ? (double)Math.signum(xFromMid) : 0.0, max == Math.abs(yFromMid) ? (double)Math.signum(yFromMid) : 0.0, max == Math.abs(zFromMid) ? (double)Math.signum(zFromMid) : 0.0);
                if (dir != null) {
                    ClientEventHandler.drawBlockOverlayArrow(tessellator, BufferBuilder3, dir, side, targetedBB);
                }
                BufferBuilder3.setTranslation(0.0, 0.0, 0.0);
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableTexture2D();
                GlStateManager.disableBlend();
            }
            if (!stack.isEmpty() && stack.getItem() instanceof ItemDrill && ((ItemDrill)stack.getItem()).isEffective(world.getBlockState(event.getTarget().getBlockPos()).getMaterial()) && !(head = ((ItemDrill)stack.getItem()).getHead(stack)).isEmpty()) {
                ImmutableList<BlockPos> blocks = ((IDrillHead)head.getItem()).getExtraBlocksDug(head, world, event.getPlayer(), event.getTarget());
                ClientEventHandler.drawAdditionalBlockbreak(event.getContext(), event.getPlayer(), event.getPartialTicks(), blocks);
            }
        }
    }

    public static void drawRotationArrows(Tessellator tessellator, BufferBuilder BufferBuilder2, EnumFacing facing, double rotation, boolean flip) {
        double zz;
        double yy;
        double xx;
        double h;
        double w;
        double cos = Math.cos(rotation);
        double sin = Math.sin(rotation);
        BufferBuilder2.begin(2, DefaultVertexFormats.POSITION_COLOR);
        for (double[] p : rotationArrowCoords) {
            w = cos * p[0] + sin * p[1];
            h = -sin * p[0] + cos * p[1];
            double d = facing.getFrontOffsetX() < 0 ? -0.502 : (facing.getFrontOffsetX() > 0 ? 0.502 : (xx = (double)((facing.getAxis() == EnumFacing.Axis.Y ^ flip ? -1 : 1) * facing.getAxisDirection().getOffset()) * h));
            double d2 = facing.getFrontOffsetY() < 0 ? -0.502 : (yy = facing.getFrontOffsetY() > 0 ? 0.502 : w);
            zz = facing.getFrontOffsetZ() < 0 ? -0.502 : (facing.getFrontOffsetZ() > 0 ? 0.502 : (facing.getAxis() == EnumFacing.Axis.X ? (double)((flip ? 1 : -1) * facing.getAxisDirection().getOffset()) * h : w));
            BufferBuilder2.pos(xx, yy, zz).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
        }
        tessellator.draw();
        BufferBuilder2.begin(2, DefaultVertexFormats.POSITION_COLOR);
        for (double[] p : rotationArrowCoords) {
            w = cos * p[0] + sin * p[1];
            h = -sin * p[0] + cos * p[1];
            double d = facing.getFrontOffsetX() < 0 ? -0.502 : (facing.getFrontOffsetX() > 0 ? 0.502 : (xx = (double)((facing.getAxis() == EnumFacing.Axis.Y ^ flip ? 1 : -1) * facing.getAxisDirection().getOffset()) * h));
            double d3 = facing.getFrontOffsetY() < 0 ? -0.502 : (yy = facing.getFrontOffsetY() > 0 ? 0.502 : -w);
            zz = facing.getFrontOffsetZ() < 0 ? -0.502 : (facing.getFrontOffsetZ() > 0 ? 0.502 : (facing.getAxis() == EnumFacing.Axis.X ? (double)((flip ? -1 : 1) * facing.getAxisDirection().getOffset()) * h : -w));
            BufferBuilder2.pos(xx, yy, zz).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
        }
        tessellator.draw();
        BufferBuilder2.begin(8, DefaultVertexFormats.POSITION_COLOR);
        for (double[] p : rotationArrowQuads) {
            w = cos * p[0] + sin * p[1];
            h = -sin * p[0] + cos * p[1];
            double d = facing.getFrontOffsetX() < 0 ? -0.502 : (facing.getFrontOffsetX() > 0 ? 0.502 : (xx = (double)((facing.getAxis() == EnumFacing.Axis.Y ^ flip ? -1 : 1) * facing.getAxisDirection().getOffset()) * h));
            double d4 = facing.getFrontOffsetY() < 0 ? -0.502 : (yy = facing.getFrontOffsetY() > 0 ? 0.502 : w);
            zz = facing.getFrontOffsetZ() < 0 ? -0.502 : (facing.getFrontOffsetZ() > 0 ? 0.502 : (facing.getAxis() == EnumFacing.Axis.X ? (double)((flip ? 1 : -1) * facing.getAxisDirection().getOffset()) * h : w));
            BufferBuilder2.pos(xx, yy, zz).color(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).endVertex();
        }
        tessellator.draw();
        BufferBuilder2.begin(8, DefaultVertexFormats.POSITION_COLOR);
        for (double[] p : rotationArrowQuads) {
            w = cos * p[0] + sin * p[1];
            h = -sin * p[0] + cos * p[1];
            double d = facing.getFrontOffsetX() < 0 ? -0.502 : (facing.getFrontOffsetX() > 0 ? 0.502 : (xx = (double)((facing.getAxis() == EnumFacing.Axis.Y ^ flip ? 1 : -1) * facing.getAxisDirection().getOffset()) * h));
            double d5 = facing.getFrontOffsetY() < 0 ? -0.502 : (yy = facing.getFrontOffsetY() > 0 ? 0.502 : -w);
            zz = facing.getFrontOffsetZ() < 0 ? -0.502 : (facing.getFrontOffsetZ() > 0 ? 0.502 : (facing.getAxis() == EnumFacing.Axis.X ? (double)((flip ? -1 : 1) * facing.getAxisDirection().getOffset()) * h : -w));
            BufferBuilder2.pos(xx, yy, zz).color(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).endVertex();
        }
        tessellator.draw();
    }

    public static void drawBlockOverlayArrow(Tessellator tessellator, BufferBuilder BufferBuilder2, Vec3d directionVec, EnumFacing side, AxisAlignedBB targetedBB) {
        Vec3d[] translatedPositions = new Vec3d[arrowCoords.length];
        Matrix4 mat = new Matrix4();
        Vec3d defaultDir = side.getAxis() == EnumFacing.Axis.Y ? new Vec3d(0.0, 0.0, 1.0) : new Vec3d(0.0, 1.0, 0.0);
        directionVec = directionVec.normalize();
        double angle = Math.acos(defaultDir.dotProduct(directionVec));
        Vec3d axis = defaultDir.crossProduct(directionVec);
        mat.rotate(angle, axis.x, axis.y, axis.z);
        if (side != null) {
            if (side.getAxis() == EnumFacing.Axis.Z) {
                mat.rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(Math.PI, 0.0, 1.0, 0.0);
            } else if (side.getAxis() == EnumFacing.Axis.X) {
                mat.rotate(1.5707963267948966, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0);
            }
        }
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3d vec = mat.apply(new Vec3d((double)arrowCoords[i][0], 0.0, (double)arrowCoords[i][1])).addVector(0.5, 0.5, 0.5);
            if (side != null && targetedBB != null) {
                vec = new Vec3d(side == EnumFacing.WEST ? targetedBB.minX - 0.002 : (side == EnumFacing.EAST ? targetedBB.maxX + 0.002 : vec.x), side == EnumFacing.DOWN ? targetedBB.minY - 0.002 : (side == EnumFacing.UP ? targetedBB.maxY + 0.002 : vec.y), side == EnumFacing.NORTH ? targetedBB.minZ - 0.002 : (side == EnumFacing.SOUTH ? targetedBB.maxZ + 0.002 : vec.z));
            }
            translatedPositions[i] = vec;
        }
        BufferBuilder2.begin(6, DefaultVertexFormats.POSITION_COLOR);
        for (Vec3d point : translatedPositions) {
            BufferBuilder2.pos(point.x, point.y, point.z).color(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).endVertex();
        }
        tessellator.draw();
        BufferBuilder2.begin(2, DefaultVertexFormats.POSITION_COLOR);
        for (Vec3d point : translatedPositions) {
            BufferBuilder2.pos(point.x, point.y, point.z).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
        }
        tessellator.draw();
    }

    public static void drawAdditionalBlockbreak(RenderGlobal context, EntityPlayer player, float partialTicks, Collection<BlockPos> blocks) {
        for (BlockPos pos : blocks) {
            context.drawSelectionBox(player, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), null, pos), 0, partialTicks);
        }
        PlayerControllerMP controllerMP = ClientUtils.mc().playerController;
        if (controllerMP.isHittingBlock) {
            ClientUtils.drawBlockDamageTexture(ClientUtils.tes(), ClientUtils.tes().getBuffer(), (Entity)player, partialTicks, player.world, blocks);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        boolean chunkBorders = false;
        for (EnumHand hand : EnumHand.values()) {
            if (!OreDictionary.itemMatches((ItemStack)new ItemStack((Block)IEContent.blockMetalDevice1, 1, BlockTypes_MetalDevice1.SAMPLE_DRILL.getMeta()), (ItemStack)ClientUtils.mc().player.getHeldItem(hand), (boolean)true)) continue;
            chunkBorders = true;
            break;
        }
        if (!chunkBorders && ClientUtils.mc().objectMouseOver != null && ClientUtils.mc().objectMouseOver.typeOfHit == RayTraceResult.Type.BLOCK && ClientUtils.mc().world.getTileEntity(ClientUtils.mc().objectMouseOver.getBlockPos()) instanceof TileEntitySampleDrill) {
            chunkBorders = true;
        }
        if (chunkBorders) {
            EntityPlayerSP player = ClientUtils.mc().player;
            double px = TileEntityRendererDispatcher.staticPlayerX;
            double py = TileEntityRendererDispatcher.staticPlayerY;
            double pz = TileEntityRendererDispatcher.staticPlayerZ;
            int chunkX = (int)player.posX >> 4 << 4;
            int chunkZ = (int)player.posZ >> 4 << 4;
            int y = Math.min((int)player.posY - 2, player.getEntityWorld().getChunkFromBlockCoords(new BlockPos(player.posX, 0.0, player.posZ)).getLowestHeight());
            float h = (float)Math.max(32.0, player.posY - (double)y + 4.0);
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder BufferBuilder2 = tessellator.getBuffer();
            GlStateManager.disableTexture2D();
            GlStateManager.enableBlend();
            GlStateManager.disableCull();
            GlStateManager.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.shadeModel((int)7425);
            float r = Lib.COLOUR_F_ImmersiveOrange[0];
            float g = Lib.COLOUR_F_ImmersiveOrange[1];
            float b = Lib.COLOUR_F_ImmersiveOrange[2];
            BufferBuilder2.setTranslation((double)chunkX - px, (double)(y + 2) - py, (double)chunkZ - pz);
            GlStateManager.glLineWidth((float)5.0f);
            BufferBuilder2.begin(1, DefaultVertexFormats.POSITION_COLOR);
            BufferBuilder2.pos(0.0, 0.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, (double)h, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 0.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, (double)h, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 0.0, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, (double)h, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, 0.0, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, (double)h, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, 2.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 2.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, 2.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, 2.0, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(0.0, 2.0, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 2.0, 16.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 2.0, 0.0).color(r, g, b, 0.375f).endVertex();
            BufferBuilder2.pos(16.0, 2.0, 16.0).color(r, g, b, 0.375f).endVertex();
            tessellator.draw();
            BufferBuilder2.setTranslation(0.0, 0.0, 0.0);
            GlStateManager.shadeModel((int)7424);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GlStateManager.enableTexture2D();
        }
    }

    @SubscribeEvent
    public void onClientDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity().getEntityData().hasKey("headshot")) {
            ModelBase model = event.getRenderer().mainModel;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).bipedHead.showModel = false;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).villagerHead.showModel = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.getEntity().getEntityData().hasKey("headshot")) {
            ModelBase model = event.getRenderer().mainModel;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).bipedHead.showModel = true;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).villagerHead.showModel = true;
            }
        }
    }
}

