/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ExcavatorHandler {
    public static LinkedHashMap<MineralMix, Integer> mineralList = new LinkedHashMap();
    public static HashMap<DimensionChunkCoords, MineralWorldInfo> mineralCache = new HashMap();
    private static HashMap<Integer, Integer> dimensionBasedTotalWeight = new HashMap();
    public static int mineralVeinCapacity = 0;
    public static double mineralChance = 0.0;
    public static int[] defaultDimensionBlacklist = new int[0];
    public static boolean allowPackets = false;

    public static MineralMix addMineral(String name, int mineralWeight, float failChance, String[] ores, float[] chances) {
        assert (ores.length == chances.length);
        MineralMix mix = new MineralMix(name, failChance, ores, chances);
        mineralList.put(mix, mineralWeight);
        return mix;
    }

    public static void recalculateChances(boolean mutePackets) {
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            e.getKey().recalculateChances();
        }
        dimensionBasedTotalWeight.clear();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && allowPackets && !mutePackets) {
            HashMap<MineralMix, Integer> packetMap = new HashMap<MineralMix, Integer>();
            for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
        }
    }

    public static int getDimensionTotalWeight(int dim) {
        if (dimensionBasedTotalWeight.containsKey(dim)) {
            return dimensionBasedTotalWeight.get(dim);
        }
        int totalWeight = 0;
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            e.getKey().recalculateChances();
            if (!e.getKey().isValid() || !e.getKey().validDimension(dim)) continue;
            totalWeight += e.getValue().intValue();
        }
        dimensionBasedTotalWeight.put(dim, totalWeight);
        return totalWeight;
    }

    public static MineralMix getRandomMineral(World world, int chunkX, int chunkZ) {
        if (world.isRemote) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.mineral == null && info.mineralOverride == null) {
            return null;
        }
        if (mineralVeinCapacity >= 0 && info.depletion > mineralVeinCapacity) {
            return null;
        }
        return info.mineralOverride != null ? info.mineralOverride : info.mineral;
    }

    public static MineralWorldInfo getMineralWorldInfo(World world, int chunkX, int chunkZ) {
        if (world.isRemote) {
            return null;
        }
        int dim = world.provider.getDimension();
        DimensionChunkCoords coords = new DimensionChunkCoords(dim, chunkX, chunkZ);
        MineralWorldInfo worldInfo = mineralCache.get((Object)coords);
        if (worldInfo == null) {
            MineralMix mix = null;
            Random r = world.getChunkFromChunkCoords(chunkX, chunkZ).getRandomWithSeed(940610L);
            double dd = r.nextDouble();
            boolean empty = dd > mineralChance;
            int query = r.nextInt();
            if (!empty) {
                int weight = Math.abs(query % ExcavatorHandler.getDimensionTotalWeight(dim));
                for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
                    if (!e.getKey().isValid() || !e.getKey().validDimension(dim) || (weight -= e.getValue().intValue()) >= 0) continue;
                    mix = e.getKey();
                    break;
                }
            }
            worldInfo = new MineralWorldInfo();
            worldInfo.mineral = mix;
            mineralCache.put(coords, worldInfo);
        }
        return worldInfo;
    }

    public static void depleteMinerals(World world, int chunkX, int chunkZ) {
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        ++info.depletion;
        IESaveData.setDirty(world.provider.getDimension());
    }

    public static class MineralWorldInfo {
        public MineralMix mineral;
        public MineralMix mineralOverride;
        public int depletion;

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.mineral != null) {
                tag.setString("mineral", this.mineral.name);
            }
            if (this.mineralOverride != null) {
                tag.setString("mineralOverride", this.mineralOverride.name);
            }
            tag.setInteger("depletion", this.depletion);
            return tag;
        }

        public static MineralWorldInfo readFromNBT(NBTTagCompound tag) {
            String s;
            MineralWorldInfo info = new MineralWorldInfo();
            if (tag.hasKey("mineral")) {
                s = tag.getString("mineral");
                for (MineralMix mineral : mineralList.keySet()) {
                    if (!s.equalsIgnoreCase(mineral.name)) continue;
                    info.mineral = mineral;
                }
            }
            if (tag.hasKey("mineralOverride")) {
                s = tag.getString("mineralOverride");
                for (MineralMix mineral : mineralList.keySet()) {
                    if (!s.equalsIgnoreCase(mineral.name)) continue;
                    info.mineralOverride = mineral;
                }
            }
            info.depletion = tag.getInteger("depletion");
            return info;
        }
    }

    public static class MineralMix {
        public String name;
        public float failChance;
        public String[] ores;
        public float[] chances;
        public NonNullList<ItemStack> oreOutput;
        public float[] recalculatedChances;
        boolean isValid = false;
        public HashMap<String, String> replacementOres;
        public int[] dimensionWhitelist = new int[0];
        public int[] dimensionBlacklist = new int[0];

        public MineralMix(String name, float failChance, String[] ores, float[] chances) {
            this.name = name;
            this.failChance = failChance;
            this.ores = ores;
            this.chances = chances;
            this.dimensionBlacklist = (int[])defaultDimensionBlacklist.clone();
        }

        public MineralMix addReplacement(String original, String replacement) {
            if (this.replacementOres == null) {
                this.replacementOres = new HashMap();
            }
            this.replacementOres.put(original, replacement);
            return this;
        }

        public void recalculateChances() {
            int i;
            double chanceSum = 0.0;
            NonNullList existing = NonNullList.create();
            ArrayList<Double> reChances = new ArrayList<Double>();
            for (i = 0; i < this.ores.length; ++i) {
                ItemStack preferredOre;
                String ore = this.ores[i];
                if (this.replacementOres != null && !ApiUtils.isExistingOreName(ore) && this.replacementOres.containsKey(ore)) {
                    ore = this.replacementOres.get(ore);
                }
                if (ore == null || ore.isEmpty() || !ApiUtils.isExistingOreName(ore) || (preferredOre = IEApi.getPreferredOreStack(ore)).isEmpty()) continue;
                existing.add((Object)preferredOre);
                reChances.add(Double.valueOf(this.chances[i]));
                chanceSum += (double)this.chances[i];
            }
            this.isValid = existing.size() > 0;
            this.oreOutput = existing;
            this.recalculatedChances = new float[reChances.size()];
            for (i = 0; i < reChances.size(); ++i) {
                this.recalculatedChances[i] = (float)((Double)reChances.get(i) / chanceSum);
            }
        }

        public ItemStack getRandomOre(Random rand) {
            float r = rand.nextFloat();
            for (int i = 0; i < this.recalculatedChances.length; ++i) {
                if (!((r -= this.recalculatedChances[i]) < 0.0f)) continue;
                return (ItemStack)this.oreOutput.get(i);
            }
            return ItemStack.EMPTY;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean validDimension(int dim) {
            if (this.dimensionWhitelist != null && this.dimensionWhitelist.length > 0) {
                for (int white : this.dimensionWhitelist) {
                    if (dim != white) continue;
                    return true;
                }
                return false;
            }
            if (this.dimensionBlacklist != null && this.dimensionBlacklist.length > 0) {
                for (int black : this.dimensionBlacklist) {
                    if (dim != black) continue;
                    return false;
                }
                return true;
            }
            return true;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setString("name", this.name);
            tag.setFloat("failChance", this.failChance);
            NBTTagList tagList = new NBTTagList();
            for (String ore : this.ores) {
                tagList.appendTag((NBTBase)new NBTTagString(ore));
            }
            tag.setTag("ores", (NBTBase)tagList);
            tagList = new NBTTagList();
            for (float chance : this.chances) {
                tagList.appendTag((NBTBase)new NBTTagFloat(chance));
            }
            tag.setTag("chances", (NBTBase)tagList);
            tagList = new NBTTagList();
            if (this.oreOutput != null) {
                for (ItemStack output : this.oreOutput) {
                    tagList.appendTag((NBTBase)output.writeToNBT(new NBTTagCompound()));
                }
            }
            tag.setTag("oreOutput", (NBTBase)tagList);
            tagList = new NBTTagList();
            for (float chance : this.recalculatedChances) {
                tagList.appendTag((NBTBase)new NBTTagFloat(chance));
            }
            tag.setTag("recalculatedChances", (NBTBase)tagList);
            tag.setBoolean("isValid", this.isValid);
            tag.setIntArray("dimensionWhitelist", this.dimensionWhitelist);
            tag.setIntArray("dimensionBlacklist", this.dimensionBlacklist);
            return tag;
        }

        public static MineralMix readFromNBT(NBTTagCompound tag) {
            String name = tag.getString("name");
            float failChance = tag.getFloat("failChance");
            NBTTagList tagList = tag.getTagList("ores", 8);
            String[] ores = new String[tagList.tagCount()];
            for (int i = 0; i < ores.length; ++i) {
                ores[i] = tagList.getStringTagAt(i);
            }
            tagList = tag.getTagList("chances", 5);
            float[] chances = new float[tagList.tagCount()];
            for (int i = 0; i < chances.length; ++i) {
                chances[i] = tagList.getFloatAt(i);
            }
            tagList = tag.getTagList("oreOutput", 10);
            NonNullList oreOutput = NonNullList.withSize((int)tagList.tagCount(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < oreOutput.size(); ++i) {
                oreOutput.set(i, (Object)new ItemStack(tagList.getCompoundTagAt(i)));
            }
            tagList = tag.getTagList("recalculatedChances", 5);
            float[] recalculatedChances = new float[tagList.tagCount()];
            for (int i = 0; i < recalculatedChances.length; ++i) {
                recalculatedChances[i] = tagList.getFloatAt(i);
            }
            boolean isValid = tag.getBoolean("isValid");
            MineralMix mix = new MineralMix(name, failChance, ores, chances);
            mix.oreOutput = oreOutput;
            mix.recalculatedChances = recalculatedChances;
            mix.isValid = isValid;
            mix.dimensionWhitelist = tag.getIntArray("dimensionWhitelist");
            mix.dimensionBlacklist = tag.getIntArray("dimensionBlacklist");
            return mix;
        }
    }
}

